/*
 * Decompiled with CFR 0.152.
 */
package com.bjzw.datasync.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    public static final String DEFAULT_CODING = "UTF-8";

    public static RestTemplate getInstance(Proxy proxy, int connTimeout, int readTimeout, boolean enableSslCheck) {
        RestTemplate restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory requestFactory = !enableSslCheck ? HttpUtils.getUnsafeClientHttpRequestFactory() : new SimpleClientHttpRequestFactory();
        if (proxy != null) {
            requestFactory.setProxy(proxy);
        }
        requestFactory.setConnectTimeout(connTimeout);
        requestFactory.setReadTimeout(readTimeout);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }

    private static SimpleClientHttpRequestFactory getUnsafeClientHttpRequestFactory() {
        SSLContext sslContext;
        TrustManager[] byPassTrustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, byPassTrustManagers, new SecureRandom());
            sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return new SimpleClientHttpRequestFactory(){

            protected void prepareConnection(HttpURLConnection connection, @NotNull String httpMethod) throws IOException {
                super.prepareConnection(connection, httpMethod);
                if (connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
                }
            }
        };
    }

    public static RestTemplate getInstance(Proxy proxy, boolean enableSsLCheck) {
        return HttpUtils.getInstance(proxy, -1, -1, enableSsLCheck);
    }

    public static String postUrlEncodeForm(String url, Map<String, Object> map, String coding) throws Exception {
        if (null == coding || "".equals(coding)) {
            coding = DEFAULT_CODING;
        }
        String result = "";
        ArrayList<BasicNameValuePair> valuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            BasicNameValuePair valuePair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
            valuePairs.add(valuePair);
        }
        logger.info("\u8bf7\u6c42\u53c2\u6570\u5904\u7406\u5b8c\u6210\uff1aNameValuePair={}", (Object)JSONObject.toJSONString(valuePairs));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        post.addHeader("content-type", "application/x-www-form-urlencoded");
        post.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63");
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(valuePairs, coding);
        post.setEntity((HttpEntity)entity);
        logger.info("client\u8bf7\u6c42\u53c2\u6570\uff0cpost={}", (Object)post);
        HttpResponse response = client.execute((HttpUriRequest)post);
        logger.info("\u8fd4\u56de\u7ed3\u679c\uff1aHttpResponse={}", (Object)JSONObject.toJSONString((Object)response));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new RuntimeException("statusCode = [" + statusCode + "]");
        }
        HttpEntity respEntity = response.getEntity();
        result = EntityUtils.toString((HttpEntity)respEntity, (String)coding);
        return result;
    }
}

