/*
 * Decompiled with CFR 0.152.
 */
package com.bjzw.datasync.utils;

import com.bjzw.datasync.utils.SftpConfig;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SftpChannel {
    Session session = null;
    Channel channel = null;
    public static final int SFTP_DEFAULT_PORT = 22;

    public ChannelSftp connectByIdentity(SftpConfig sftpConfig) throws JSchException {
        JSch jsch = new JSch();
        int port = 22;
        if (StringUtils.isNotBlank((CharSequence)sftpConfig.getPrivateKeyPath())) {
            if (StringUtils.isNotBlank((CharSequence)sftpConfig.getPassphrase())) {
                jsch.addIdentity(sftpConfig.getPrivateKeyPath(), sftpConfig.getPassphrase());
            } else {
                jsch.addIdentity(sftpConfig.getPrivateKeyPath());
            }
        }
        if (sftpConfig.getPort() != null) {
            port = sftpConfig.getPort();
        }
        this.session = port > 0 ? jsch.getSession(sftpConfig.getUsername(), sftpConfig.getIp(), port) : jsch.getSession(sftpConfig.getUsername(), sftpConfig.getIp());
        if (this.session == null) {
            throw new JSchException("session\u4e3a\u7a7a\uff0c\u8fde\u63a5\u5931\u8d25");
        }
        Properties sshConfig = new Properties();
        sshConfig.put("StrictHostKeyChecking", "no");
        this.session.setConfig(sshConfig);
        this.session.setTimeout(30000);
        this.session.connect();
        this.channel = this.session.openChannel("sftp");
        this.channel.connect();
        return (ChannelSftp)this.channel;
    }

    public ChannelSftp connectByPwd(SftpConfig sftpConfig) throws JSchException {
        JSch jsch = new JSch();
        int port = 22;
        if (sftpConfig.getPort() != null) {
            port = sftpConfig.getPort();
        }
        this.session = port > 0 ? jsch.getSession(sftpConfig.getUsername(), sftpConfig.getIp(), port) : jsch.getSession(sftpConfig.getUsername(), sftpConfig.getIp());
        if (this.session == null) {
            throw new JSchException("session\u4e3a\u7a7a\uff0c\u8fde\u63a5\u5931\u8d25");
        }
        this.session.setPassword(sftpConfig.getPwd());
        Properties sshConfig = new Properties();
        sshConfig.put("StrictHostKeyChecking", "no");
        this.session.setConfig(sshConfig);
        this.session.setTimeout(30000);
        this.session.connect();
        this.channel = this.session.openChannel("sftp");
        this.channel.connect();
        return (ChannelSftp)this.channel;
    }

    public void closeChannel() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }
}

