/*
 * Decompiled with CFR 0.152.
 */
package com.bjzw.datasync.utils;

import com.bjzw.datasync.utils.SftpChannel;
import com.bjzw.datasync.utils.SftpConfig;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpUtils {
    private static Logger logger = LoggerFactory.getLogger(SftpUtils.class);

    public static SftpConfig getSftpObj(String param) {
        SftpConfig sftpConfig = new SftpConfig();
        if (StringUtils.isNotBlank((CharSequence)param)) {
            JSONObject jsonObj = JSONObject.fromObject((Object)param);
            sftpConfig = (SftpConfig)JSONObject.toBean((JSONObject)jsonObj, SftpConfig.class);
        }
        return sftpConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upload(SftpConfig config, String baseDir, String fileName, String filePath) {
        logger.info("\u8def\u5f84\uff1abaseDir=" + baseDir);
        SftpChannel sftpChannel = new SftpChannel();
        ChannelSftp sftp = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)config.getPrivateKeyPath())) {
                sftp = sftpChannel.connectByIdentity(config);
            } else {
                logger.info("\u4f7f\u7528\u5bc6\u7801\u521b\u5efa\u8fde\u63a5");
                sftp = sftpChannel.connectByPwd(config);
            }
            if (!sftp.isConnected()) {
                logger.error("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25");
                boolean bl = false;
                return bl;
            }
            logger.info("\u8fde\u63a5\u670d\u52a1\u5668\u6210\u529f");
            if (!SftpUtils.isExist(sftp, baseDir)) {
                logger.error("\u521b\u5efasftp\u670d\u52a1\u5668\u8def\u5f84\u5931\u8d25:" + baseDir);
                boolean bl = false;
                return bl;
            }
            String dst = baseDir + "/" + fileName;
            String src = filePath + "/" + fileName;
            logger.info("\u5f00\u59cb\u4e0a\u4f20\uff0c\u672c\u5730\u670d\u52a1\u5668\u8def\u5f84\uff1a[" + src + "]\u76ee\u6807\u670d\u52a1\u5668\u8def\u5f84\uff1a[" + dst + "]");
            sftp.put(src, dst);
            logger.info("\u4e0a\u4f20\u6210\u529f");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            sftpChannel.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadStream(SftpConfig config, String targetDir, String fileName, InputStream fileStream) {
        logger.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6:" + fileName);
        SftpChannel sftpChannel = new SftpChannel();
        ChannelSftp sftp = null;
        try {
            sftp = StringUtils.isNotBlank((CharSequence)config.getPrivateKeyPath()) ? sftpChannel.connectByIdentity(config) : sftpChannel.connectByPwd(config);
            if (!sftp.isConnected()) {
                logger.error("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25");
                boolean bl = false;
                return bl;
            }
            logger.info("\u8fde\u63a5\u670d\u52a1\u5668\u6210\u529f");
            if (!SftpUtils.isExist(sftp, targetDir)) {
                logger.error("\u521b\u5efasftp\u670d\u52a1\u5668\u8def\u5f84\u5931\u8d25:" + targetDir);
                boolean bl = false;
                return bl;
            }
            String dst = targetDir + "/" + fileName;
            sftp.put(fileStream, dst);
            logger.info("\u4e0a\u4f20\u6210\u529f");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            sftpChannel.closeChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(SftpConfig config, String baseDir, String fileName1, String filePath, String fileName2) {
        SftpChannel sftpChannel = new SftpChannel();
        ChannelSftp sftp = null;
        try {
            sftp = StringUtils.isNotBlank((CharSequence)config.getPrivateKeyPath()) ? sftpChannel.connectByIdentity(config) : sftpChannel.connectByPwd(config);
            if (!sftp.isConnected()) {
                logger.error("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25");
                boolean bl = false;
                return bl;
            }
            logger.info("\u8fde\u63a5\u670d\u52a1\u5668\u6210\u529f");
            String dst = "";
            dst = StringUtils.isBlank((CharSequence)fileName2) ? filePath + fileName1 : filePath + fileName2;
            String src = baseDir + "/" + fileName1;
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\uff0csftp\u670d\u52a1\u5668\u8def\u5f84\uff1a[" + src + "]\u76ee\u6807\u670d\u52a1\u5668\u8def\u5f84\uff1a[" + dst + "]");
            sftp.get(src, dst);
            logger.info("\u4e0b\u8f7d\u6210\u529f");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            sftpChannel.closeChannel();
        }
    }

    public static boolean isExist(ChannelSftp sftp, String filePath) {
        String[] paths = filePath.split("\\/");
        String dir = paths[0];
        for (int i = 0; i < paths.length - 1; ++i) {
            dir = dir + "/" + paths[i + 1];
            try {
                sftp.cd(dir);
                continue;
            }
            catch (SftpException sException) {
                if (2 != sException.id) continue;
                try {
                    sftp.mkdir(dir);
                    continue;
                }
                catch (SftpException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }
}

