/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortByteAssociativeContainer;
import com.carrotsearch.hppc.ShortByteMap;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.WormUtil;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ShortByteCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.ShortBytePredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.ShortByteProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortByteWormMap
implements ShortByteMap,
Preallocable,
Cloneable,
Accountable {
    public short[] keys;
    public byte[] values;
    public byte[] next;
    protected int size;
    protected int iterationSeed;

    public ShortByteWormMap() {
        this(4);
    }

    public ShortByteWormMap(int expectedElements) {
        if (expectedElements < 0) {
            throw new IllegalArgumentException("Invalid expectedElements=" + expectedElements);
        }
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public ShortByteWormMap(ShortByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    public static ShortByteWormMap from(short[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortByteWormMap map = new ShortByteWormMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public ShortByteWormMap clone() {
        try {
            ShortByteWormMap cloneMap = (ShortByteWormMap)super.clone();
            cloneMap.keys = (short[])this.keys.clone();
            cloneMap.values = (byte[])this.values.clone();
            cloneMap.next = (byte[])this.next.clone();
            cloneMap.iterationSeed = HashContainers.nextIterationSeed();
            return cloneMap;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public byte noValue() {
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public byte get(short key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int entryIndex = this.searchInChain(key, hashIndex, nextOffset);
        return entryIndex < 0 ? this.noValue() : this.values[entryIndex];
    }

    @Override
    public byte getOrDefault(short key, byte defaultValue) {
        byte value = this.get(key);
        return value == this.noValue() ? defaultValue : value;
    }

    @Override
    public byte put(short key, byte value) {
        return this.put(key, value, WormUtil.PutPolicy.NEW_OR_REPLACE, true);
    }

    @Override
    public int putAll(ShortByteAssociativeContainer container) {
        int initialSize = this.size();
        for (ShortByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public int putAll(Iterable<? extends ShortByteCursor> iterable) {
        int initialSize = this.size();
        for (ShortByteCursor shortByteCursor : iterable) {
            this.put(shortByteCursor.key, shortByteCursor.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public byte putOrAdd(short key, byte putValue, byte incrementValue) {
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = (byte)(this.values[keyIndex] + incrementValue);
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public byte addTo(short key, byte additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    public boolean putIfAbsent(short key, byte value) {
        return this.noValue() == this.put(key, value, WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT, true);
    }

    @Override
    public byte remove(short key) {
        byte[] next = this.next;
        int hashIndex = this.hashMod(key);
        byte nextOffset = next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int previousEntryIndex = this.searchInChainReturnPrevious(key, hashIndex, nextOffset);
        if (previousEntryIndex < 0) {
            return this.noValue();
        }
        int entryToRemoveIndex = previousEntryIndex == Integer.MAX_VALUE ? hashIndex : WormUtil.addOffset(previousEntryIndex, Math.abs(next[previousEntryIndex]), next.length);
        return this.remove(entryToRemoveIndex, previousEntryIndex);
    }

    @Override
    public int removeAll(ShortContainer other) {
        int size = this.size();
        if (other.size() >= size && other instanceof ShortLookupContainer) {
            short[] keys = this.keys;
            byte[] next = this.next;
            int capacity = next.length;
            int entryIndex = 0;
            while (entryIndex < capacity) {
                short key;
                if (next[entryIndex] != 0 && other.contains(key = keys[entryIndex])) {
                    this.remove(key);
                    continue;
                }
                ++entryIndex;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return size - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        short[] keys = this.keys;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            short key;
            if (next[entryIndex] != 0 && predicate.apply(key = keys[entryIndex])) {
                this.remove(key);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public int removeAll(ShortBytePredicate predicate) {
        short[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            short key;
            if (next[entryIndex] != 0 && predicate.apply(key = keys[entryIndex], values[entryIndex])) {
                this.remove(key);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public <T extends ShortByteProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (next[slot] != 0) {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends ShortBytePredicate> T forEach(T predicate) {
        short[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (next[slot] == 0 || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    @Override
    public Iterator<ShortByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return false;
        }
        return this.searchInChain(key, hashIndex, nextOffset) >= 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.next, (byte)0);
        this.size = 0;
    }

    @Override
    public void release() {
        this.keys = null;
        this.values = null;
        this.next = null;
        this.size = 0;
        this.ensureCapacity(4);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        int size = this.size;
        ShortByteMap map = (ShortByteMap)o;
        if (size != map.size()) {
            return false;
        }
        short[] keys = this.keys;
        byte[] values = this.values;
        byte[] next = this.next;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (next[index] != 0) {
                if (map.get(keys[index]) != values[index]) {
                    return false;
                }
                ++entryCount;
            }
            ++index;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int size = this.size;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (this.next[index] != 0) {
                hashCode += BitMixer.mixPhi(this.keys[index]) ^ BitMixer.mixPhi(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        return hashCode;
    }

    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    private int hashMod(short key) {
        return this.hashKey(key) & this.next.length - 1;
    }

    @Override
    public int indexOf(short key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return ~hashIndex;
        }
        return this.searchInChain(key, hashIndex, nextOffset);
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < this.next.length);
        return index >= 0;
    }

    @Override
    public byte indexGet(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        return this.values[index];
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        byte previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, short key, byte value) {
        assert (index < 0) : "The index must not point at an existing key.";
        if (this.next[index ^= 0xFFFFFFFF] == 0) {
            this.keys[index] = key;
            this.values[index] = value;
            this.next[index] = 127;
            ++this.size;
        } else {
            this.put(key, value, WormUtil.PutPolicy.NEW_GUARANTEED, true);
        }
    }

    @Override
    public byte indexRemove(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        return this.remove(index, Integer.MAX_VALUE);
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append('[');
        int index = 0;
        int entryCount = 0;
        while (entryCount < this.size) {
            if (this.next[index] != 0) {
                if (entryCount > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(this.keys[index]);
                sBuilder.append("=>");
                sBuilder.append(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        sBuilder.append(']');
        return sBuilder.toString();
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.allocateBuffers((int)((float)expectedElements / 0.75f));
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.next.length - 1, characters);
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values) + RamUsageEstimator.shallowSizeOfArray(this.next);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.next, this.size());
    }

    protected void allocateBuffers(int capacity) {
        capacity = Math.max(capacity, this.size);
        if ((capacity = Math.max(BitUtil.nextHighestPowerOfTwo(capacity), 4)) > 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded (capacity: %d)", capacity);
        }
        if (this.keys != null && this.keys.length == capacity) {
            return;
        }
        short[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        byte[] oldNext = this.next;
        this.keys = new short[capacity];
        this.values = new byte[capacity];
        this.next = new byte[capacity];
        if (oldKeys != null) {
            this.putOldEntries(oldKeys, oldValues, oldNext, this.size);
        }
    }

    private void putOldEntries(short[] oldKeys, byte[] oldValues, byte[] oldNext, int entryNum) {
        int entryCount = 0;
        int endIndex = oldNext.length;
        for (int index = 0; entryCount < entryNum && index < endIndex; ++index) {
            if (oldNext[index] == 0) continue;
            short oldKey = oldKeys[index];
            int hashIndex = this.hashMod(oldKey);
            this.putNewEntry(hashIndex, this.next[hashIndex], oldKey, oldValues[index]);
            ++entryCount;
        }
    }

    private byte put(short key, byte value, WormUtil.PutPolicy policy, boolean sizeIncrease) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        boolean added = false;
        if (nextOffset > 0 && policy != WormUtil.PutPolicy.NEW_GUARANTEED) {
            int entryIndex = this.searchInChain(key, hashIndex, nextOffset);
            if (entryIndex >= 0) {
                byte previousValue = this.values[entryIndex];
                if (policy != WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT) {
                    this.values[entryIndex] = value;
                }
                return previousValue;
            }
            if (this.enlargeIfNeeded()) {
                hashIndex = this.hashMod(key);
                nextOffset = this.next[hashIndex];
            } else {
                if (!this.appendTailOfChain(~entryIndex, key, value)) {
                    this.enlargeAndPutNewEntry(key, value);
                }
                added = true;
            }
        } else if (this.enlargeIfNeeded()) {
            hashIndex = this.hashMod(key);
            nextOffset = this.next[hashIndex];
        }
        if (!added) {
            this.putNewEntry(hashIndex, nextOffset, key, value);
        }
        if (sizeIncrease) {
            ++this.size;
        }
        return this.noValue();
    }

    private boolean enlargeIfNeeded() {
        if (this.size >= this.next.length) {
            this.allocateBuffers(this.next.length << 1);
            return true;
        }
        return false;
    }

    private void enlargeAndPutNewEntry(short key, byte value) {
        this.allocateBuffers(this.next.length << 1);
        this.put(key, value, WormUtil.PutPolicy.NEW_GUARANTEED, false);
    }

    private byte remove(int entryToRemoveIndex, int previousEntryIndex) {
        int lastIndex;
        assert (WormUtil.checkIndex(entryToRemoveIndex, this.next.length));
        assert (previousEntryIndex == Integer.MAX_VALUE || WormUtil.checkIndex(previousEntryIndex, this.next.length));
        byte[] next = this.next;
        byte previousValue = this.values[entryToRemoveIndex];
        byte nextOffset = next[entryToRemoveIndex];
        int beforeLastIndex = WormUtil.findLastOfChain(entryToRemoveIndex, nextOffset, true, next);
        if (beforeLastIndex == -1) {
            lastIndex = entryToRemoveIndex;
            if (nextOffset < 0) {
                beforeLastIndex = previousEntryIndex == Integer.MAX_VALUE ? WormUtil.findPreviousInChain(entryToRemoveIndex, next) : previousEntryIndex;
                next[beforeLastIndex] = (byte)(next[beforeLastIndex] > 0 ? 127 : -127);
            }
        } else {
            byte beforeLastNextOffset = next[beforeLastIndex];
            lastIndex = WormUtil.addOffset(beforeLastIndex, Math.abs(beforeLastNextOffset), next.length);
            assert (entryToRemoveIndex != lastIndex);
            this.keys[entryToRemoveIndex] = this.keys[lastIndex];
            this.values[entryToRemoveIndex] = this.values[lastIndex];
            next[beforeLastIndex] = (byte)(beforeLastNextOffset > 0 ? 127 : -127);
        }
        this.keys[lastIndex] = 0;
        this.values[lastIndex] = this.noValue();
        next[lastIndex] = 0;
        --this.size;
        return previousValue;
    }

    private boolean appendTailOfChain(int lastEntryIndex, short key, byte value) {
        return this.appendTailOfChain(lastEntryIndex, key, value, WormUtil.ExcludedIndexes.NONE, 0);
    }

    private boolean appendTailOfChain(int lastEntryIndex, short key, byte value, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        int capacity = this.next.length;
        int searchFromIndex = WormUtil.addOffset(lastEntryIndex, 1, capacity);
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, WormUtil.maxOffset(capacity), -1, this.next);
        if (freeIndex == -1 && (freeIndex = this.searchAndMoveBucket(searchFromIndex, WormUtil.maxOffset(capacity), excludedIndexes, recursiveCallLevel)) == -1) {
            return false;
        }
        this.keys[freeIndex] = key;
        this.values[freeIndex] = value;
        this.next[freeIndex] = -127;
        int nextOffset = WormUtil.getOffsetBetweenIndexes(lastEntryIndex, freeIndex, this.next.length);
        this.next[lastEntryIndex] = (byte)(this.next[lastEntryIndex] > 0 ? nextOffset : -nextOffset);
        return true;
    }

    private int searchAndMoveBucket(int fromIndex, int range, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        assert (WormUtil.checkIndex(fromIndex, this.next.length));
        assert (range >= 0 && range <= WormUtil.maxOffset(this.next.length)) : "range=" + range + ", maxOffset=" + WormUtil.maxOffset(this.next.length);
        int remainingAttempts = WormUtil.RECURSIVE_MOVE_ATTEMPTS[recursiveCallLevel];
        if (remainingAttempts <= 0 || range <= 0) {
            return -1;
        }
        byte[] next = this.next;
        int capacity = next.length;
        int nextRecursiveCallLevel = recursiveCallLevel + 1;
        for (int index = fromIndex + range - 1; index >= fromIndex; --index) {
            byte nextOffset;
            int rolledIndex = index & capacity - 1;
            if (excludedIndexes.isIndexExcluded(rolledIndex) || (nextOffset = next[rolledIndex]) >= 0) continue;
            if (this.moveTailOfChain(rolledIndex, nextOffset, excludedIndexes, nextRecursiveCallLevel)) {
                return rolledIndex;
            }
            if (--remainingAttempts > 0) continue;
            return -1;
        }
        return -1;
    }

    private void putNewEntry(int hashIndex, int nextOffset, short key, byte value) {
        assert (hashIndex == this.hashMod(key)) : "hashIndex=" + hashIndex + ", hashReduce(key)=" + this.hashMod(key);
        assert (WormUtil.checkIndex(hashIndex, this.next.length));
        assert (Math.abs(nextOffset) <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[hashIndex]) : "nextOffset=" + nextOffset + ", next[hashIndex]=" + this.next[hashIndex];
        if (nextOffset > 0) {
            if (!this.appendTailOfChain(WormUtil.findLastOfChain(hashIndex, nextOffset, false, this.next), key, value)) {
                this.enlargeAndPutNewEntry(key, value);
            }
        } else {
            if (nextOffset < 0 && !this.moveTailOfChain(hashIndex, nextOffset, WormUtil.ExcludedIndexes.NONE, 0)) {
                this.enlargeAndPutNewEntry(key, value);
                return;
            }
            this.keys[hashIndex] = key;
            this.values[hashIndex] = value;
            this.next[hashIndex] = 127;
        }
    }

    private boolean moveTailOfChain(int tailIndex, int nextOffset, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        boolean nextIndexWithinRange;
        int searchRange;
        int searchFromIndex;
        assert (WormUtil.checkIndex(tailIndex, this.next.length));
        assert (nextOffset < 0 && nextOffset >= -127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[tailIndex]) : "nextOffset=" + nextOffset + ", next[tailIndex]=" + this.next[tailIndex];
        byte[] next = this.next;
        int capacity = next.length;
        int maxOffset = WormUtil.maxOffset(capacity);
        int previousIndex = WormUtil.findPreviousInChain(tailIndex, next);
        int absPreviousOffset = Math.abs(next[previousIndex]);
        int nextIndex = nextOffset == -127 ? -1 : WormUtil.addOffset(tailIndex, -nextOffset, capacity);
        int offsetFromPreviousToNext = absPreviousOffset - nextOffset;
        if (offsetFromPreviousToNext <= maxOffset) {
            searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
            searchRange = offsetFromPreviousToNext - 1;
            nextIndexWithinRange = true;
        } else {
            if (nextIndex == -1) {
                searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
                searchRange = maxOffset;
            } else {
                searchFromIndex = WormUtil.addOffset(nextIndex, -maxOffset, capacity);
                int searchToIndex = WormUtil.addOffset(previousIndex, maxOffset, capacity);
                searchRange = WormUtil.getOffsetBetweenIndexes(searchFromIndex, searchToIndex, capacity) + 1;
            }
            nextIndexWithinRange = false;
        }
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, searchRange, tailIndex, next);
        if (freeIndex == -1) {
            if (nextIndexWithinRange && this.appendTailOfChain(WormUtil.findLastOfChain(nextIndex, next[nextIndex], false, next), this.keys[tailIndex], this.values[tailIndex], excludedIndexes, recursiveCallLevel)) {
                int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, nextIndex, capacity);
                next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
                return true;
            }
            WormUtil.ExcludedIndexes recursiveExcludedIndexes = excludedIndexes.union(WormUtil.ExcludedIndexes.fromChain(previousIndex, next));
            freeIndex = this.searchAndMoveBucket(searchFromIndex, searchRange, recursiveExcludedIndexes, recursiveCallLevel);
            if (freeIndex == -1) {
                return false;
            }
        }
        this.keys[freeIndex] = this.keys[tailIndex];
        this.values[freeIndex] = this.values[tailIndex];
        next[freeIndex] = (byte)(nextOffset == -127 ? nextOffset : -WormUtil.getOffsetBetweenIndexes(freeIndex, nextIndex, capacity));
        int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, freeIndex, capacity);
        next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
        assert (next[freeIndex] < 0) : "freeIndex=" + freeIndex + ", next[freeIndex]=" + next[freeIndex];
        return true;
    }

    private int searchInChain(short key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (key == this.keys[index]) {
            return index;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            if (key == this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)]) {
                return index;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    private int searchInChainReturnPrevious(short key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (key == this.keys[index]) {
            return Integer.MAX_VALUE;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            int previousIndex = index;
            if (key == this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)]) {
                return previousIndex;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    private class EntryIterator
    extends AbstractIterator<ShortByteCursor> {
        private final ShortByteCursor cursor = new ShortByteCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = ShortByteWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortByteWormMap.this.next.length - 1;
        }

        @Override
        protected ShortByteCursor fetch() {
            int mask = ShortByteWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ShortByteWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = ShortByteWormMap.this.keys[this.slot];
                this.cursor.value = ShortByteWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (ShortByteCursor)this.done();
        }
    }

    private class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = ShortByteWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortByteWormMap.this.next.length - 1;
        }

        @Override
        protected ByteCursor fetch() {
            int mask = ShortByteWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ShortByteWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ShortByteWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private class ValuesContainer
    extends AbstractByteCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ShortByteWormMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ShortByteWormMap.this.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (ShortByteCursor c : ShortByteWormMap.this) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            for (ShortByteCursor c : ShortByteWormMap.this) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            for (ShortByteCursor c : ShortByteWormMap.this) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(byte e) {
            return ShortByteWormMap.this.removeAll((short key, byte value) -> value == e);
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return ShortByteWormMap.this.removeAll((short key, byte value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            ShortByteWormMap.this.clear();
        }

        @Override
        public void release() {
            ShortByteWormMap.this.release();
        }
    }

    private class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = ShortByteWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortByteWormMap.this.next.length - 1;
        }

        @Override
        protected ShortCursor fetch() {
            int mask = ShortByteWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ShortByteWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ShortByteWormMap.this.keys[this.slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        @Override
        public boolean contains(short e) {
            return ShortByteWormMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            ShortByteWormMap.this.forEach((key, value) -> procedure.apply(key));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            ShortByteWormMap.this.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return ShortByteWormMap.this.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return ShortByteWormMap.this.size();
        }

        @Override
        public void clear() {
            ShortByteWormMap.this.clear();
        }

        @Override
        public void release() {
            ShortByteWormMap.this.release();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return ShortByteWormMap.this.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            return ShortByteWormMap.this.remove(e) == ShortByteWormMap.this.noValue() ? 0 : 1;
        }
    }
}

