/*
 * Decompiled with CFR 0.152.
 */
package com.ccit.sm.sm2;

import com.ccit.sm.exception.SmCryptoException;
import com.ccit.sm.sm2.SM2EngineExtend;
import com.ccit.sm.sm2.SM2KeyPair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Locale;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class SM2 {
    public static final String CRYPTO_NAME_SM2 = "sm2p256v1";

    public static SM2KeyPair generateSm2Keys(boolean compressed) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPoint ecPoint = publicKeyParameters.getQ();
        String publicKey = Hex.toHexString((byte[])ecPoint.getEncoded(compressed)).toUpperCase(Locale.ROOT);
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BigInteger intPrivateKey = privateKeyParameters.getD();
        String privateKey = intPrivateKey.toString(16).toUpperCase(Locale.ROOT);
        return new SM2KeyPair(publicKey, privateKey);
    }

    public static String encrypt(String data, String pubKey) {
        return SM2.encrypt(data, pubKey, SM2EngineExtend.CIPHER_MODE_NORM);
    }

    public static String encrypt(String data, String pubKey, int cipherMode) {
        if (data == null) {
            return null;
        }
        if (pubKey.length() == 128) {
            pubKey = "04" + pubKey;
        }
        try {
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(true, cipherMode, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
            byte[] in = data.getBytes(StandardCharsets.UTF_8);
            byte[] arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
            return Hex.toHexString((byte[])arrayOfBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String decrypt(String cipherData, String priKey) {
        return SM2.decrypt(cipherData, priKey, SM2EngineExtend.CIPHER_MODE_NORM);
    }

    public static String decrypt(String cipherData, String priKey, int cipherMode) {
        try {
            if (cipherData == null) {
                return null;
            }
            if (!cipherData.startsWith("04")) {
                cipherData = "04" + cipherData;
            }
            byte[] cipherDataByte = Hex.decode((String)cipherData);
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            BigInteger privateKeyD = new BigInteger(priKey, 16);
            ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(false, cipherMode, (CipherParameters)privateKeyParameters);
            byte[] arrayOfBytes = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            return new String(arrayOfBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String sign(String plainText, String priKey) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            BigInteger bigInteger = new BigInteger(priKey, 16);
            BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, ecParameterSpec));
            signature.initSign((PrivateKey)bcecPrivateKey);
            signature.update(plainText.getBytes());
            return Hex.toHexString((byte[])signature.sign()).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static boolean verify(String plainText, String pubKey, String signatureValue) {
        if (pubKey.length() == 128) {
            pubKey = "04" + pubKey;
        }
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            ECPoint ecPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            BCECPublicKey bcecPublicKey = (BCECPublicKey)keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, ecParameterSpec));
            signature.initVerify((PublicKey)bcecPublicKey);
            signature.update(plainText.getBytes());
            return signature.verify(Hex.decode((String)signatureValue));
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static boolean certVerify(String plaintext, String certStr, String signValueStr) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            byte[] signValue = Hex.decode((String)signValueStr);
            CertificateFactory factory = new CertificateFactory();
            X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(Hex.decode((String)certStr)));
            Signature signature = Signature.getInstance(certificate.getSigAlgName(), (Provider)provider);
            signature.initVerify(certificate);
            signature.update(plaintext.getBytes());
            return signature.verify(signValue);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    private static byte[] handleFileCrypto(String keyHex, InputStream in, boolean isPublicKey) throws Exception {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] temp = new byte[4096];
        while ((bytesRead = in.read(temp)) != -1) {
            buffer.write(temp, 0, bytesRead);
        }
        byte[] inputData = buffer.toByteArray();
        SM2EngineExtend engine = new SM2EngineExtend();
        CipherParameters params = SM2.createKeyParameters(keyHex, isPublicKey);
        engine.init(isPublicKey, SM2EngineExtend.CIPHER_MODE_NORM, (CipherParameters)(isPublicKey ? new ParametersWithRandom(params, new SecureRandom()) : params));
        return engine.processBlock(inputData, 0, inputData.length);
    }

    private static CipherParameters createKeyParameters(String keyHex, boolean isPublicKey) {
        X9ECParameters sm2Params = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParams = new ECDomainParameters(sm2Params.getCurve(), sm2Params.getG(), sm2Params.getN());
        return isPublicKey ? new ECPublicKeyParameters(sm2Params.getCurve().decodePoint(Hex.decode((String)keyHex)), domainParams) : new ECPrivateKeyParameters(new BigInteger(keyHex, 16), domainParams);
    }

    public static void encryptFile(String publicKeyHex, String inputPath, String outputPath) throws Exception {
        try (InputStream in = Files.newInputStream(Paths.get(inputPath, new String[0]), new OpenOption[0]);){
            byte[] encrypted = SM2.handleFileCrypto(publicKeyHex, in, true);
            Files.write(Paths.get(outputPath, new String[0]), encrypted, new OpenOption[0]);
        }
    }

    public static void decryptFile(String privateKeyHex, String inputPath, String outputPath) throws Exception {
        try (InputStream in = Files.newInputStream(Paths.get(inputPath, new String[0]), new OpenOption[0]);){
            byte[] decrypted = SM2.handleFileCrypto(privateKeyHex, in, false);
            Files.write(Paths.get(outputPath, new String[0]), decrypted, new OpenOption[0]);
        }
    }

    public static InputStream encryptStream(String publicKeyHex, InputStream sourceStream) throws Exception {
        return new ByteArrayInputStream(SM2.handleFileCrypto(publicKeyHex, sourceStream, true));
    }

    public static InputStream decryptStream(String privateKeyHex, InputStream encryptedStream) throws Exception {
        return new ByteArrayInputStream(SM2.handleFileCrypto(privateKeyHex, encryptedStream, false));
    }

    public static void main(String[] args) {
        String fileName = "500M";
        String fileSuffix = ".zip";
        String originalFile = "D:\\\u52a0\u5bc6\u6d4b\u8bd5\\" + fileName + fileSuffix;
        String encryptedFile = "D:\\\u52a0\u5bc6\u6d4b\u8bd5\\" + fileName + "_\u52a0\u5bc6\u540e.ego";
        String decryptedFile = "D:\\\u52a0\u5bc6\u6d4b\u8bd5\\" + fileName + "_\u89e3\u5bc6\u540e" + fileSuffix;
        String publicKey = "04717744A9F64B302C802E07FFD1CE6C96CFADCBE1314FE6FFF0B53C6EBA3A91FE0324661BF288CFBC34052A3BAD2DC7D3E0D4B81B588FC73725313435D0EF808F";
        String privateKey = "3DFF586BD7BA548DD72BC356181587C3CF2881073B788E3B68817F2C23A933F6";
        try {
            long s1 = System.currentTimeMillis();
            SM2.encryptFile(publicKey, originalFile, encryptedFile);
            System.out.println("\u52a0\u5bc6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - s1) + "ms");
            long s2 = System.currentTimeMillis();
            SM2.decryptFile(privateKey, encryptedFile, decryptedFile);
            System.out.println("\u89e3\u5bc6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - s2) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

