/*
 * Decompiled with CFR 0.152.
 */
package com.ccit.sm.sm4;

import com.ccit.sm.exception.SmCryptoException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SM4 {
    private static final String SM4_ALGORITHM = "SM4";
    private static final int DEFAULT_KEY_SIZE = 128;
    private static final String TRANSFORMATION_CBC = "SM4/CBC/PKCS5Padding";
    private static final String TRANSFORMATION_ECB = "SM4/ECB/PKCS5Padding";

    public static String generateKey() {
        return SM4.generateKey(128);
    }

    public static String generateKey(int keySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(SM4_ALGORITHM, "BC");
            kg.init(keySize, new SecureRandom());
            byte[] encoded = kg.generateKey().getEncoded();
            return Hex.toHexString((byte[])encoded).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String encrypt(String planText, String keyHex, String ivHex) {
        try {
            if (planText == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(Hex.decode((String)ivHex));
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] outputBytes = cipher.doFinal(planText.getBytes(StandardCharsets.UTF_8));
            return Hex.toHexString((byte[])outputBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String decrypt(String cipherDataHex, String keyHex, String ivHex) {
        try {
            if (cipherDataHex == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(Hex.decode((String)ivHex));
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] outputBytes = cipher.doFinal(Hex.decode((String)cipherDataHex));
            return new String(outputBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String encrypt(String planText, String keyHex) {
        try {
            if (planText == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_ECB);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            cipher.init(1, keySpec);
            byte[] outputBytes = cipher.doFinal(planText.getBytes(StandardCharsets.UTF_8));
            return Hex.toHexString((byte[])outputBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String decrypt(String cipherDataHex, String keyHex) {
        try {
            if (cipherDataHex == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_ECB);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode((String)keyHex), SM4_ALGORITHM);
            cipher.init(2, keySpec);
            byte[] outputBytes = cipher.doFinal(Hex.decode((String)cipherDataHex));
            return new String(outputBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

