/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.asn1.pkcs;

import ccit.org.bouncycastle.asn1.ASN1EncodableVector;
import ccit.org.bouncycastle.asn1.ASN1Integer;
import ccit.org.bouncycastle.asn1.ASN1Object;
import ccit.org.bouncycastle.asn1.ASN1Primitive;
import ccit.org.bouncycastle.asn1.ASN1Sequence;
import ccit.org.bouncycastle.asn1.BERSequence;
import ccit.org.bouncycastle.asn1.pkcs.ContentInfo;
import ccit.org.bouncycastle.asn1.pkcs.MacData;
import ccit.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class Pfx
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ContentInfo contentInfo;
    private MacData macData = null;

    private Pfx(ASN1Sequence aSN1Sequence) {
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        if (!aSN1Integer.hasValue(3)) {
            throw new IllegalArgumentException("wrong version for PFX PDU");
        }
        this.contentInfo = ContentInfo.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() == 3) {
            this.macData = MacData.getInstance(aSN1Sequence.getObjectAt(2));
        }
    }

    public static Pfx getInstance(Object object) {
        if (object instanceof Pfx) {
            return (Pfx)object;
        }
        if (object != null) {
            return new Pfx(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Pfx(ContentInfo contentInfo, MacData macData) {
        this.contentInfo = contentInfo;
        this.macData = macData;
    }

    public ContentInfo getAuthSafe() {
        return this.contentInfo;
    }

    public MacData getMacData() {
        return this.macData;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(new ASN1Integer(3L));
        aSN1EncodableVector.add(this.contentInfo);
        if (this.macData != null) {
            aSN1EncodableVector.add(this.macData);
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

