/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.crypto.modes;

import ccit.org.bouncycastle.crypto.BlockCipher;
import ccit.org.bouncycastle.crypto.CipherParameters;
import ccit.org.bouncycastle.crypto.DataLengthException;
import ccit.org.bouncycastle.crypto.StreamBlockCipher;
import ccit.org.bouncycastle.crypto.params.ParametersWithIV;

public class GOFBBlockCipher
extends StreamBlockCipher {
    private byte[] IV;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private final int blockSize;
    private final BlockCipher cipher;
    boolean firstStep = true;
    int N3;
    int N4;
    static final int C1 = 0x1010104;
    static final int C2 = 0x1010101;

    public GOFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        if (this.blockSize != 8) {
            throw new IllegalArgumentException("GCTR only for 64 bit block ciphers");
        }
        this.IV = new byte[blockCipher.getBlockSize()];
        this.ofbV = new byte[blockCipher.getBlockSize()];
        this.ofbOutV = new byte[blockCipher.getBlockSize()];
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.firstStep = true;
        this.N3 = 0;
        this.N4 = 0;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.IV.length) {
                System.arraycopy(byArray, 0, this.IV, this.IV.length - byArray.length, byArray.length);
                for (int i = 0; i < this.IV.length - byArray.length; ++i) {
                    this.IV[i] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (cipherParameters != null) {
                this.cipher.init(true, cipherParameters);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n, this.blockSize, byArray2, n2);
        return this.blockSize;
    }

    @Override
    public void reset() {
        this.firstStep = true;
        this.N3 = 0;
        this.N4 = 0;
        System.arraycopy(this.IV, 0, this.ofbV, 0, this.IV.length);
        this.byteCount = 0;
        this.cipher.reset();
    }

    private int bytesToint(byte[] byArray, int n) {
        return (byArray[n + 3] << 24 & 0xFF000000) + (byArray[n + 2] << 16 & 0xFF0000) + (byArray[n + 1] << 8 & 0xFF00) + (byArray[n] & 0xFF);
    }

    private void intTobytes(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)(n >>> 24);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2] = (byte)n;
    }

    @Override
    protected byte calculateByte(byte by) {
        if (this.byteCount == 0) {
            if (this.firstStep) {
                this.firstStep = false;
                this.cipher.processBlock(this.ofbV, 0, this.ofbOutV, 0);
                this.N3 = this.bytesToint(this.ofbOutV, 0);
                this.N4 = this.bytesToint(this.ofbOutV, 4);
            }
            this.N3 += 0x1010101;
            this.N4 += 0x1010104;
            if (this.N4 < 0x1010104 && this.N4 > 0) {
                ++this.N4;
            }
            this.intTobytes(this.N3, this.ofbV, 0);
            this.intTobytes(this.N4, this.ofbV, 4);
            this.cipher.processBlock(this.ofbV, 0, this.ofbOutV, 0);
        }
        byte by2 = (byte)(this.ofbOutV[this.byteCount++] ^ by);
        if (this.byteCount == this.blockSize) {
            this.byteCount = 0;
            System.arraycopy(this.ofbV, this.blockSize, this.ofbV, 0, this.ofbV.length - this.blockSize);
            System.arraycopy(this.ofbOutV, 0, this.ofbV, this.ofbV.length - this.blockSize, this.blockSize);
        }
        return by2;
    }
}

