/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.crypto.parsers;

import ccit.org.bouncycastle.crypto.KeyParser;
import ccit.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import ccit.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import ccit.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import ccit.org.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;

public class XIESPublicKeyParser
implements KeyParser {
    private final boolean isX25519;

    public XIESPublicKeyParser(boolean bl) {
        this.isX25519 = bl;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream inputStream) throws IOException {
        int n = this.isX25519 ? 32 : 56;
        byte[] byArray = new byte[n];
        Streams.readFully(inputStream, byArray, 0, byArray.length);
        return this.isX25519 ? new X25519PublicKeyParameters(byArray, 0) : new X448PublicKeyParameters(byArray, 0);
    }
}

