/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.pqc.crypto.crystals.kyber;

import ccit.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import ccit.org.bouncycastle.crypto.SecretWithEncapsulation;
import ccit.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import ccit.org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import ccit.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import ccit.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class KyberKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public KyberKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        KyberPublicKeyParameters kyberPublicKeyParameters = (KyberPublicKeyParameters)asymmetricKeyParameter;
        KyberEngine kyberEngine = kyberPublicKeyParameters.getParameters().getEngine();
        kyberEngine.init(this.sr);
        byte[][] byArray = kyberEngine.kemEncrypt(kyberPublicKeyParameters.getEncoded());
        return new SecretWithEncapsulationImpl(byArray[0], byArray[1]);
    }
}

