/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryCatalogDetailService;
import com.cgd.commodity.busi.bo.catalog.BusiQryCatalogDetailRspBO;
import com.cgd.commodity.busi.bo.catalog.QryCatalogDetailReqBO;
import com.cgd.commodity.busi.bo.catalog.QryCatalogDetailRspBO;
import com.cgd.commodity.busi.vo.catalog.CommodityTypeVO;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryCatalogDetailServiceImpl
implements QryCatalogDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QryCatalogDetailServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public QryCatalogDetailRspBO qryCatalogDetail(QryCatalogDetailReqBO qryCatalogDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7c7b\u76ee\u8be6\u7ec6\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryCatalogDetailReqBO.toString());
        }
        QryCatalogDetailRspBO rsp = new QryCatalogDetailRspBO();
        try {
            Page page = new Page(qryCatalogDetailReqBO.getPageNo().intValue(), qryCatalogDetailReqBO.getPageSize().intValue());
            ArrayList<BusiQryCatalogDetailRspBO> commodityCatalogList = new ArrayList<BusiQryCatalogDetailRspBO>();
            BusiQryCatalogDetailRspBO commodityCatalogBO = this.commodityGuideCatalogMapper.getListbyGuideCatalogId(qryCatalogDetailReqBO.getGuideCatalogId(), (Page<Map<String, Object>>)page);
            List<CommodityTypeVO> commodityTypes = this.commodityGuideCatalogMapper.getComTypeListByGuideId(qryCatalogDetailReqBO.getGuideCatalogId());
            if (commodityCatalogBO != null) {
                commodityCatalogBO.setCommodityTypes(commodityTypes);
            }
            commodityCatalogList.add(commodityCatalogBO);
            if (commodityCatalogList.size() > 0) {
                rsp.setRows(commodityCatalogList);
            }
            rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rsp.setTotal(Integer.valueOf(page.getTotalPages()));
        }
        catch (Exception e) {
            logger.error("\u7c7b\u76ee\u8be6\u7ec6\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7c7b\u76ee\u8be6\u7ec6\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

