/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryCommodityTypeService;
import com.cgd.commodity.busi.bo.BusiCommodityTypeRspBO;
import com.cgd.commodity.busi.bo.BusiQryCommodityTypeReqBO;
import com.cgd.commodity.dao.CommodityTypeMapper;
import com.cgd.commodity.po.CommodityTypePO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class QryCommodityTypeServiceImpl
implements QryCommodityTypeService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityTypeMapper commodityTypeMapper;

    public RspPageBO<BusiCommodityTypeRspBO> qryCommodityType(BusiQryCommodityTypeReqBO busiQryCommodityTypeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + busiQryCommodityTypeReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            Page page = new Page();
            page.setPageNo(busiQryCommodityTypeReqBO.getPageNo());
            page.setPageSize(busiQryCommodityTypeReqBO.getPageSize());
            String commodityTypeName = busiQryCommodityTypeReqBO.getCommodityTypeName();
            List<CommodityTypePO> comTypeInfoList = this.commodityTypeMapper.getListByName(commodityTypeName, (Page<CommodityTypePO>)page);
            ArrayList<BusiCommodityTypeRspBO> comTypeInfoBOList = new ArrayList<BusiCommodityTypeRspBO>();
            for (int i = 0; i < comTypeInfoList.size(); ++i) {
                BusiCommodityTypeRspBO busiCommodityTypeRspBO = new BusiCommodityTypeRspBO();
                BeanUtils.copyProperties((Object)comTypeInfoList.get(i), (Object)busiCommodityTypeRspBO);
                comTypeInfoBOList.add(busiCommodityTypeRspBO);
            }
            rsp.setRows(comTypeInfoBOList);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u6210\u529f");
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setCommodityTypeMapper(CommodityTypeMapper commodityTypeMapper) {
        this.commodityTypeMapper = commodityTypeMapper;
    }
}

