/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuCommentService;
import com.cgd.commodity.busi.bo.BusiQryCommentReqBO;
import com.cgd.commodity.busi.bo.BusiQryCommentRsp;
import com.cgd.commodity.busi.bo.BusiQryCommentRspBO;
import com.cgd.commodity.dao.CommodityCommentMapper;
import com.cgd.commodity.po.CommodityComment;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrySkuCommentServiceImpl
implements QrySkuCommentService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuCommentServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityCommentMapper commodityCommentMapper;

    public BusiQryCommentRspBO qrySkuComment(BusiQryCommentReqBO busiQryCommentReqBO) {
        if (isDebugEnabled) {
            logger.debug("\u83b7\u53d6\u5355\u54c1\u8bc4\u4ef7\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\uff1a" + busiQryCommentReqBO.toString());
        }
        if (null == busiQryCommentReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u83b7\u53d6\u5355\u54c1\u8bc4\u4ef7\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1Sku Id[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQryCommentRspBO rspBO = new BusiQryCommentRspBO();
        try {
            List<CommodityComment> commentList = this.commodityCommentMapper.selectBySkuId(busiQryCommentReqBO.getSkuId());
            ArrayList<BusiQryCommentRsp> rsps = new ArrayList<BusiQryCommentRsp>();
            for (CommodityComment commodityComment : commentList) {
                BusiQryCommentRsp rsp = new BusiQryCommentRsp();
                rsp.setSkuId(commodityComment.getSkuId());
                rsp.setComment(commodityComment.getComment());
                rsp.setCommentRate(commodityComment.getCommentRate());
                rsps.add(rsp);
            }
            rspBO.setBusiQryCommentRsps(rsps);
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u5355\u54c1\u8bc4\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        return rspBO;
    }

    public void setCommodityCommentMapper(CommodityCommentMapper commodityCommentMapper) {
        this.commodityCommentMapper = commodityCommentMapper;
    }
}

