/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.commodity.busi.QrySupplierAndVendorInfoService;
import com.cgd.commodity.busi.bo.QrySupplierAndVendorInfoReqBO;
import com.cgd.commodity.busi.bo.QrySupplierAndVendorInfoRspBO;
import com.cgd.commodity.busi.vo.QrySupplierRspVO;
import com.cgd.commodity.busi.vo.QryVendorRspVO;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.user.userInfo.busi.SelectOrganisationByAutoIdBusiService;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdAndCompIdBusiService;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectOrganisationByAutoIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectOrganisationByAutoIdRspBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdRspBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySupplierAndVendorInfoServiceImpl
implements QrySupplierAndVendorInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QrySupplierAndVendorInfoServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SelectOrganisationByAutoIdBusiService selectOrganisationByAutoIdBusiService;
    private SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;

    public void setSelectUserInfoByUserIdAndCompIdBusiService(SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService) {
        this.selectUserInfoByUserIdAndCompIdBusiService = selectUserInfoByUserIdAndCompIdBusiService;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSelectOrganisationByAutoIdBusiService(SelectOrganisationByAutoIdBusiService selectOrganisationByAutoIdBusiService) {
        this.selectOrganisationByAutoIdBusiService = selectOrganisationByAutoIdBusiService;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public QrySupplierAndVendorInfoRspBO qrySupplierAndVendorInfo(QrySupplierAndVendorInfoReqBO qrySupplierAndVendorInfoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySupplierAndVendorInfoReqBO.toString());
        }
        if (null == qrySupplierAndVendorInfoReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u94fa\u8d27\u5546\u548c\u4f9b\u8d27\u5546\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5355\u54c1Id[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qrySupplierAndVendorInfoReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u94fa\u8d27\u5546\u548c\u4f9b\u8d27\u5546\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546Id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Map<String, Object> resultMap = this.skuMapper.selectById(qrySupplierAndVendorInfoReqBO.getSkuId(), qrySupplierAndVendorInfoReqBO.getSupplierId());
            if (null == resultMap) {
                throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            QrySupplierAndVendorInfoRspBO qrySupplierAndVendorInfoRspBO = new QrySupplierAndVendorInfoRspBO();
            QrySupplierRspVO qrySupplierRspVO = this.qrySupplier(resultMap, qrySupplierAndVendorInfoReqBO);
            qrySupplierAndVendorInfoRspBO.setSupplierInfo(qrySupplierRspVO);
            if (null != qrySupplierAndVendorInfoReqBO.getUserId()) {
                QryVendorRspVO qryVendorRspVO = this.qryVendor(resultMap, qrySupplierAndVendorInfoReqBO);
                qrySupplierAndVendorInfoRspBO.setVendorInfo(qryVendorRspVO);
            }
            return qrySupplierAndVendorInfoRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u94fa\u8d27\u5546\u548c\u4f9b\u8d27\u5546\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u94fa\u8d27\u5546\u548c\u4f9b\u8d27\u5546\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private QrySupplierRspVO qrySupplier(Map<String, Object> resultMap, QrySupplierAndVendorInfoReqBO qrySupplierAndVendorInfoReqBO) {
        try {
            SupplierAgreement supplierAgreement;
            QrySupplierRspVO qrySupplierRspVO = new QrySupplierRspVO();
            if (null != resultMap.get("AGREEMENT_ID") && null != (supplierAgreement = this.supplierAgreementMapper.selectAgrById((Long)resultMap.get("AGREEMENT_ID"), qrySupplierAndVendorInfoReqBO.getSupplierId()))) {
                qrySupplierRspVO.setSupplierId(qrySupplierAndVendorInfoReqBO.getSupplierId());
                qrySupplierRspVO.setSupplierContant(supplierAgreement.getProducerName());
                SelectUserInfoByUserIdReqBO userInfo = new SelectUserInfoByUserIdReqBO();
                userInfo.setUserId(supplierAgreement.getProducerId());
                SelectUserInfoByUserIdRspBO selectUserInfoByUserIdRspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(userInfo);
                if (null != selectUserInfoByUserIdRspBO) {
                    String telResult = selectUserInfoByUserIdRspBO.getExtjson();
                    String tel = "";
                    String csTel = "";
                    String address = "";
                    logger.info("----------telResult---------->>>>>>>>>>>" + telResult);
                    if (!StringUtils.isEmpty((Object)telResult)) {
                        Map parseObject = (Map)JSON.parseObject((String)telResult, Map.class);
                        logger.info("-----parseObject-------->>>>>>>>>>>>" + parseObject);
                        tel = parseObject.get("tel") != null ? parseObject.get("tel").toString() : "";
                        csTel = parseObject.get("csTel") != null ? parseObject.get("csTel").toString() : "";
                        address = parseObject.get("address") != null ? parseObject.get("address").toString() : "";
                    }
                    String orgName = selectUserInfoByUserIdRspBO.getTitle();
                    qrySupplierRspVO.setSupplierAddress(address);
                    qrySupplierRspVO.setSupplierName(orgName);
                    if (StringUtils.isEmpty((Object)csTel)) {
                        qrySupplierRspVO.setSupplierPhone(tel);
                    } else {
                        qrySupplierRspVO.setSupplierPhone(csTel);
                    }
                }
            }
            return qrySupplierRspVO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u94fa\u8d27\u5546\u548c\u4f9b\u8d27\u5546\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
    }

    private QryVendorRspVO qryVendor(Map<String, Object> resultMap, QrySupplierAndVendorInfoReqBO qrySupplierAndVendorInfoReqBO) {
        try {
            SupplierAgreement supplierAgreement;
            QryVendorRspVO vendorBO = new QryVendorRspVO();
            if (null != resultMap.get("AGREEMENT_ID") && null != (supplierAgreement = this.supplierAgreementMapper.selectByPrimaryKey((Long)resultMap.get("AGREEMENT_ID")))) {
                vendorBO.setVendorId((Long)resultMap.get("VENDOR_ID"));
                vendorBO.setVendorName(supplierAgreement.getVendorName());
                vendorBO.setVendorContant(supplierAgreement.getVendorContact());
                if (null != resultMap.get("VENDOR_ID")) {
                    Long compId = this.getUserSupplierId((Long)resultMap.get("VENDOR_ID"));
                    if (null != compId) {
                        SelectOrganisationByAutoIdReqBO selectOrganisationByAutoIdReqBO = new SelectOrganisationByAutoIdReqBO();
                        selectOrganisationByAutoIdReqBO.setAutoId(compId);
                        SelectOrganisationByAutoIdRspBO resultBO = this.selectOrganisationByAutoIdBusiService.selectOrganisationByAutoId(selectOrganisationByAutoIdReqBO);
                        if (null != resultBO) {
                            if (!StringUtils.isEmpty((Object)resultBO.getCsTel())) {
                                vendorBO.setVendorPhone(resultBO.getCsTel());
                            } else {
                                vendorBO.setVendorPhone(supplierAgreement.getVendorPhone());
                            }
                        } else {
                            vendorBO.setVendorPhone(supplierAgreement.getVendorPhone());
                        }
                    } else {
                        vendorBO.setVendorPhone(supplierAgreement.getVendorPhone());
                    }
                } else {
                    vendorBO.setVendorPhone(supplierAgreement.getVendorPhone());
                }
            }
            return vendorBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u94fa\u8d27\u5546\u548c\u4f9b\u8d27\u5546\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
    }

    private Long getUserSupplierId(Long userId) {
        try {
            SelectUserInfoByUserIdAndCompIdReqBO selectUserInfoAndCompIdReqBO = new SelectUserInfoByUserIdAndCompIdReqBO();
            selectUserInfoAndCompIdReqBO.setUserId(userId);
            SelectUserInfoByUserIdAndCompIdRspBO selectUserInfoByUserIdAndCompIdRspBO = this.selectUserInfoByUserIdAndCompIdBusiService.selectUserInfoByUserIdAndCompId(selectUserInfoAndCompIdReqBO);
            if ("0000".equals(selectUserInfoByUserIdAndCompIdRspBO.getRespCode())) {
                return selectUserInfoByUserIdAndCompIdRspBO.getCompId();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }
}

