/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.cgd.commodity.busi.SearchBarService;
import com.cgd.commodity.busi.bo.SearchBarReqBO;
import com.cgd.commodity.busi.bo.SearchBarRspBO;
import com.cgd.commodity.busi.bo.SearchBarRspInfo;
import com.cgd.commodity.busi.vo.QueryParam;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.CommodityPropDefMapper;
import com.cgd.commodity.po.Brand;
import com.cgd.commodity.po.CommodityGuideCatalog;
import com.cgd.commodity.po.CommodityPropDef;
import com.cgd.commodity.util.SpecialSymbolUtils;
import com.cgd.user.org.busi.QryLittleActOrgByUserBusiService;
import com.cgd.user.org.busi.QryOrgInfoByIdBusiService;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserReqBO;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserRspBO;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdReqBO;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdRspBO;
import com.cgd.user.org.busi.bo.UserOrganisationBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheManager;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.common.util.SerializeUtils;
import com.ohaotian.plugin.es.builder.search.SearchBuilder;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilder;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.search.filter.BooleanFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.FilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.MatchFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.RangeFilterCondition;
import com.ohaotian.plugin.es.builder.search.query.BooleanQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.MatchQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.QueryCondition;
import com.ohaotian.plugin.es.builder.search.rank.RankCondition;
import com.ohaotian.plugin.es.builder.search.result.Result;
import com.ohaotian.plugin.es.builder.search.sort.SearchSortMode;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchBarServiceImpl
implements SearchBarService {
    private static final Log log = LogFactory.getLog(SearchBarServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;
    private String appName;
    private Integer totalCount;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    @Autowired
    private CommodityPropDefMapper commodityPropDefMapper;
    @Autowired
    private QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService;

    public void setProp(Properties prop) {
        this.prop = prop;
        this.appName = String.valueOf(prop.getProperty("os.appName"));
        this.totalCount = Integer.parseInt(prop.getProperty("os.total_count"));
    }

    public SearchBarRspBO qryBySearchBar(SearchBarReqBO searchBarReqBO) {
        RangeFilterCondition match_range;
        MatchQueryCondition match_location;
        MatchQueryCondition match_location2;
        if (this.isDebugEnabled) {
            log.debug((Object)("\u641c\u7d22\u680f\u641c\u7d22\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + searchBarReqBO));
        }
        if (null == searchBarReqBO.getQueryLocation()) {
            searchBarReqBO.setQueryLocation(Integer.valueOf(0));
        }
        if (null == searchBarReqBO.getOrderByColumn()) {
            searchBarReqBO.setOrderByColumn(Integer.valueOf(0));
        } else if (null == searchBarReqBO.getOrderType()) {
            searchBarReqBO.setOrderType(Integer.valueOf(0));
        }
        SearchBuilder searchBuilder = SearchBuilder.newBuilder((SearchRequestBuilder)this.searchRequestBuilderAdapter.requestBuilder());
        searchBuilder.setIndexName(this.appName);
        if (searchBarReqBO.getPageSize() == null) {
            searchBarReqBO.setPageSize(Integer.valueOf(20));
        }
        if (searchBarReqBO.getPageNo() == null) {
            searchBarReqBO.setPageNo(Integer.valueOf(1));
        }
        int from = searchBarReqBO.getPageSize() * (searchBarReqBO.getPageNo() - 1);
        searchBuilder.setFrom(from);
        searchBuilder.setSize(searchBarReqBO.getPageSize().intValue());
        int os_total_count = this.totalCount;
        if (from + searchBarReqBO.getPageSize() > os_total_count) {
            searchBuilder.setSize(os_total_count - from);
        }
        searchBuilder.fetchBuilder().addCol("sku_id").addCol("ext_sku_id").addCol("picture_url").addCol("sale_area").addCol("market_price").addCol("sale_price").addCol("member_price").addCol("sku_name").addCol("supplier_id").addCol("sku_location").addCol("supplier_name").addCol("agreement_id");
        BooleanFilterCondition filter = new BooleanFilterCondition();
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        BooleanQueryCondition booleanQueryCondition = new BooleanQueryCondition();
        int queryLocation = searchBarReqBO.getQueryLocation();
        List searchChannels = searchBarReqBO.getSearchChannels();
        if (null != searchBarReqBO.getQueryParams() && !searchBarReqBO.getQueryParams().isEmpty()) {
            for (int i = 0; i < searchBarReqBO.getQueryParams().size(); ++i) {
                QueryParam param = (QueryParam)searchBarReqBO.getQueryParams().get(i);
                hiddenParamsForRsp.add(param.getFilterId());
                BooleanFilterCondition listFilter = new BooleanFilterCondition();
                BooleanQueryCondition queryCondition = new BooleanQueryCondition();
                this.addFilterFromParam(param, listFilter, queryLocation, queryCondition, searchChannels);
                if (listFilter.should().size() > 0) {
                    filter.must().add(listFilter);
                }
                if (queryCondition.should().size() <= 0) continue;
                booleanQueryCondition.must().add(queryCondition);
            }
        }
        MatchQueryCondition match_status = new MatchQueryCondition();
        match_status.setColumnName("sku_status");
        match_status.setValue("'2'");
        booleanQueryCondition.must().add(match_status);
        if (searchBarReqBO.getQueryStr() != null) {
            if (StringUtils.isNumeric((String)searchBarReqBO.getQueryStr())) {
                String[] condition = new String[]{"id", "material_code"};
                BooleanQueryCondition match_default = new BooleanQueryCondition();
                for (int i = 0; i < condition.length; ++i) {
                    MatchQueryCondition match_location3 = new MatchQueryCondition();
                    match_location3.setColumnName(condition[i]);
                    match_location3.setValue("'" + searchBarReqBO.getQueryStr() + "'");
                    match_default.should().add(match_location3);
                }
                booleanQueryCondition.must().add(match_default);
            } else {
                RankCondition rankCondition = new RankCondition();
                String[] condition = new String[]{"default", "figure", "model", "vendor_name"};
                BooleanQueryCondition match_default = new BooleanQueryCondition();
                for (int i = 0; i < condition.length; ++i) {
                    match_location2 = new MatchQueryCondition();
                    match_location2.setColumnName(condition[i]);
                    match_location2.setValue("'" + searchBarReqBO.getQueryStr() + "'");
                    match_default.should().add(match_location2);
                }
                rankCondition.setSecondRankName("querybar");
                booleanQueryCondition.must().add(match_default);
                searchBuilder.rankBuilder().setRankCondition(rankCondition);
            }
        }
        int location = searchBarReqBO.getQueryLocation();
        if (searchChannels != null && searchChannels.size() > 0) {
            if (searchChannels.size() == 1) {
                match_location = new MatchQueryCondition();
                match_location.setColumnName("sku_location");
                match_location.setValue("'" + searchChannels.get(0) + "'");
                booleanQueryCondition.must().add(match_location);
            } else {
                BooleanQueryCondition searchChannelCondition = new BooleanQueryCondition();
                for (Integer searchChannel : searchChannels) {
                    match_location2 = new MatchQueryCondition();
                    match_location2.setColumnName("sku_location");
                    match_location2.setValue("'" + searchChannel + "'");
                    searchChannelCondition.should().add(match_location2);
                }
                booleanQueryCondition.must().add(searchChannelCondition);
            }
        } else if (location != 0) {
            match_location = new MatchQueryCondition();
            match_location.setColumnName("sku_location");
            match_location.setValue("'" + location + "'");
            booleanQueryCondition.must().add(match_location);
        }
        if (searchBarReqBO.getQueryStr() != null) {
            BooleanQueryCondition extSkuIdQueryCondition = new BooleanQueryCondition();
            MatchQueryCondition matchExtSkuId = new MatchQueryCondition();
            matchExtSkuId.setColumnName("ext_sku_id");
            matchExtSkuId.setValue("'" + searchBarReqBO.getQueryStr() + "'");
            extSkuIdQueryCondition.must().add(matchExtSkuId);
            extSkuIdQueryCondition.must().add(match_status);
            extSkuIdQueryCondition.should().add(booleanQueryCondition);
            searchBuilder.queryBuilder().setCondition((QueryCondition)extSkuIdQueryCondition);
        } else {
            searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition);
        }
        if (searchBarReqBO.getCategoryId() != null && searchBarReqBO.getLevel() != null) {
            MatchFilterCondition match_6 = new MatchFilterCondition();
            if (searchBarReqBO.getLevel() == 1) {
                match_6.setColumnName("l1_category_id");
                match_6.setValue((Object)("'" + searchBarReqBO.getCategoryId() + "'"));
                filter.must().add(match_6);
            } else if (searchBarReqBO.getLevel() == 2) {
                match_6.setColumnName("l2_category_id");
                match_6.setValue((Object)("'" + searchBarReqBO.getCategoryId() + "'"));
                filter.must().add(match_6);
            } else if (searchBarReqBO.getLevel() == 3) {
                match_6.setColumnName("l3_category_id");
                if (searchChannels != null && searchChannels.size() > 0) {
                    match_6.setValue((Object)("\"" + searchBarReqBO.getCategoryId() + "*~~" + 0 + "\""));
                    filter.must().add(match_6);
                } else if (location == 1 || location == 2) {
                    match_6.setValue((Object)("\"" + searchBarReqBO.getCategoryId() + "*~~" + location + "\""));
                    filter.must().add(match_6);
                }
            }
        }
        if (searchBarReqBO.getSupplierId() != null) {
            MatchFilterCondition match_7 = new MatchFilterCondition();
            match_7.setColumnName("supplier_id");
            match_7.setValue((Object)String.valueOf(searchBarReqBO.getSupplierId()));
            filter.must().add(match_7);
        }
        try {
            if (null != searchBarReqBO.getMinSalesPrice()) {
                match_range = new RangeFilterCondition();
                match_range.setColumnName("sale_price");
                match_range.gte((Number)MoneyUtils.BigDecimal2Long((BigDecimal)searchBarReqBO.getMinSalesPrice()));
                filter.must().add(match_range);
            }
            if (null != searchBarReqBO.getMaxSalesPrice()) {
                match_range = new RangeFilterCondition();
                match_range.setColumnName("sale_price");
                match_range.lte((Number)MoneyUtils.BigDecimal2Long((BigDecimal)searchBarReqBO.getMaxSalesPrice()));
                filter.must().add(match_range);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        try {
            if (null != searchBarReqBO.getMinSalesPrice()) {
                match_range = new RangeFilterCondition();
                match_range.setColumnName("sale_price");
                match_range.gte((Number)MoneyUtils.BigDecimal2Long((BigDecimal)searchBarReqBO.getMinSalesPrice()));
                filter.must().add(match_range);
            }
            if (null != searchBarReqBO.getMaxSalesPrice()) {
                match_range = new RangeFilterCondition();
                match_range.setColumnName("sale_price");
                match_range.lte((Number)MoneyUtils.BigDecimal2Long((BigDecimal)searchBarReqBO.getMaxSalesPrice()));
                filter.must().add(match_range);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        if (!filter.must().isEmpty() || !filter.should().isEmpty()) {
            searchBuilder.filterBuilder().setFilterCondition((FilterCondition)filter);
            searchBuilder.aggregateBuilder().setGroupId("brand_id").count();
            searchBuilder.aggregateBuilder().setGroupId("l3_category_id").count().filterBuilder().setFilterCondition((FilterCondition)filter);
            searchBuilder.aggregateBuilder().setGroupId("supplier_id").count();
            searchBuilder.aggregateBuilder().setNestedColName("properties").filterBuilder().setFilterCondition((FilterCondition)filter);
        } else {
            searchBuilder.aggregateBuilder().setGroupId("brand_id").count();
            searchBuilder.aggregateBuilder().setGroupId("l3_category_id").count();
            searchBuilder.aggregateBuilder().setGroupId("supplier_id").count();
            searchBuilder.aggregateBuilder().setNestedColName("properties");
        }
        String kvpairs = null;
        if (searchBarReqBO.getUserId() != null) {
            kvpairs = this.getagreementIds("user", searchBarReqBO.getUserId());
        }
        if (searchBarReqBO.getOrderByColumn() == 1) {
            if (searchBarReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("sold_number", SearchSortMode.DESC);
            }
            if (searchBarReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("sold_number", SearchSortMode.ASC);
            }
        } else if (searchBarReqBO.getOrderByColumn() == 2) {
            if (searchBarReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.DESC);
            }
            if (searchBarReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.ASC);
            }
        } else if (searchBarReqBO.getOrderByColumn() == 3) {
            if (searchBarReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("sale_price", SearchSortMode.DESC);
            }
            if (searchBarReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("sale_price", SearchSortMode.ASC);
            }
        } else if (searchBarReqBO.getOrderByColumn() == 4) {
            if (searchBarReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("discount_rate", SearchSortMode.DESC);
            }
            if (searchBarReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("discount_rate", SearchSortMode.ASC);
            }
        } else if (kvpairs != null && searchBarReqBO.getQueryLocation() != 2) {
            RankCondition rankCondition = new RankCondition();
            rankCondition.setSecondRankName("second");
            searchBuilder.rankBuilder().setRankCondition(rankCondition);
            searchBuilder.setKvpairs("agreement_id:" + kvpairs);
        }
        log.info((Object)searchBuilder);
        Result result = searchBuilder.build();
        if (result.getTotal() == 0L) {
            JSONArray errorJsonArr = result.getErrors();
            if (errorJsonArr.length() > 0) {
                int i = 0;
                if (i < errorJsonArr.length()) {
                    JSONObject errorJson = errorJsonArr.getJSONObject(i);
                    if (errorJson.getLong("code") == 6009L) {
                        throw new BusinessException("RSP_CODE_EXCEED_LENGTH", "\u8bf7\u6c42\u641c\u7d22\u4e2d\u5fc3\u8fd4\u56de\uff1a\u7b5b\u9009\u6761\u4ef6\u8fc7\u591a\uff01");
                    }
                    throw new BusinessException("RSP_CODE_EXCEED_LENGTH", "\u8bf7\u6c42\u641c\u7d22\u4e2d\u5fc3\u8fd4\u56de\uff1a" + errorJson.getString("message"));
                }
            } else {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u641c\u7d22\u680f\u641c\u7d22\u4e1a\u52a1 \u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u641c\u7d22\u6761\u4ef6\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
        }
        ArrayList<SearchBarRspInfo> rspInfos = new ArrayList<SearchBarRspInfo>();
        SearchBarRspInfo rspInfo = new SearchBarRspInfo();
        JSONArray recordJsonArr = result.getItems();
        for (int i = 0; i < recordJsonArr.length(); ++i) {
            rspInfo = new SearchBarRspInfo();
            JSONObject recordJson = recordJsonArr.getJSONObject(i);
            rspInfo.setSkuId(String.valueOf(recordJson.get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(recordJson.get("ext_sku_id")));
            rspInfo.setPriPicUrl(String.valueOf(recordJson.get("picture_url")));
            rspInfo.setSaleArea(String.valueOf(recordJson.get("sale_area")));
            rspInfo.setSkuName(String.valueOf(recordJson.get("sku_name")));
            rspInfo.setSkuLocation(String.valueOf(recordJson.get("sku_location")));
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(recordJson.get("supplier_id")))));
            rspInfo.setSupplierName(String.valueOf(recordJson.get("supplier_name")));
            try {
                if (recordJson.get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(recordJson.get("market_price")))));
                }
                if (recordJson.get("sale_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(recordJson.get("sale_price")))));
                }
                if (recordJson.get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(recordJson.get("member_price")))));
                }
                if (searchBarReqBO.getUserId() != null) {
                    log.debug((Object)"\u5546\u54c1\u4e2d\u5fc3\u641c\u7d22\u680f\u670d\u52a1-\u7528\u6237\u5df2\u767b\u5f55");
                    if (recordJson.get("agreement_id") != null && "1".equals(rspInfo.getSkuLocation())) {
                        String agreementIdStr = String.valueOf(Long.parseLong(String.valueOf(recordJson.get("agreement_id"))));
                        if (agreementIdStr != null && !"0".equals(agreementIdStr) && kvpairs != null && kvpairs.indexOf(agreementIdStr) == -1) {
                            rspInfo.setLimitBuyFlag(Integer.valueOf(1));
                        }
                        if (agreementIdStr != null && !"0".equals(agreementIdStr) && kvpairs == null) {
                            rspInfo.setLimitBuyFlag(Integer.valueOf(1));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            rspInfos.add(rspInfo);
            log.debug(rspInfos);
        }
        SearchBarRspBO bo = new SearchBarRspBO();
        bo.setQueryStr(searchBarReqBO.getQueryStr());
        bo.setCategoryId(searchBarReqBO.getCategoryId());
        bo.setSupplierId(searchBarReqBO.getSupplierId());
        bo.setQueryLocation(searchBarReqBO.getQueryLocation());
        bo.setPageNo(searchBarReqBO.getPageNo());
        bo.setTotalCount(Long.valueOf(result.getTotal()));
        bo.setResult(rspInfos);
        bo.setSearchChannels(searchChannels);
        if (searchBarReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        JSONArray arr = result.getAggs();
        LinkedList<QueryParam> testParams = new LinkedList<QueryParam>();
        block11: for (int i = 0; i < arr.length(); ++i) {
            Object name;
            String temp;
            int kk;
            List<String> lists;
            ArrayList<String> x;
            String name2;
            String valueFromObj;
            JSONObject itemObj;
            int j;
            List<Object> valuesFromArrTemp;
            LinkedList<String> valuesFromArr;
            JSONArray itemArr;
            JSONObject arrObj = arr.getJSONObject(i);
            String s = null;
            if ("brand_id".equals(arrObj.get("key")) && !hiddenParamsForRsp.contains("brand_id_name")) {
                itemArr = arrObj.getJSONArray("items");
                valuesFromArr = new LinkedList<String>();
                valuesFromArrTemp = new LinkedList();
                for (j = 0; j < itemArr.length(); ++j) {
                    itemObj = itemArr.getJSONObject(j);
                    valueFromObj = itemObj.getString("value");
                    if ("".equals(valueFromObj) || valueFromObj == null) continue;
                    name2 = this.getInnerBrandByKey("brand", valueFromObj);
                    valueFromObj = name2 + "*~~" + valueFromObj;
                    valuesFromArr.add(valueFromObj);
                }
                if (valuesFromArr.size() > 0) {
                    QueryParam singleQP = new QueryParam();
                    singleQP.setFilterId("brand_id_name");
                    singleQP.setFilterName("\u54c1\u724c");
                    valuesFromArrTemp = this.order(valuesFromArr);
                    valuesFromArr = new LinkedList();
                    for (int k = 0; k < valuesFromArrTemp.size(); ++k) {
                        s = (String)valuesFromArrTemp.get(k);
                        valuesFromArr.add(s.split("\\*~~")[1] + "*~~" + s.split("\\*~~")[0]);
                    }
                    singleQP.setFilterValues(valuesFromArr);
                    LinkedHashMap<String, List<String>> m = this.convertMap(valuesFromArrTemp);
                    x = null;
                    lists = null;
                    for (String key : m.keySet()) {
                        lists = m.get(key);
                        x = new ArrayList<String>();
                        for (kk = 0; kk < lists.size(); ++kk) {
                            temp = lists.get(kk);
                            x.add(temp.split("\\*~~")[1] + "*~~" + temp.split("\\*~~")[0]);
                        }
                        m.put(key, x);
                    }
                    singleQP.setFilterValuesByOrder(m);
                    testParams.add(singleQP);
                }
            }
            if ("supplier_id".equals(arrObj.get("key")) && !hiddenParamsForRsp.contains("supplier_id_name")) {
                itemArr = arrObj.getJSONArray("items");
                valuesFromArr = new LinkedList();
                valuesFromArrTemp = new LinkedList();
                for (j = 0; j < itemArr.length(); ++j) {
                    itemObj = itemArr.getJSONObject(j);
                    valueFromObj = itemObj.getString("value");
                    if ("".equals(valueFromObj) || valueFromObj == null) continue;
                    name2 = this.getInnerBrandByKey("supplier", valueFromObj);
                    valueFromObj = name2 + "*~~" + valueFromObj;
                    valuesFromArr.add(valueFromObj);
                }
                if (valuesFromArr.size() > 0) {
                    QueryParam singleQP = new QueryParam();
                    singleQP.setFilterId("supplier_id_name");
                    singleQP.setFilterName("\u4f9b\u5e94\u5546");
                    valuesFromArrTemp = this.order(valuesFromArr);
                    valuesFromArr = new LinkedList();
                    for (int k = 0; k < valuesFromArrTemp.size(); ++k) {
                        s = (String)valuesFromArrTemp.get(k);
                        valuesFromArr.add(s.split("\\*~~")[1] + "*~~" + s.split("\\*~~")[0]);
                    }
                    singleQP.setFilterValues(valuesFromArr);
                    LinkedHashMap<String, List<String>> m = this.convertMap(valuesFromArrTemp);
                    x = null;
                    lists = null;
                    for (String key : m.keySet()) {
                        lists = m.get(key);
                        x = new ArrayList();
                        for (kk = 0; kk < lists.size(); ++kk) {
                            temp = lists.get(kk);
                            x.add(temp.split("\\*~~")[1] + "*~~" + temp.split("\\*~~")[0]);
                        }
                        m.put(key, x);
                    }
                    singleQP.setFilterValuesByOrder(m);
                    testParams.add(singleQP);
                }
            }
            if ("l3_category_id".equals(arrObj.get("key")) && !hiddenParamsForRsp.contains("l3_category_id_name")) {
                itemArr = arrObj.getJSONArray("items");
                valuesFromArr = new LinkedList();
                valuesFromArrTemp = new LinkedList();
                for (int j2 = 0; j2 < itemArr.length(); ++j2) {
                    itemObj = itemArr.getJSONObject(j2);
                    valueFromObj = itemObj.getString("value");
                    String[] ids = valueFromObj.split("\\*~~");
                    if (ids.length <= 0 || ids[0] == null || ids[1] == null || "0".equals(ids[1]) || "".equals(valueFromObj = (String)(name = this.getInnerBrandByKey("category", ids[0])) + "*~~" + ids[0]) || valueFromObj == null) continue;
                    valuesFromArr.add(valueFromObj);
                }
                if (valuesFromArr.size() > 0) {
                    QueryParam singleQP = new QueryParam();
                    singleQP.setFilterId("l3_category_id_name");
                    singleQP.setFilterName("\u5206\u7c7b");
                    valuesFromArrTemp = this.order(valuesFromArr);
                    valuesFromArr = new LinkedList();
                    for (int k = 0; k < valuesFromArrTemp.size(); ++k) {
                        s = (String)valuesFromArrTemp.get(k);
                        valuesFromArr.add(s.split("\\*~~")[1] + "*~~" + s.split("\\*~~")[0]);
                    }
                    singleQP.setFilterValues(valuesFromArr);
                    LinkedHashMap<String, List<String>> m = this.convertMap(valuesFromArrTemp);
                    x = null;
                    lists = null;
                    name = m.keySet().iterator();
                    while (name.hasNext()) {
                        String key;
                        key = (String)name.next();
                        lists = m.get(key);
                        x = new ArrayList();
                        for (kk = 0; kk < lists.size(); ++kk) {
                            temp = lists.get(kk);
                            x.add(temp.split("\\*~~")[1] + "*~~" + temp.split("\\*~~")[0]);
                        }
                        m.put(key, x);
                    }
                    singleQP.setFilterValuesByOrder(m);
                    testParams.add(singleQP);
                }
            }
            if (!"properties".equals(arrObj.get("key")) || searchBarReqBO.getQueryLocation() == 2) continue;
            itemArr = arrObj.getJSONArray("items");
            Hashtable<String, String> singleParam = new Hashtable<String, String>();
            LinkedList<Map<String, String>> singleParams = new LinkedList<Map<String, String>>();
            for (int j3 = 0; j3 < itemArr.length(); ++j3) {
                singleParam = new Hashtable();
                itemObj = itemArr.getJSONObject(j3);
                String itemMapStr = itemObj.getString("value");
                String[] itemMapStrs = itemMapStr.split("\\*~~");
                if (itemMapStrs.length <= 1 || "".equals(itemMapStrs[0]) || "".equals(itemMapStrs[1]) || (name = this.getInnerBrandByKey("property", itemMapStrs[0])) == null || ((String)name).indexOf("\u54c1\u724c") != -1) continue;
                singleParam.put(itemMapStrs[0] + "*~~" + (String)name, itemMapStrs[1]);
                singleParams.add(singleParam);
            }
            if (singleParams.isEmpty()) continue;
            Map<String, List<String>> mapForListSearch = this.convertListMapToMap(singleParams);
            int cnt = 0;
            for (Map.Entry<String, List<String>> entry : mapForListSearch.entrySet()) {
                QueryParam singleParamFromProp = new QueryParam();
                String[] keyStr = entry.getKey().split("\\*~~");
                if (hiddenParamsForRsp.contains(keyStr[0])) continue;
                singleParamFromProp.setFilterId(keyStr[0]);
                singleParamFromProp.setFilterName(keyStr[1]);
                singleParamFromProp.setFilterValues(entry.getValue());
                testParams.add(singleParamFromProp);
                if (++cnt < 8) continue;
                continue block11;
            }
        }
        bo.setQueryParams(testParams);
        return bo;
    }

    private Map<String, List<String>> convertListMapToMap(List<Map<String, String>> list) {
        HashMap<String, HashSet<String>> setResult = new HashMap<String, HashSet<String>>();
        for (Map<String, String> map : list) {
            for (String key : map.keySet()) {
                HashSet<String> value = (HashSet<String>)setResult.get(key);
                if (value == null) {
                    value = new HashSet<String>();
                }
                value.add(map.get(key));
                setResult.put(key, value);
            }
        }
        HashMap<String, List<String>> listResult = new HashMap<String, List<String>>();
        for (String key : setResult.keySet()) {
            Set set = (Set)setResult.get(key);
            LinkedList valueList = new LinkedList();
            valueList.addAll(set);
            listResult.put(key, valueList);
        }
        return listResult;
    }

    private void addFilterFromParam(QueryParam param, BooleanFilterCondition filter, int queryLocation, BooleanQueryCondition queryCondition, List<Integer> searchChannels) {
        List values = param.getFilterValues();
        for (int i = 0; i < values.size(); ++i) {
            MatchQueryCondition matchQueryCondition = new MatchQueryCondition();
            MatchFilterCondition matchFilter = new MatchFilterCondition();
            String comStr = "";
            if ("supplier_id_name".equals(param.getFilterId())) {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("supplier_id");
                match_default.setValue("'" + ((String)values.get(i)).split("\\*~~")[0] + "'");
                queryCondition.should().add(match_default);
                continue;
            }
            if ("brand_id_name".equals(param.getFilterId())) {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("brand_id");
                match_default.setValue("'" + ((String)values.get(i)).split("\\*~~")[0] + "'");
                queryCondition.should().add(match_default);
                continue;
            }
            if ("l3_category_id_name".equals(param.getFilterId())) {
                if (searchChannels == null || searchChannels.size() == 0) {
                    if (queryLocation == 0) {
                        for (int j = 0; j < 3; ++j) {
                            matchQueryCondition = new MatchQueryCondition();
                            matchQueryCondition.setColumnName("l3_category_id");
                            String[] ids = ((String)values.get(i)).split("\\*~~");
                            comStr = "\"" + ids[0] + "*~~" + j + "\"";
                            matchQueryCondition.setValue(comStr);
                            queryCondition.should().add(matchQueryCondition);
                            matchFilter = new MatchFilterCondition();
                            matchFilter.setColumnName("l3_category_id");
                            matchFilter.setValue((Object)comStr);
                            filter.should().add(matchFilter);
                        }
                        continue;
                    }
                    matchQueryCondition.setColumnName("l3_category_id");
                    String[] ids = ((String)values.get(i)).split("\\*~~");
                    comStr = "\"" + ids[0] + "*~~" + queryLocation + "\"";
                    matchQueryCondition.setValue(comStr);
                    queryCondition.should().add(matchQueryCondition);
                    matchFilter.setColumnName("l3_category_id");
                    matchFilter.setValue((Object)comStr);
                    filter.should().add(matchFilter);
                    continue;
                }
                matchQueryCondition.setColumnName("l3_category_id");
                String[] ids = ((String)values.get(i)).split("\\*~~");
                comStr = "\"" + ids[0] + "*~~" + 0 + "\"";
                matchQueryCondition.setValue(comStr);
                queryCondition.should().add(matchQueryCondition);
                matchFilter.setColumnName("l3_category_id");
                matchFilter.setValue((Object)comStr);
                filter.should().add(matchFilter);
                continue;
            }
            matchQueryCondition.setColumnName("properties");
            String propStr = (String)values.get(i);
            if (SpecialSymbolUtils.isSpecialSymbols(propStr)) {
                char x = SpecialSymbolUtils.specialSymbol(propStr);
                propStr = propStr.replace(String.valueOf(x), "\\" + String.valueOf(x));
            }
            matchQueryCondition.setValue("\"" + param.getFilterId() + "*~~" + propStr + "\"");
            queryCondition.should().add(matchQueryCondition);
            matchFilter.setColumnName("properties");
            matchFilter.setValue((Object)("\"" + param.getFilterId() + "*~~" + propStr + "\""));
            filter.should().add(matchFilter);
        }
    }

    private String getInnerBrandByKey(String keyName, String key) {
        byte[] value = this.cacheManager.get((keyName + "_" + key).getBytes());
        if (value == null || value.length <= 0) {
            CommodityPropDef prop;
            log.debug((Object)"\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            if (keyName.equals("brand")) {
                Brand brand = this.brandMapper.selectByPrimaryKey(Long.parseLong(key));
                if (brand != null) {
                    this.put("brand_" + key, brand.getBrandName());
                }
            } else if (keyName.equals("supplier")) {
                String supplierName;
                block15: {
                    supplierName = (String)this.prop.get("SUPPLIER_NAME_" + key);
                    QryOrgInfoByIdRspBO qryOrgInfoByIdRspBO = null;
                    try {
                        if (supplierName != null) break block15;
                        Long organizationId = Long.parseLong(key);
                        QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
                        qryOrgInfoByIdReqBO.setOrganizationId(organizationId);
                        qryOrgInfoByIdRspBO = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
                        if ("0000".equals(qryOrgInfoByIdRspBO.getRespCode())) {
                            UserOrganisationBO userOrganisationBO = qryOrgInfoByIdRspBO.getUserOrganisationBO();
                            if (userOrganisationBO != null && userOrganisationBO.getTitle() != null) {
                                supplierName = userOrganisationBO.getTitle();
                            }
                            break block15;
                        }
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u641c\u7d22\u680f\u670d\u52a1\u9519\u8bef\uff1a\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784[QryOrgInfoByIdBusiService]\u8fd4\u56de" + qryOrgInfoByIdRspBO.getRespDesc());
                    }
                    catch (Exception e) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u641c\u7d22\u680f\u670d\u52a1\u9519\u8bef\uff1a\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784[QryOrgInfoByIdBusiService]\u8fd4\u56de\u5f02\u5e38\uff1a" + qryOrgInfoByIdRspBO.getRespDesc());
                    }
                }
                if (supplierName != null) {
                    this.put("supplier_" + key, supplierName);
                }
            } else if (keyName.equals("category")) {
                CommodityGuideCatalog catalog = this.commodityGuideCatalogMapper.selectByPrimaryKey(Long.parseLong(key));
                if (catalog != null) {
                    this.put("category_" + key, catalog.getCatalogName());
                }
            } else if (keyName.equals("property") && (prop = this.commodityPropDefMapper.selectByPrimaryKey(Long.parseLong(key))) != null) {
                this.put("property_" + key, prop.getPropName());
            }
            return (String)SerializeUtils.deserialize((byte[])this.cacheManager.get((keyName + "_" + key).getBytes()));
        }
        return (String)SerializeUtils.deserialize((byte[])value);
    }

    private void put(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize((Object)value), 600);
    }

    private void put(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize((Object)value), expire);
    }

    private String getagreementIds(String keyName, Long userId) {
        byte[] value;
        block10: {
            value = this.cacheManager.get((keyName + "_" + userId).getBytes());
            if (value == null || value.length <= 0) {
                log.debug((Object)"\u767b\u9646\u7528\u6237\u534f\u8bae\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u6570\u636e");
                try {
                    HashSet<Long> agreementIds = new HashSet<Long>();
                    QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO = new QryLittleActOrgByUserReqBO();
                    qryLittleActOrgByUserReqBO.setUserParamId(userId);
                    QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO = this.qryLittleActOrgByUserBusiService.qryLittleActOrgByUser(qryLittleActOrgByUserReqBO);
                    if ("0000".equals(qryLittleActOrgByUserRspBO.getRespCode())) {
                        Long provId = qryLittleActOrgByUserRspBO.getProvId();
                        Long trade = qryLittleActOrgByUserRspBO.getTrade();
                        UserOrganisationBO branchComp = qryLittleActOrgByUserRspBO.getBranchComp();
                        UserOrganisationBO projectComp = qryLittleActOrgByUserRspBO.getProjectComp();
                        Long orgId = null;
                        List<Long> ids = null;
                        if (provId != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = provId, 1L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (trade != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = trade, 2L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (branchComp != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = branchComp.getAutoId(), 3L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (projectComp != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = projectComp.getAutoId(), 4L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (agreementIds.size() > 0) {
                            StringBuffer redisIds = new StringBuffer();
                            for (Long id : agreementIds) {
                                redisIds.append(id + ":");
                            }
                            redisIds.deleteCharAt(redisIds.length() - 1);
                            this.put("user_" + userId, redisIds.toString(), 600);
                            return (String)SerializeUtils.deserialize((byte[])this.cacheManager.get((keyName + "_" + userId).getBytes()));
                        }
                        break block10;
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u641c\u7d22\u680f\u670d\u52a1\u9519\u8bef\uff1a\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f[QryLittleActOrgByUserBusiService]\u8fd4\u56de" + qryLittleActOrgByUserRspBO.getRespDesc());
                }
                catch (Exception e) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u641c\u7d22\u680f\u670d\u52a1\u9519\u8bef\uff1a\u5f02\u5e38\u4fe1\u606f\u4e3a" + e.getMessage());
                }
            }
        }
        return (String)SerializeUtils.deserialize((byte[])value);
    }

    private LinkedHashMap<String, List<String>> convertMap(List<String> lists) {
        String[] arrays = lists.toArray(new String[lists.size()]);
        for (int i = 0; i < arrays.length; ++i) {
            String str = arrays[i].trim();
            if (str.length() == 0) {
                return null;
            }
            String alphabet = str.substring(0, 1);
            if (alphabet.matches("[\\u4e00-\\u9fa5]+")) {
                arrays[i] = str = SearchBarServiceImpl.getAlphabet(str) + "^" + str;
                continue;
            }
            char[] nameChar = alphabet.toCharArray();
            char c = nameChar[0];
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
                arrays[i] = str = c + "^" + str;
                continue;
            }
            arrays[i] = c >= 'A' && c <= 'Z' ? (str = c + "^" + str) : (str = "\u5176\u5b83^" + str);
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        List<String> queryParam = null;
        String key = null;
        String value = null;
        for (int i = 0; i < arrays.length; ++i) {
            String str = arrays[i];
            key = str.split("\\^")[0];
            value = str.split("\\^")[1];
            queryParam = map.get(key);
            if (queryParam != null) {
                if (queryParam.contains(value)) continue;
                queryParam.add(value);
                map.put(key, queryParam);
                continue;
            }
            queryParam = new ArrayList<String>();
            queryParam.add(value);
            map.put(key, queryParam);
        }
        return map;
    }

    private List<String> order(List<String> lists) {
        String[] arrays = lists.toArray(new String[lists.size()]);
        for (int i = 0; i < arrays.length; ++i) {
            String str = arrays[i];
            if (str.length() == 0) {
                return null;
            }
            String alphabet = str.substring(0, 1);
            if (alphabet.matches("[\\u4e00-\\u9fa5]+")) {
                arrays[i] = str = SearchBarServiceImpl.getAlphabet(str) + "^" + str;
                continue;
            }
            char[] nameChar = alphabet.toCharArray();
            char c = nameChar[0];
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
                arrays[i] = str = c + "^" + str;
                continue;
            }
            arrays[i] = c >= 'A' && c <= 'Z' ? (str = c + "^" + str) : (str = "ZZ^" + str);
        }
        Collator com = Collator.getInstance(Locale.CHINA);
        Arrays.sort(arrays, com);
        for (int i = 0; i < arrays.length; ++i) {
            String str = arrays[i];
            if (!str.contains("^") || str.indexOf("^") != 1 && str.indexOf("^") != 2) continue;
            arrays[i] = str.split("\\^")[1];
        }
        return Arrays.asList(arrays);
    }

    private static String getAlphabet(String str) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String pinyin = null;
        try {
            pinyin = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(0), (HanyuPinyinOutputFormat)defaultFormat)[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return pinyin.substring(0, 1);
    }
}

