/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.SkuStateChangeLogService;
import com.cgd.commodity.busi.bo.SkuStateChangeLogReqBO;
import com.cgd.commodity.busi.vo.SkuStateChangeLogReqVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuStateChangeLogMapper;
import com.cgd.commodity.po.SkuStateChangeLog;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuStateChangeLogServiceImpl
implements SkuStateChangeLogService {
    private static final Logger logger = LoggerFactory.getLogger(SkuStateChangeLogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuStateChangeLogMapper skuStateChangeLogMapper;

    public void setSkuStateChangeLogMapper(SkuStateChangeLogMapper skuStateChangeLogMapper) {
        this.skuStateChangeLogMapper = skuStateChangeLogMapper;
    }

    public RspBusiBaseBO insertSkuStateChangeLog(SkuStateChangeLogReqBO skuStateChangeLogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuStateChangeLogReqBO.toString());
        }
        if (skuStateChangeLogReqBO.getSkuStateChangeLogs().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u96c6\u5408[skuStateChangeLogs]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ArrayList<SkuStateChangeLog> skuStateChangeLogs = new ArrayList<SkuStateChangeLog>();
            for (SkuStateChangeLogReqVO skuStateChangeLogReqVO : skuStateChangeLogReqBO.getSkuStateChangeLogs()) {
                SkuStateChangeLog skuStateChangeLog = new SkuStateChangeLog();
                skuStateChangeLog.setSkuId(skuStateChangeLogReqVO.getSkuId());
                skuStateChangeLog.setSupplierId(skuStateChangeLogReqVO.getSupplierId());
                skuStateChangeLog.setSkuName(skuStateChangeLogReqVO.getSkuName());
                skuStateChangeLog.setPostState(skuStateChangeLogReqVO.getPostState());
                skuStateChangeLog.setPreState(skuStateChangeLogReqVO.getPreState());
                skuStateChangeLog.setApproveComments(skuStateChangeLogReqVO.getApproveComments());
                skuStateChangeLog.setCreateLoginId(skuStateChangeLogReqVO.getCreateLoginId());
                skuStateChangeLog.setCreateTime(skuStateChangeLogReqVO.getCreateTime());
                skuStateChangeLog.setIsDelete(Constant.IS_DELETE);
                skuStateChangeLog.setRemark(skuStateChangeLogReqVO.getRemark());
                if (null != skuStateChangeLogReqVO.getUpdateLoginId()) {
                    skuStateChangeLog.setUpdateLoginId(skuStateChangeLogReqVO.getUpdateLoginId());
                    skuStateChangeLog.setUpdateTime(new Date());
                }
                skuStateChangeLogs.add(skuStateChangeLog);
            }
            this.skuStateChangeLogMapper.insertBatch(skuStateChangeLogs);
            RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
            rspBusiBaseBO.setRespCode("0000");
            rspBusiBaseBO.setRespDesc("\u6210\u529f");
            return rspBusiBaseBO;
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }
}

