/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.web.Impl;

import com.ohaotian.commodity.busi.manage.market.extend.QueryCatalogNameService;
import com.ohaotian.commodity.busi.web.QuerySkuApproveListService;
import com.ohaotian.commodity.busi.web.bo.QueryWaitApproveSkuListReqBO;
import com.ohaotian.commodity.busi.web.bo.QueryWaitApproveSkuListRspBO;
import com.ohaotian.commodity.dao.ElecSkuOnShelveApprTaskMapper;
import com.ohaotian.commodity.dao.po.ElecSkuOnShelveApprTaskPO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="querySkuApproveListService")
public class QuerySkuApproveListServiceImpl
implements QuerySkuApproveListService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuApproveListServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private ElecSkuOnShelveApprTaskMapper elecSkuOnShelveApprTaskMapper;
    @Autowired
    QueryCatalogNameService queryCatalogNameService;

    public RspPageBO<QueryWaitApproveSkuListRspBO> queryWaitApproveSkuList(QueryWaitApproveSkuListReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5f85\u5ba1\u6838\u5546\u54c1\u5217\u8868\u5165\u53c2\uff1a" + reqBO.toString());
        }
        RspPageBO rspPageBO = new RspPageBO();
        ArrayList<QueryWaitApproveSkuListRspBO> queryWaitApproveSkuListRspBO = new ArrayList<QueryWaitApproveSkuListRspBO>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        try {
            List<ElecSkuOnShelveApprTaskPO> list = this.elecSkuOnShelveApprTaskMapper.queryWaitApproveSkuList((Page<ElecSkuOnShelveApprTaskPO>)page, reqBO);
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            for (ElecSkuOnShelveApprTaskPO elecSkuOnShelveApprTask : list) {
                Long commodityTypeId = elecSkuOnShelveApprTask.getCommodityTypeId();
                commodityTypeIds.add(commodityTypeId);
            }
            Map<Object, Object> map = new HashMap();
            if (commodityTypeIds != null && commodityTypeIds.size() > 0) {
                map = this.queryCatalogNameService.queryMdmCatalogMapByCommodityTypeId(commodityTypeIds);
            }
            for (ElecSkuOnShelveApprTaskPO value : list) {
                QueryWaitApproveSkuListRspBO bo = new QueryWaitApproveSkuListRspBO();
                if (map != null && map.size() > 0) {
                    Long typeId = value.getCommodityTypeId();
                    String s = (String)map.get(typeId);
                    bo.setCommodityTypeName(s);
                }
                bo.setCatalogId(value.getCatalogId());
                bo.setSkuName(value.getSkuName());
                bo.setBrandName(value.getBrandName());
                if (value.getElecSkuOnShelveApprTaskId() != null) {
                    bo.setElecSkuOnShelveApprTaskId(value.getElecSkuOnShelveApprTaskId());
                }
                bo.setTaskId(value.getTaskId());
                if (value.getSupplierId() != null) {
                    bo.setSupplierId(value.getSupplierId());
                }
                bo.setSkuStatus(Integer.valueOf(value.getSkuStatus()));
                if (value.getTaskStatus() != null) {
                    bo.setApproveStatus(Byte.valueOf((byte)value.getTaskStatus().intValue()));
                }
                bo.setSkuId(value.getSkuId());
                bo.setExtSkuId(value.getExtSkuId());
                if (value.getMarketPrice() != null) {
                    bo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)value.getMarketPrice()));
                }
                if (value.getAgreementPrice() != null) {
                    bo.setAgrPrice(MoneyUtils.Long2BigDecimal((Long)value.getAgreementPrice()));
                }
                if (value.getDiscountRate() != null) {
                    bo.setDiscountRate(value.getDiscountRate().toString());
                }
                bo.setPublishTime(value.getPublishTime());
                bo.setCreateTime(value.getCreateTime());
                queryWaitApproveSkuListRspBO.add(bo);
            }
            rspPageBO.setRespCode("0000");
            rspPageBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5f85\u5ba1\u6838\u5546\u54c1\u5217\u8868\u51fa\u9519", (Throwable)e);
            rspPageBO.setRespCode("8888");
            rspPageBO.setRespDesc("\u5931\u8d25");
        }
        rspPageBO.setPageNo(reqBO.getPageNo());
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setRows(queryWaitApproveSkuListRspBO);
        rspPageBO.setTotal(page.getTotalPages());
        return rspPageBO;
    }
}

