/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.util;

import com.ohaotian.commodity.busi.distribute.web.bo.FolderBO;
import com.ohaotian.commodity.util.FtpConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    private FTPClient ftpClient;
    private static final Logger logger = LoggerFactory.getLogger(FtpUtils.class);
    private static final String SEP_SLASH = "/";
    private int id = 0;

    public FtpUtils(FtpConfig ftpConfig) {
        this.ftpClient = this.login(ftpConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FolderBO> listFolders(String path) {
        this.ftpClient.enterLocalActiveMode();
        logger.info("\u5f00\u542flocalmodePassive");
        ArrayList<FolderBO> folderList = new ArrayList<FolderBO>();
        FolderBO folder = new FolderBO();
        folder.setPath(path);
        folder.setId(Integer.valueOf(0));
        String[] folders = path.split(SEP_SLASH);
        String name = folders[folders.length - 1];
        folder.setName(name);
        folderList.add(folder);
        try {
            this.listFolders(path, folderList);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6ftp\u6587\u4ef6\u5939\u5931\u8d25\uff01");
        }
        finally {
            try {
                logger.info("\u65ad\u5f00ftp\u8fde\u63a5");
                this.disconnectFtp();
            }
            catch (IOException e) {
                logger.error("\u65ad\u5f00ftp\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        logger.info("ftp\u6587\u4ef6\u5939\u4e2a\u6570 " + folderList.size());
        return folderList;
    }

    public void listFolders(String path, List<FolderBO> folderList) {
        if (null == folderList) {
            folderList = new ArrayList<FolderBO>();
        }
        try {
            logger.info("\u5f00\u59cb\u83b7\u53d6ftp\u6587\u4ef6\u5939\u5217\u8868\u3002");
            FTPFile[] ftpFiles = this.ftpClient.listDirectories(path);
            for (int i = 0; i < ftpFiles.length; ++i) {
                if (!ftpFiles[i].isDirectory() || ".".equals(ftpFiles[i].getName()) || "..".equals(ftpFiles[i].getName())) continue;
                String folderName = ftpFiles[i].getName();
                String tempDir = path + SEP_SLASH + folderName;
                this.ftpClient.setFileType(2);
                FolderBO folder = new FolderBO();
                folder.setId(Integer.valueOf(++this.id));
                folder.setName(folderName);
                String[] paths = tempDir.split(SEP_SLASH);
                String parentFolder = "root";
                if (paths != null) {
                    parentFolder = paths.length > 2 ? paths[paths.length - 2] : folderName;
                }
                folder.setPath(tempDir);
                folder.setParentName(parentFolder);
                folder.setParentId(this.findParentIdByPath(folderList, tempDir));
                folderList.add(folder);
                this.listFolders(tempDir, folderList);
            }
            logger.info("\u5f00\u59cb\u83b7\u53d6ftp\u6587\u4ef6\u5939\u5217\u8868\u5b8c\u6210\u3002");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u83b7\u53d6ftp\u6587\u4ef6\u5939\u5931\u8d25\uff01");
        }
    }

    public void disconnectFtp() throws IOException {
        try {
            this.ftpClient.disconnect();
        }
        catch (IOException e) {
            logger.error("\u65ad\u5f00\u8fde\u63a5\u5931\u8d25\uff01");
            throw e;
        }
    }

    private Integer findParentIdByPath(List<FolderBO> folderList, String path) {
        String[] dirs = path.split(SEP_SLASH);
        String matchPath = path;
        if (dirs != null && dirs.length > 1) {
            matchPath = path.substring(0, path.lastIndexOf(SEP_SLASH));
        }
        String matchPathLbd = matchPath;
        List matchFolderList = folderList.stream().filter(folder -> folder.getPath().equals(matchPathLbd)).collect(Collectors.toList());
        if (matchFolderList.size() > 0) {
            return ((FolderBO)matchFolderList.get(0)).getId();
        }
        return null;
    }

    private FTPClient login(FtpConfig ftpConfig) {
        FTPClient ftpClient = new FTPClient();
        try {
            logger.info("\u5f00\u59cb\u8fde\u63a5ftp\u670d\u52a1\u5668");
            ftpClient.connect(ftpConfig.getHostname(), ftpConfig.getPort().intValue());
            ftpClient.login(ftpConfig.getUsername(), ftpConfig.getPassword());
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftpClient.disconnect();
                logger.error("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01");
                throw new IOException("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01");
            }
            logger.info("ftp\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01");
        }
        return ftpClient;
    }
}

