/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.common.converter;

import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.StringUtils;

public class DateTypeEditor
extends PropertyEditorSupport {
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIMEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat dateFormat;
    private boolean allowEmpty = true;

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            try {
                if (this.dateFormat != null) {
                    this.setValue(this.dateFormat.parse(text));
                    return;
                }
                if (text.contains(":")) {
                    this.setValue(TIMEFORMAT.parse(text));
                } else {
                    this.setValue(DATEFORMAT.parse(text));
                }
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public String getAsText() {
        Date value = (Date)this.getValue();
        DateFormat dateFormat = this.dateFormat;
        if (dateFormat == null) {
            dateFormat = TIMEFORMAT;
        }
        return value != null ? dateFormat.format(value) : "";
    }
}

