/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.web.controller;

import com.ohaotian.base.common.exception.BusinessException;
import com.ohaotian.commodity.busi.manage.market.web.ElecSkuAuditService;
import com.ohaotian.commodity.busi.manage.market.web.ElecSkuOffOrOnShelveService;
import com.ohaotian.commodity.busi.manage.market.web.QueryBrandService;
import com.ohaotian.commodity.busi.manage.market.web.QueryElecSkuDetailService;
import com.ohaotian.commodity.busi.manage.market.web.bo.ElecSkuAuditReqBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.ElecSkuAuditRspBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.ElecSkuOffOrOnShelveReqBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.ElecSkuOffOrOnShelveRspBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryBrandReqBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryBrandRspBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryElecSkuDetailReqBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryElecSkuDetailRspBO;
import com.ohaotian.commodity.busi.web.QueryOnOffShelveElecSkuService;
import com.ohaotian.commodity.busi.web.QuerySkuApproveListService;
import com.ohaotian.commodity.busi.web.bo.QueryOnOffShelveElecSkuReqBO;
import com.ohaotian.commodity.busi.web.bo.QueryOnOffShelveElecSkuRspBO;
import com.ohaotian.commodity.busi.web.bo.QueryWaitApproveSkuListReqBO;
import com.ohaotian.commodity.busi.web.bo.QueryWaitApproveSkuListRspBO;
import com.ohaotian.commodity.busi.web.controller.vo.ElecSkuOffOrOnShelveReqVO;
import com.ohaotian.commodity.busi.web.controller.vo.ElecSkuOffOrOnShelveRspVO;
import com.ohaotian.commodity.busi.web.controller.vo.QueryBrandReqVO;
import com.ohaotian.commodity.busi.web.controller.vo.QueryOnOffShelveElecSkuRepVO;
import com.ohaotian.commodity.busi.web.controller.vo.QueryOnOffShelveElecSkuRspVO;
import com.ohaotian.commodity.busi.web.controller.vo.QueryWaitApproveSkuListReqVO;
import com.ohaotian.commodity.busi.web.controller.vo.QueryWaitApproveSkuListRspVO;
import com.ohaotian.commodity.common.user.UserInfo;
import com.ohaotian.commodity.controller.base.BaseRspPageVO;
import com.ohaotian.commodity.controller.base.BaseRspVO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"service/routing"})
public class ElecAuditServiceController {
    private static final Logger logger = LogManager.getLogger(ElecAuditServiceController.class);
    @Resource
    private ElecSkuAuditService elecSkuAuditService;
    @Resource
    private QueryOnOffShelveElecSkuService queryOnOffShelveElecSkuService;
    @Resource
    private QueryElecSkuDetailService queryElecSkuDetailService;
    @Resource
    private QuerySkuApproveListService querySkuApproveListService;
    @Resource
    private ElecSkuOffOrOnShelveService elecSkuOffOrOnShelveService;
    @Resource
    private QueryBrandService queryBrandService;

    @RequestMapping(value={"/elecSkuAudit"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseRspVO elecSkuAudit(@RequestBody ElecSkuAuditReqBO elecSkuAuditReqBO) {
        BaseRspVO<ElecSkuAuditRspBO> baseRspVO = new BaseRspVO<ElecSkuAuditRspBO>();
        String errorText = "";
        if (null == elecSkuAuditReqBO.getElecSkuAudits() || elecSkuAuditReqBO.getElecSkuAudits().isEmpty()) {
            errorText = " \u7535\u5b50\u8d85\u5e02\u5546\u54c1\u5ba1\u6838\u96c6\u5408[elecSkuAudits]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == elecSkuAuditReqBO.getSeqFlowId()) {
            errorText = errorText + " \u64cd\u4f5c\u6807\u8bc6[seqFlowId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == elecSkuAuditReqBO.getOperateName()) {
            errorText = errorText + " \u64cd\u4f5c\u540d\u79f0[operateName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!"".equals(errorText)) {
            baseRspVO.setRespCode("7777");
            baseRspVO.setRespDesc(errorText);
            return baseRspVO;
        }
        try {
            SecurityContext ctx = SecurityContextHolder.getContext();
            Authentication auth = ctx.getAuthentication();
            Object user = auth.getPrincipal();
            UserInfo userInfo = new UserInfo();
            BeanUtils.copyProperties((Object)user, (Object)userInfo);
            elecSkuAuditReqBO.setUserId(userInfo.getUid());
            ElecSkuAuditRspBO data = this.elecSkuAuditService.elecSkuAudit(elecSkuAuditReqBO);
            baseRspVO.setData(data);
            baseRspVO.setRespCode(data.getRespCode());
            baseRspVO.setRespDesc(data.getRespDesc());
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5ba1\u6838\u9a73\u56de\u670d\u52a1controller\u5931\u8d25" + e);
            throw new BusinessException(null, "\u5546\u54c1\u5ba1\u6838\u9a73\u56de\u670d\u52a1controller\u5931\u8d25");
        }
        return baseRspVO;
    }

    @RequestMapping(value={"queryOnOffShelveElecSku"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseRspPageVO<QueryOnOffShelveElecSkuRspVO> queryOnOffShelveElecSku(@RequestBody QueryOnOffShelveElecSkuRepVO qrySkuRepVO) {
        QueryOnOffShelveElecSkuReqBO qsReqBO = new QueryOnOffShelveElecSkuReqBO();
        RspPageBO queryOnOffShelveElecSku = null;
        ArrayList<QueryOnOffShelveElecSkuRspVO> listVO = new ArrayList<QueryOnOffShelveElecSkuRspVO>();
        try {
            BeanUtils.copyProperties((Object)((Object)qrySkuRepVO), (Object)qsReqBO);
            if (qrySkuRepVO.getSkuId() != null && qrySkuRepVO.getSkuId() != "") {
                qsReqBO.setSkuId(Long.valueOf(qrySkuRepVO.getSkuId()));
            }
            if (qrySkuRepVO.getExtSkuId() != null && qrySkuRepVO.getExtSkuId() != "") {
                qsReqBO.setExtSkuId(qrySkuRepVO.getExtSkuId());
            }
            if (qrySkuRepVO.getCatalogId() != null && qrySkuRepVO.getCatalogId() != "") {
                qsReqBO.setCatalogId(Long.valueOf(qrySkuRepVO.getCatalogId()));
            }
            if (qrySkuRepVO.getMaxMarketPrice() != null) {
                qsReqBO.setMaxMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)qrySkuRepVO.getMaxMarketPrice()));
            }
            if (qrySkuRepVO.getMinMarketPrice() != null) {
                qsReqBO.setMinMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)qrySkuRepVO.getMinMarketPrice()));
            }
            if (qrySkuRepVO.getMaxAgrPrice() != null) {
                qsReqBO.setMaxAgrPrice(MoneyUtils.BigDecimal2Long((BigDecimal)qrySkuRepVO.getMaxAgrPrice()));
            }
            if (qrySkuRepVO.getMinAgrPrice() != null) {
                qsReqBO.setMinAgrPrice(MoneyUtils.BigDecimal2Long((BigDecimal)qrySkuRepVO.getMinAgrPrice()));
            }
            queryOnOffShelveElecSku = this.queryOnOffShelveElecSkuService.queryOnOffShelveElecSku(qsReqBO);
            List rows = queryOnOffShelveElecSku.getRows();
            for (QueryOnOffShelveElecSkuRspBO skuRspBO : rows) {
                QueryOnOffShelveElecSkuRspVO skuRspVO = new QueryOnOffShelveElecSkuRspVO();
                BeanUtils.copyProperties((Object)skuRspBO, (Object)((Object)skuRspVO));
                skuRspVO.setSkuId(String.valueOf(skuRspBO.getSkuId()));
                skuRspVO.setExtSkuId(String.valueOf(skuRspBO.getExtSkuId()));
                skuRspVO.setCatalogId(String.valueOf(skuRspBO.getCatalogId()));
                listVO.add(skuRspVO);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5df2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u670d\u52a1\u51fa\u9519", (Throwable)e);
        }
        BaseRspPageVO<QueryOnOffShelveElecSkuRspVO> baseRspPageVO = new BaseRspPageVO<QueryOnOffShelveElecSkuRspVO>();
        baseRspPageVO.setPageNo(queryOnOffShelveElecSku.getPageNo());
        baseRspPageVO.setRecordsTotal(queryOnOffShelveElecSku.getRecordsTotal());
        baseRspPageVO.setRows(listVO);
        baseRspPageVO.setTotal(queryOnOffShelveElecSku.getTotal());
        baseRspPageVO.setRespCode(queryOnOffShelveElecSku.getRespCode());
        baseRspPageVO.setRespDesc(queryOnOffShelveElecSku.getRespDesc());
        return baseRspPageVO;
    }

    @RequestMapping(value={"/queryElecSkuDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseRspVO queryElecSkuDetail(@RequestBody QueryElecSkuDetailReqBO queryElecSkuDetailReqBO) {
        BaseRspVO<QueryElecSkuDetailRspBO> baseRspVO = new BaseRspVO<QueryElecSkuDetailRspBO>();
        String errorText = "";
        if (null == queryElecSkuDetailReqBO.getSkuId()) {
            errorText = errorText + " \u5355\u54c1Id[skuId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == queryElecSkuDetailReqBO.getSupplierId()) {
            errorText = errorText + " \u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!"".equals(errorText)) {
            baseRspVO.setRespCode("7777");
            baseRspVO.setRespDesc(errorText);
            return baseRspVO;
        }
        try {
            QueryElecSkuDetailRspBO data = this.queryElecSkuDetailService.queryElecSkuDetail(queryElecSkuDetailReqBO);
            baseRspVO.setData(data);
            baseRspVO.setRespCode(data.getRespCode());
            baseRspVO.setRespDesc(data.getRespDesc());
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5ba1\u6838\u8be6\u60c5\u670d\u52a1controller\u5931\u8d25" + e);
            throw new BusinessException(null, "\u5546\u54c1\u5ba1\u6838\u8be6\u60c5\u670d\u52a1controller\u5931\u8d25");
        }
        return baseRspVO;
    }

    @RequestMapping(value={"queryWaitApproveSkuList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public BaseRspPageVO<QueryWaitApproveSkuListRspVO> queryWaitApproveSkuList(@RequestBody QueryWaitApproveSkuListReqVO reqVO) {
        QueryWaitApproveSkuListReqBO reqBO = new QueryWaitApproveSkuListReqBO();
        ArrayList<QueryWaitApproveSkuListRspVO> rspVO = new ArrayList<QueryWaitApproveSkuListRspVO>();
        RspPageBO list = null;
        try {
            BeanUtils.copyProperties((Object)((Object)reqVO), (Object)reqBO);
            SecurityContext ctx = SecurityContextHolder.getContext();
            Authentication auth = ctx.getAuthentication();
            Object user = auth.getPrincipal();
            UserInfo userInfo = new UserInfo();
            BeanUtils.copyProperties((Object)user, (Object)userInfo);
            if (userInfo.getUid() != null) {
                reqBO.setAcceptId(userInfo.getUid().toString());
            }
            if (StringUtils.isNotEmpty((String)reqVO.getCatalogId())) {
                reqBO.setCatalogId(Long.valueOf(reqVO.getCatalogId()));
            }
            if (StringUtils.isNotEmpty((String)reqVO.getSupplierId())) {
                reqBO.setSupplierId(Integer.valueOf(reqVO.getSupplierId()));
            }
            if (StringUtils.isNotEmpty((String)reqVO.getSkuId())) {
                reqBO.setSkuId(Long.valueOf(reqVO.getSkuId()));
            }
            if (StringUtils.isNotEmpty((String)reqVO.getCommodityTypeId())) {
                reqBO.setCommodityTypeId(Long.valueOf(reqVO.getCommodityTypeId()));
            }
            if (reqVO.getMaxMarketPrice() != null) {
                reqBO.setMaxMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)reqVO.getMaxMarketPrice()));
            }
            if (reqVO.getMinMarketPrice() != null) {
                reqBO.setMinMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)reqVO.getMinMarketPrice()));
            }
            if (reqVO.getMaxAgrPrice() != null) {
                reqBO.setMaxAgrPrice(MoneyUtils.BigDecimal2Long((BigDecimal)reqVO.getMaxAgrPrice()));
            }
            if (reqVO.getMinAgrPrice() != null) {
                reqBO.setMinAgrPrice(MoneyUtils.BigDecimal2Long((BigDecimal)reqVO.getMinAgrPrice()));
            }
            list = this.querySkuApproveListService.queryWaitApproveSkuList(reqBO);
            List rows = list.getRows();
            for (QueryWaitApproveSkuListRspBO value : rows) {
                QueryWaitApproveSkuListRspVO rsp = new QueryWaitApproveSkuListRspVO();
                BeanUtils.copyProperties((Object)value, (Object)((Object)rsp));
                if (value.getDiscountRate() != null) {
                    rsp.setDiscountRate(new BigDecimal(value.getDiscountRate()));
                }
                rsp.setCatalogId(String.valueOf(value.getCatalogId()));
                rsp.setElecSkuOnShelveApprTaskId(String.valueOf(value.getElecSkuOnShelveApprTaskId()));
                rsp.setSkuId(String.valueOf(value.getSkuId()));
                rspVO.add(rsp);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u5ba1\u6838\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
        BaseRspPageVO<QueryWaitApproveSkuListRspVO> baseRspVO = new BaseRspPageVO<QueryWaitApproveSkuListRspVO>();
        baseRspVO.setRespCode(list.getRespCode());
        baseRspVO.setRespDesc(list.getRespDesc());
        baseRspVO.setPageNo(list.getPageNo());
        baseRspVO.setRecordsTotal(list.getRecordsTotal());
        baseRspVO.setRows(rspVO);
        baseRspVO.setTotal(list.getTotal());
        return baseRspVO;
    }

    @RequestMapping(value={"elecSkuOffOrOnShelve"}, method={RequestMethod.POST})
    @ResponseBody
    public ElecSkuOffOrOnShelveRspVO elecSkuOffOrOnShelve(@RequestBody ElecSkuOffOrOnShelveReqVO elecSkuOffOrOnShelveReqVO) {
        ElecSkuOffOrOnShelveReqBO elecSkuOffOrOnShelveReqBO = new ElecSkuOffOrOnShelveReqBO();
        elecSkuOffOrOnShelveReqBO.setOperateContent(elecSkuOffOrOnShelveReqVO.getOperateContent());
        elecSkuOffOrOnShelveReqBO.setAttachment(elecSkuOffOrOnShelveReqVO.getAttachment());
        elecSkuOffOrOnShelveReqBO.setOperateType(elecSkuOffOrOnShelveReqVO.getOperateType());
        elecSkuOffOrOnShelveReqBO.setSkuIds(elecSkuOffOrOnShelveReqVO.getSkuIds());
        elecSkuOffOrOnShelveReqBO.setSupplierId(elecSkuOffOrOnShelveReqVO.getSupplierId());
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication auth = ctx.getAuthentication();
        Object user = auth.getPrincipal();
        UserInfo userInfo = new UserInfo();
        BeanUtils.copyProperties((Object)user, (Object)userInfo);
        elecSkuOffOrOnShelveReqBO.setUserId(userInfo.getUid());
        elecSkuOffOrOnShelveReqBO.setUserName(userInfo.getName());
        ElecSkuOffOrOnShelveRspVO elecSkuOffOrOnShelveRspVO = new ElecSkuOffOrOnShelveRspVO();
        ElecSkuOffOrOnShelveRspBO result = null;
        try {
            result = this.elecSkuOffOrOnShelveService.skuOffOrOnShelve(elecSkuOffOrOnShelveReqBO);
            elecSkuOffOrOnShelveRspVO.setRespCode(result.getRespCode());
            elecSkuOffOrOnShelveRspVO.setRespDesc(result.getRespDesc());
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e0b\u67b6\u6062\u590d\u4e0a\u67b6\u548c\u91cd\u5ba1\u670d\u52a1\u51fa\u9519", (Throwable)e);
            elecSkuOffOrOnShelveRspVO.setRespCode("8888");
            elecSkuOffOrOnShelveRspVO.setRespDesc(e.getMessage());
        }
        return elecSkuOffOrOnShelveRspVO;
    }

    @RequestMapping(value={"queryBrand"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseRspPageVO<QueryBrandRspBO> queryBrand(@RequestBody QueryBrandReqVO queryBrandReqVO) {
        QueryBrandReqBO queryBrandReqBO = new QueryBrandReqBO();
        BaseRspPageVO<QueryBrandRspBO> rspPageVO = new BaseRspPageVO<QueryBrandRspBO>();
        RspPageBO rspPageBO = new RspPageBO();
        try {
            BeanUtils.copyProperties((Object)queryBrandReqVO, (Object)queryBrandReqBO);
            rspPageBO = this.queryBrandService.queryBrand(queryBrandReqBO);
            BeanUtils.copyProperties((Object)rspPageBO, rspPageVO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u54c1\u724ccontroller\u51fa\u9519", (Throwable)e);
        }
        return rspPageVO;
    }
}

