/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.common.user;

import com.ohaotian.commodity.common.user.AuthorityInfo;
import com.ohaotian.commodity.common.user.MenuInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class UserInfo
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private Long uid;
    private String username;
    private String password;
    private String name;
    private Long orgLeafId;
    private String orgFullName;
    private Long deptId;
    private String deptName;
    private String deptSrcCode;
    private Long compId;
    private String compName;
    private String compSrcCode;
    private boolean enabled = true;
    private Set<AuthorityInfo> authorities = new HashSet<AuthorityInfo>(10);
    private List<MenuInfo> menus = new ArrayList<MenuInfo>(10);
    private static final ThreadLocal<AuthorityInfo> AUTHORITY_CONTEXT = new ThreadLocal<AuthorityInfo>(){

        @Override
        protected AuthorityInfo initialValue() {
            return new AuthorityInfo();
        }
    };

    public boolean hasAuthority(String authority) {
        if (authority == null) {
            return false;
        }
        AuthorityInfo authorityInfo = AUTHORITY_CONTEXT.get();
        authorityInfo.setKey(authority);
        return this.authorities.contains(authorityInfo);
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.enabled;
    }

    public boolean isAccountNonLocked() {
        return this.enabled;
    }

    public boolean isCredentialsNonExpired() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAuthorities(Set<AuthorityInfo> authorities) {
        this.authorities = authorities;
    }

    public Long getOrgLeafId() {
        return this.orgLeafId;
    }

    public void setOrgLeafId(Long orgLeafId) {
        this.orgLeafId = orgLeafId;
    }

    public String getOrgFullName() {
        return this.orgFullName;
    }

    public void setOrgFullName(String orgFullName) {
        this.orgFullName = orgFullName;
    }

    public Long getDeptId() {
        return this.deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getCompId() {
        return this.compId;
    }

    public void setCompId(Long compId) {
        this.compId = compId;
    }

    public String getCompName() {
        return this.compName;
    }

    public void setCompName(String compName) {
        this.compName = compName;
    }

    public List<MenuInfo> getMenus() {
        return this.menus;
    }

    public void setMenus(List<MenuInfo> menus) {
        this.menus = menus;
    }

    public String toString() {
        return "UserInfo [uid=" + this.uid + ", username=" + this.username + ", password=" + this.password + ", name=" + this.name + ", orgLeafId=" + this.orgLeafId + ", orgFullName=" + this.orgFullName + ", deptId=" + this.deptId + ", deptName=" + this.deptName + ", deptSrcCode=" + this.deptSrcCode + ", compId=" + this.compId + ", compName=" + this.compName + ", compSrcCode=" + this.compSrcCode + ", enabled=" + this.enabled + ", authorities=" + this.authorities + ", menus=" + this.menus + "]";
    }

    public String getDeptSrcCode() {
        return this.deptSrcCode;
    }

    public void setDeptSrcCode(String deptSrcCode) {
        this.deptSrcCode = deptSrcCode;
    }

    public String getCompSrcCode() {
        return this.compSrcCode;
    }

    public void setCompSrcCode(String compSrcCode) {
        this.compSrcCode = compSrcCode;
    }
}

