/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.GoodsReturnXbjAtomService;
import com.cgd.order.atom.InfoAddressXbjAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.atom.bo.GoodsReturnAtomXbjReqBO;
import com.cgd.order.atom.bo.GoodsReturnAtomXbjRspBO;
import com.cgd.order.busi.XbjQueryGoodsReturnBusiService;
import com.cgd.order.busi.bo.AccessoryBO;
import com.cgd.order.busi.bo.XbjQueryGoodsReturnReqBO;
import com.cgd.order.busi.bo.XbjQueryGoodsReturnRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.po.InfoAddressXbjPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjQueryGoodsReturnBusiServiceImpl
implements XbjQueryGoodsReturnBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQueryGoodsReturnBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private GoodsReturnXbjAtomService goodsReturnXbjAtomService;
    private InfoAddressXbjAtomService infoAddressXbjAtomService;
    private DicDictionaryService dicDictionaryService;
    private AccessoryXbjAtomService accessoryXbjAtomService;

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public void setAccessoryXbjAtomService(AccessoryXbjAtomService accessoryXbjAtomService) {
        this.accessoryXbjAtomService = accessoryXbjAtomService;
    }

    public void setGoodsReturnXbjAtomService(GoodsReturnXbjAtomService goodsReturnXbjAtomService) {
        this.goodsReturnXbjAtomService = goodsReturnXbjAtomService;
    }

    public void setInfoAddressXbjAtomService(InfoAddressXbjAtomService infoAddressXbjAtomService) {
        this.infoAddressXbjAtomService = infoAddressXbjAtomService;
    }

    public XbjQueryGoodsReturnRspBO queryGoodsReturn(XbjQueryGoodsReturnReqBO xbjQueryGoodsReturnReqBO) {
        this.validateParams(xbjQueryGoodsReturnReqBO);
        if (isDebugEnabled) {
            log.debug("\u9000\u8d27\u5355\u67e5\u8be2\u5165\u53c2:" + xbjQueryGoodsReturnReqBO.toString());
        }
        XbjQueryGoodsReturnRspBO xbjQueryGoodsReturnRspBO = new XbjQueryGoodsReturnRspBO();
        GoodsReturnAtomXbjReqBO goodsReturnAtomXbjReqBO = new GoodsReturnAtomXbjReqBO();
        goodsReturnAtomXbjReqBO.setPurchaserId(xbjQueryGoodsReturnReqBO.getPurchaserId());
        goodsReturnAtomXbjReqBO.setGoodsReturnId(xbjQueryGoodsReturnReqBO.getServiceOrderId());
        GoodsReturnAtomXbjRspBO goodsReturnAtomXbjRspBO = this.goodsReturnXbjAtomService.queryFromReturn(goodsReturnAtomXbjReqBO);
        if (null != goodsReturnAtomXbjRspBO && "0000".equals(goodsReturnAtomXbjRspBO.getRespCode())) {
            List<AccessoryAtomXbjRspBO> accessoryList;
            InfoAddressXbjPO takeAddressResult;
            BeanUtils.copyProperties((Object)goodsReturnAtomXbjRspBO, (Object)xbjQueryGoodsReturnRspBO);
            xbjQueryGoodsReturnRspBO.setSaleOrderId(String.valueOf(goodsReturnAtomXbjRspBO.getSaleOrderId()));
            InfoAddressXbjPO pickupAddressResult = this.infoAddressXbjAtomService.queryInfoAddress(goodsReturnAtomXbjRspBO.getPickupAddressId(), goodsReturnAtomXbjRspBO.getPurchaserId());
            if (null != pickupAddressResult) {
                xbjQueryGoodsReturnRspBO.setPickupAddress(pickupAddressResult.getReceiverAddress());
            }
            if (null != (takeAddressResult = this.infoAddressXbjAtomService.queryInfoAddress(goodsReturnAtomXbjRspBO.getTakeAddressId(), goodsReturnAtomXbjRspBO.getPurchaserId()))) {
                xbjQueryGoodsReturnRspBO.setTakeAddress(takeAddressResult.getReceiverAddress());
            }
            if (null != goodsReturnAtomXbjRspBO.getReturnMode()) {
                Map returnWayMap = this.dicDictionaryService.getValueByCode("RETURN_MODE");
                if (null != returnWayMap) {
                    xbjQueryGoodsReturnRspBO.setReturnWay((String)returnWayMap.get(String.valueOf(goodsReturnAtomXbjRspBO.getReturnMode())));
                } else {
                    if (isDebugEnabled) {
                        log.debug("\u7f3a\u5c11\u5bf9\u5e94\u5b57\u5178\u8868\u6620\u5c04\u53d6\u4ef6\u65b9\u5f0f\uff01");
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7f3a\u5c11\u5bf9\u5e94\u5b57\u5178\u8868\u6620\u5c04\u53d6\u4ef6\u65b9\u5f0f\uff01");
                }
            }
            if (null != (accessoryList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(xbjQueryGoodsReturnReqBO.getServiceOrderId(), OrderCenterConstant.OBJRCT_TYPE.RETURN_GOODS)) && accessoryList.size() > 0) {
                ArrayList<AccessoryBO> accessoryInfoList = new ArrayList<AccessoryBO>();
                for (AccessoryAtomXbjRspBO accessoryAtomXbjRspBO : accessoryList) {
                    AccessoryBO accessoryBO = new AccessoryBO();
                    BeanUtils.copyProperties((Object)accessoryAtomXbjRspBO, (Object)accessoryBO);
                    accessoryInfoList.add(accessoryBO);
                }
                xbjQueryGoodsReturnRspBO.setAccessoryList(accessoryInfoList);
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9000\u8d27\u5355\u8fd4\u56de\u5f02\u5e38\uff1a" + goodsReturnAtomXbjRspBO.getRespDesc());
        }
        xbjQueryGoodsReturnRspBO.setRespCode("0000");
        xbjQueryGoodsReturnRspBO.setRespDesc("\u8be2\u6bd4\u4ef7\u9000\u8d27\u5355\u6982\u8981\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        return xbjQueryGoodsReturnRspBO;
    }

    private void validateParams(XbjQueryGoodsReturnReqBO xbjQueryGoodsReturnReqBO) {
        if (null == xbjQueryGoodsReturnReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjQueryGoodsReturnReqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == xbjQueryGoodsReturnReqBO.getServiceOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

