/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.DateUtil;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.busi.XbjQryOrderListForContractBusiService;
import com.cgd.order.busi.bo.XbjQryOrderDetailForContractRspBO;
import com.cgd.order.busi.bo.XbjQryOrderForContractReqBO;
import com.cgd.order.busi.bo.XbjQryOrderListForContractRspBO;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjQryOrderListForContractBusiService")
public class XbjQryOrderListForContractBusiServiceImpl
implements XbjQryOrderListForContractBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderListForContractBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;

    public XbjQryOrderListForContractRspBO selectOrderList(XbjQryOrderForContractReqBO reqBO) {
        XbjQryOrderListForContractRspBO rspBO = new XbjQryOrderListForContractRspBO();
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2:" + reqBO.toString());
        }
        this.validateParams(reqBO);
        String orderBy = "CREATE_TIME DESC";
        ArrayList<XbjQryOrderDetailForContractRspBO> retList = new ArrayList<XbjQryOrderDetailForContractRspBO>();
        if (reqBO.getOrderType().equals(XbjOrderConstants.ORDER_TYPE.SALE)) {
            try {
                OrderSaleXbjPO condition = new OrderSaleXbjPO();
                condition.setSaleOrderName(reqBO.getOrderName());
                condition.setProfessionalOrganizationId(reqBO.getDeliveryCenterId());
                condition.setPurchaserName(reqBO.getPurchaseAccountName());
                condition.setPurchaserAccount(reqBO.getPurchaseAccountId());
                condition.setSaleOrderCode(reqBO.getSaleOrderCode());
                if (reqBO.getOrderSource() == null) {
                    ArrayList<Integer> saleOrderTypes = new ArrayList<Integer>();
                    saleOrderTypes.add(XConstant.SALE_ORDER_TYPE_PROTOCOL);
                    saleOrderTypes.add(XConstant.SALE_ORDER_TYPE_XBJ);
                    condition.setSaleOrderTypes(saleOrderTypes);
                } else {
                    condition.setSaleOrderType(reqBO.getOrderSource());
                }
                if (reqBO.getOrderCreateStart() != null) {
                    condition.setCreateTimeBegin(com.cgd.order.util.DateUtil.strToDate(reqBO.getOrderCreateStart()));
                }
                if (reqBO.getOrderCreateEnd() != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(com.cgd.order.util.DateUtil.strToDate(reqBO.getOrderCreateEnd()));
                    c.add(5, 1);
                    condition.setCreateTimeEnd(c.getTime());
                }
                condition.setPurchaserAccountName(reqBO.getOrderCreateUserName());
                condition.setContractMark(XConstant.CONTRACT_MARK.NEED);
                condition.setIsDispatch(XConstant.IS_DISPATCH_YES);
                Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u6761\u4ef6:" + JSON.toJSONString((Object)condition));
                List<OrderSaleXbjPO> saleList = this.orderSaleXbjMapper.getListPage(condition, (Page<OrderSaleXbjPO>)page, orderBy);
                for (OrderSaleXbjPO po : saleList) {
                    XbjQryOrderDetailForContractRspBO bo = new XbjQryOrderDetailForContractRspBO();
                    bo.setSaleOrderId(po.getSaleOrderId());
                    bo.setSaleOrderCode(po.getSaleOrderCode());
                    bo.setOrderName(po.getSaleOrderName());
                    bo.setOrderAmount(MoneyUtil.Long2BigDecimal((Long)po.getSaleOrderMoney()));
                    bo.setOrderSouce(po.getSaleOrderType());
                    Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
                    if (orderSourceMap != null) {
                        bo.setOrderSourceName((String)orderSourceMap.get(po.getSaleOrderType() + ""));
                    }
                    bo.setPrePay(po.getPrePayEnt());
                    bo.setMatPay(po.getMatPayEnt());
                    bo.setProPay(po.getProPayEnt());
                    bo.setVerPay(po.getVerPayEnt());
                    bo.setPilPay(po.getPilPayEnt());
                    bo.setQuaPay(po.getQuaPayEnt());
                    bo.setPayType(po.getPayType());
                    Map payTypeMap = this.dicDictionaryService.getValueByCode("PAY_TYPE");
                    if (payTypeMap != null) {
                        bo.setPayTypeName((String)payTypeMap.get(po.getPayType() + ""));
                    }
                    bo.setPurchaseAccount(po.getPurchaserAccount());
                    bo.setPurchaseAccountName(po.getPurchaserName());
                    bo.setOrderCreateUserId(po.getPurchaserAccountId());
                    bo.setOrderCreateUserName(po.getPurchaserAccountName());
                    bo.setOrderCreateTime(DateUtil.dateToStrLong((Date)po.getCreateTime()));
                    retList.add(bo);
                }
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setRecordsTotal(page.getTotalCount());
                rspBO.setTotal(page.getTotalPages());
            }
            catch (Exception e) {
                log.error("\u5408\u540c\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5408\u540c\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38");
            }
            rspBO.setRows(retList);
        } else if (reqBO.getOrderType().equals(XbjOrderConstants.ORDER_TYPE.PURCHASE)) {
            try {
                OrderPurchaseXbjPO condition = new OrderPurchaseXbjPO();
                condition.setPurchaseOrderName(reqBO.getOrderName());
                condition.setProfessionalOrganizationId(reqBO.getDeliveryCenterId());
                condition.setPurchaserName(reqBO.getPurchaseAccountName());
                condition.setPurchaserAccount(reqBO.getPurchaseAccountId());
                condition.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
                if (reqBO.getOrderSource() == null) {
                    ArrayList<Integer> saleOrderTypes = new ArrayList<Integer>();
                    saleOrderTypes.add(XConstant.SALE_ORDER_TYPE_PROTOCOL);
                    saleOrderTypes.add(XConstant.SALE_ORDER_TYPE_XBJ);
                    condition.setSaleOrderTypes(saleOrderTypes);
                } else {
                    condition.setSaleOrderType(reqBO.getOrderSource());
                }
                if (reqBO.getOrderCreateStart() != null) {
                    condition.setCreateTimeBegin(com.cgd.order.util.DateUtil.strToDate(reqBO.getOrderCreateStart()));
                }
                if (reqBO.getOrderCreateEnd() != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(com.cgd.order.util.DateUtil.strToDate(reqBO.getOrderCreateEnd()));
                    c.add(5, 1);
                    condition.setCreateTimeEnd(c.getTime());
                }
                condition.setContractMark(XConstant.CONTRACT_MARK.NEED);
                condition.setPurchaserAccountName(reqBO.getOrderCreateUserName());
                condition.setGoodsSupplierId(reqBO.getSupplierId());
                condition.setGoodsSupplierName(reqBO.getSupplierName());
                condition.setIsDispatch(XConstant.IS_DISPATCH_YES);
                Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u66f4\u65b0\u5408\u540c\u6807\u8bb0\u4e1a\u52a1\u670d\u52a1\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u6761\u4ef6:" + JSON.toJSONString((Object)condition));
                List<OrderPurchaseXbjPO> purchaseList = this.orderPurchaseXbjMapper.getListPage(condition, (Page<OrderPurchaseXbjPO>)page, orderBy);
                for (OrderPurchaseXbjPO po : purchaseList) {
                    XbjQryOrderDetailForContractRspBO bo = new XbjQryOrderDetailForContractRspBO();
                    bo.setPurchaseOrderId(po.getPurchaseOrderId());
                    bo.setPurchaseOrderCode(po.getPurchaseOrderCode());
                    bo.setOrderName(po.getPurchaseOrderName());
                    bo.setOrderAmount(MoneyUtil.Long2BigDecimal((Long)po.getPurchaseOrderMoney()));
                    bo.setOrderSouce(po.getSaleOrderType());
                    Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
                    if (orderSourceMap != null) {
                        bo.setOrderSourceName((String)orderSourceMap.get(po.getSaleOrderType() + ""));
                    }
                    bo.setPrePay(po.getPrePaySup());
                    bo.setMatPay(po.getMatPaySup());
                    bo.setProPay(po.getProPaySup());
                    bo.setVerPay(po.getVerPaySup());
                    bo.setPilPay(po.getPilPaySup());
                    bo.setQuaPay(po.getQuaPaySup());
                    bo.setPayType(po.getPayType());
                    Map payTypeMap = this.dicDictionaryService.getValueByCode("PAY_TYPE");
                    if (payTypeMap != null) {
                        bo.setPayTypeName((String)payTypeMap.get(po.getPayType() + ""));
                    }
                    bo.setSupplierName(po.getGoodsSupplierName());
                    bo.setPurchaseAccount(po.getPurchaserAccount());
                    bo.setPurchaseAccountName(po.getPurchaserName());
                    bo.setOrderCreateUserId(po.getPurchaserAccountId());
                    bo.setOrderCreateUserName(po.getPurchaserAccountName());
                    bo.setOrderCreateTime(DateUtil.dateToStrLong((Date)po.getCreateTime()));
                    retList.add(bo);
                }
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setRecordsTotal(page.getTotalCount());
                rspBO.setTotal(page.getTotalPages());
            }
            catch (Exception e) {
                log.error("\u5408\u540c\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5408\u540c\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38");
            }
            rspBO.setRows(retList);
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7c7b\u578b[orderType]\u9519\u8bef");
        }
        return rspBO;
    }

    private void validateParams(XbjQryOrderForContractReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9700\u751f\u6210\u5408\u540c\u7684\u8ba2\u5355\u5217\u8868\u4e3a\u7a7a");
        }
        if (reqBO.getOrderType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

