/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.CheckMsgSendCountXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.QrySmsTemplateXbjAtomService;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.atom.bo.QrySmsTemplateAtomXbjReqBO;
import com.cgd.order.busi.XbjCheckSaleOrderConfirmService;
import com.cgd.order.busi.XbjCheckWhetherShipAllService;
import com.cgd.order.busi.bo.XbjCheckSaleOrderConfirmReqBO;
import com.cgd.order.busi.bo.XbjCheckSaleOrderConfirmRspBO;
import com.cgd.order.busi.bo.XbjCheckWhetherShipAllReqBO;
import com.cgd.order.busi.bo.XbjCheckWhetherShipAllRspBO;
import com.cgd.order.busi.bo.XbjOrderAdjustBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.intfce.XbjPurchaserUrgeDeliveryMsgIntfceService;
import com.cgd.order.intfce.XbjQryReceiveRecipientInfoIntfceService;
import com.cgd.order.intfce.XbjTemplateMatchIntfceService;
import com.cgd.order.intfce.bo.XbjContactInfoBO;
import com.cgd.order.intfce.bo.XbjPurchaserUrgeDeliveryMsgIntfceReqBO;
import com.cgd.order.intfce.bo.XbjPurchaserUrgeDeliveryMsgIntfceRspBO;
import com.cgd.order.intfce.bo.XbjQryReceiveRecipientReqBO;
import com.cgd.order.intfce.bo.XbjQryReceiveRecipientRspBO;
import com.cgd.order.intfce.bo.XbjTemplateMatchReqBO;
import com.cgd.order.intfce.bo.XbjTemplateMatchRspBO;
import com.cgd.order.po.RemindConfigureXbjPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjPurchaserUrgeDeliveryMsgIntfceServiceImpl
implements XbjPurchaserUrgeDeliveryMsgIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjPurchaserUrgeDeliveryMsgIntfceServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private XbjCheckWhetherShipAllService checkWhetherShipAllService;
    @Autowired
    private QrySmsTemplateXbjAtomService qrySmsTemplateXbjAtomService;
    @Autowired
    private CheckMsgSendCountXbjAtomService checkMsgSendCountXbjAtomService;
    @Autowired
    private XbjQryReceiveRecipientInfoIntfceService xbjQryReceiveRecipientInfoIntfceService;
    @Autowired
    private XbjTemplateMatchIntfceService templateMatchIntfceService;
    @Autowired
    private XbjCheckSaleOrderConfirmService xbjCheckSaleOrderConfirmService;

    private void validateBOData(XbjPurchaserUrgeDeliveryMsgIntfceReqBO xbjPurchaserUrgeDeliveryMsgIntfceReqBO) {
        if (xbjPurchaserUrgeDeliveryMsgIntfceReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getOrderUrgeList() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u9500\u552e\u5355ID\u96c6\u5408\u3010orderUrgeList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List urgeList = xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getOrderUrgeList();
        for (XbjOrderAdjustBO bo : urgeList) {
            if (bo.getSaleOrderId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u5165\u53c2\u9500\u552e\u5355ID\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getPurchaseId() != null) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u5165\u53c2\u91c7\u8d2d\u5355\u4f4dID\u3010purchaseId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkWhetherShipAll(XbjPurchaserUrgeDeliveryMsgIntfceReqBO xbjPurchaserUrgeDeliveryMsgIntfceReqBO) {
        XbjCheckWhetherShipAllReqBO checkWhetherShipAllReqBO = new XbjCheckWhetherShipAllReqBO();
        checkWhetherShipAllReqBO.setSaleOrderId(String.valueOf(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getSaleOrderId()));
        checkWhetherShipAllReqBO.setPurchaserId(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getPurchaserId());
        XbjCheckWhetherShipAllRspBO checkWhetherShipAllRspBO = this.checkWhetherShipAllService.checkWhetherShipAll(checkWhetherShipAllReqBO);
        if (checkWhetherShipAllRspBO != null && !"0000".equals(checkWhetherShipAllRspBO.getRespCode())) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u53d1\u8d27\u5355\u9a8c\u8bc1\u5f02\u5e38\uff1a" + checkWhetherShipAllRspBO.getRespDesc());
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", checkWhetherShipAllRspBO.getRespDesc());
        }
        if (checkWhetherShipAllRspBO == null || checkWhetherShipAllRspBO.getAllShip().booleanValue()) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u53d1\u8d27\u5355\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6210\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u4ea4\uff01");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u53d1\u8d27\u5355\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6210\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u4ea4\uff01");
        }
    }

    private String sendUrgeDeliveryMsg(XbjPurchaserUrgeDeliveryMsgIntfceReqBO xbjPurchaserUrgeDeliveryMsgIntfceReqBO, OrderSaleInfoXbjRspBO orderSaleInfo) {
        QrySmsTemplateAtomXbjReqBO qrySmsTemplateAtomXbjReqBO = new QrySmsTemplateAtomXbjReqBO();
        qrySmsTemplateAtomXbjReqBO.setOrderId(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getSaleOrderId());
        qrySmsTemplateAtomXbjReqBO.setOrderType(Constant.ORDER_TYPE_SALE);
        qrySmsTemplateAtomXbjReqBO.setBusiCode("B_23");
        qrySmsTemplateAtomXbjReqBO.setPurchaserId(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getPurchaserId());
        List<RemindConfigureXbjPO> remindConfigureList = this.qrySmsTemplateXbjAtomService.querySmsTemplate(qrySmsTemplateAtomXbjReqBO);
        if (remindConfigureList == null || remindConfigureList.size() == 0) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e");
        }
        int successCount = 0;
        int failurCount = 0;
        for (RemindConfigureXbjPO remindConfigure : remindConfigureList) {
            xbjPurchaserUrgeDeliveryMsgIntfceReqBO.setSaleOrderId(orderSaleInfo.getSaleOrderId());
            if ("Rx1".equals(remindConfigure.getRoleId())) {
                remindConfigure.setOrderType(Constant.ORDER_TYPE_SALE);
            } else if ("Rx2".equals(remindConfigure.getRoleId())) {
                remindConfigure.setOrderType(Constant.ORDER_TYPE_PURCHASE);
            }
            Boolean flg = this.checkMsgSendCountXbjAtomService.checkMsgSendCount(orderSaleInfo.getSaleOrderCode(), remindConfigure.getId(), new Date(), remindConfigure.getSendCount(), "day");
            if (!flg.booleanValue()) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u3010" + remindConfigure.getId() + "\u3011\u8d85\u51fa\u53d1\u9001\u6b21\u6570\uff0c\u4e0d\u80fd\u518d\u53d1\u9001\u4fe1\u606f");
                }
                ++failurCount;
                continue;
            }
            XbjQryReceiveRecipientRspBO qryContactInfo = this.qryContactInfo(remindConfigure.getRoleId(), xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getSaleOrderId(), Constant.ORDER_TYPE_SALE, xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getPurchaserId());
            if (qryContactInfo == null) continue;
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a" + qryContactInfo);
            }
            log.error("\u50ac\u4ea4\u8054\u7cfb\u4eba\u4fe1\u606f1\uff1a" + JSON.toJSONString((Object)qryContactInfo));
            List contactInfoList = qryContactInfo.getContactInfoList();
            log.error("\u50ac\u4ea4\u8054\u7cfb\u4eba\u4fe1\u606f2\uff1a" + JSON.toJSONString((Object)contactInfoList));
            if (null == contactInfoList || contactInfoList.isEmpty()) continue;
            for (XbjContactInfoBO contactInfo : contactInfoList) {
                XbjTemplateMatchRspBO templateMatchRspBO;
                if ("Rx2".equals(remindConfigure.getRoleId())) {
                    remindConfigure.setOrderType(Constant.ORDER_TYPE_PURCHASE);
                    xbjPurchaserUrgeDeliveryMsgIntfceReqBO.setSaleOrderId(orderSaleInfo.getPurchaseOrderId());
                }
                if ((templateMatchRspBO = this.dealTemplateMatch(xbjPurchaserUrgeDeliveryMsgIntfceReqBO, remindConfigure, contactInfo)) != null && "0000".equals(templateMatchRspBO.getRespCode())) {
                    ++successCount;
                    continue;
                }
                ++failurCount;
            }
        }
        String respDesc = "\u53d1\u9001\u6210\u529f\u3010" + successCount + "\u3011\u6761\u4fe1\u606f\uff0c\u53d1\u9001\u5931\u8d25\u3010" + failurCount + "\u3011\u6761\u4fe1\u606f";
        return respDesc;
    }

    private XbjQryReceiveRecipientRspBO qryContactInfo(String roleId, Long orderId, Integer orderType, Long purchaserId) {
        XbjQryReceiveRecipientReqBO qryReceiveRecipient = new XbjQryReceiveRecipientReqBO();
        qryReceiveRecipient.setRoleId(roleId);
        qryReceiveRecipient.setOrderId(orderId);
        qryReceiveRecipient.setOrderType(orderType);
        qryReceiveRecipient.setPurchaserId(purchaserId);
        return this.xbjQryReceiveRecipientInfoIntfceService.qryReceiveRecipient(qryReceiveRecipient);
    }

    private XbjTemplateMatchRspBO dealTemplateMatch(XbjPurchaserUrgeDeliveryMsgIntfceReqBO xbjPurchaserUrgeDeliveryMsgIntfceReqBO, RemindConfigureXbjPO remindConfigureXbjPO, XbjContactInfoBO contactInfo) {
        XbjTemplateMatchReqBO templateMatchReqBO = new XbjTemplateMatchReqBO();
        templateMatchReqBO.setOrderId(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getSaleOrderId());
        templateMatchReqBO.setOrderType(remindConfigureXbjPO.getOrderType());
        templateMatchReqBO.setTemplateId(Long.valueOf(Long.parseLong(remindConfigureXbjPO.getTemplateId())));
        templateMatchReqBO.setCongifId(remindConfigureXbjPO.getId());
        templateMatchReqBO.setPurchaserId(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getPurchaserId());
        templateMatchReqBO.setSendType(remindConfigureXbjPO.getSendType());
        templateMatchReqBO.setRoleId(remindConfigureXbjPO.getRoleId());
        templateMatchReqBO.setCellphone(contactInfo.getCellphone());
        templateMatchReqBO.setEmail(contactInfo.getEmail());
        templateMatchReqBO.setUserId(contactInfo.getUserId() + "");
        templateMatchReqBO.setSendId(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getUserId());
        log.error("\u6a21\u677f\u5339\u914d\u670d\u52a1\u5165\u53c21111111111111111\uff1a" + JSON.toJSONString((Object)templateMatchReqBO));
        return this.templateMatchIntfceService.templateMatch(templateMatchReqBO);
    }

    public XbjPurchaserUrgeDeliveryMsgIntfceRspBO dealUrgeDeliveryMsg(XbjPurchaserUrgeDeliveryMsgIntfceReqBO xbjPurchaserUrgeDeliveryMsgIntfceReqBO) {
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1\u5165\u53c2" + xbjPurchaserUrgeDeliveryMsgIntfceReqBO);
        }
        this.validateBOData(xbjPurchaserUrgeDeliveryMsgIntfceReqBO);
        XbjPurchaserUrgeDeliveryMsgIntfceRspBO xbjPurchaserUrgeDeliveryMsgIntfceRsp = new XbjPurchaserUrgeDeliveryMsgIntfceRspBO();
        List urgeList = xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getOrderUrgeList();
        if (urgeList != null && urgeList.size() > 0) {
            for (XbjOrderAdjustBO reqBO : urgeList) {
                xbjPurchaserUrgeDeliveryMsgIntfceReqBO.setSaleOrderId(Long.valueOf(Long.parseLong(reqBO.getSaleOrderId())));
                xbjPurchaserUrgeDeliveryMsgIntfceReqBO.setPurchaserId(Long.valueOf(Long.parseLong(reqBO.getPurchaseId())));
                try {
                    String respDesc;
                    OrderSaleInfoXbjRspBO orderSaleInfoXbjRspBO = this.orderSaleXbjAtomService.selectOrderSaleById(xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getSaleOrderId(), xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getPurchaserId());
                    if (orderSaleInfoXbjRspBO == null) {
                        if (this.isDebugEnabled.booleanValue()) {
                            log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
                        }
                        throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    if (xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getDealFlag() == 1) {
                        this.checkWhetherShipAll(xbjPurchaserUrgeDeliveryMsgIntfceReqBO);
                        respDesc = this.sendUrgeDeliveryMsg(xbjPurchaserUrgeDeliveryMsgIntfceReqBO, orderSaleInfoXbjRspBO);
                        xbjPurchaserUrgeDeliveryMsgIntfceRsp.setRespCode("0000");
                        xbjPurchaserUrgeDeliveryMsgIntfceRsp.setRespDesc(respDesc);
                        continue;
                    }
                    if (xbjPurchaserUrgeDeliveryMsgIntfceReqBO.getDealFlag() != 2) continue;
                    this.checkSaleOrderConfirm(xbjPurchaserUrgeDeliveryMsgIntfceReqBO);
                    respDesc = this.sendRemindMsg(xbjPurchaserUrgeDeliveryMsgIntfceReqBO, orderSaleInfoXbjRspBO);
                    xbjPurchaserUrgeDeliveryMsgIntfceRsp.setRespCode("0000");
                    xbjPurchaserUrgeDeliveryMsgIntfceRsp.setRespDesc(respDesc);
                }
                catch (BusinessException e) {
                    if (this.isDebugEnabled.booleanValue()) {
                        log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1\u4e1a\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
                }
                catch (Exception e) {
                    if (this.isDebugEnabled.booleanValue()) {
                        log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff01");
                }
            }
        } else {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1\u4e1a\u52a1\u5f02\u5e38\uff1a\u5165\u53c2\u8ba2\u5355\u5217\u8868\u96c6\u5408\u4e3a\u7a7a");
        }
        return xbjPurchaserUrgeDeliveryMsgIntfceRsp;
    }

    private void checkSaleOrderConfirm(XbjPurchaserUrgeDeliveryMsgIntfceReqBO purchaserUrgeDeliveryMsgIntfceReqBO) {
        XbjCheckSaleOrderConfirmReqBO checkSaleOrderConfirmReqBO = new XbjCheckSaleOrderConfirmReqBO();
        checkSaleOrderConfirmReqBO.setSaleOrderId(String.valueOf(purchaserUrgeDeliveryMsgIntfceReqBO.getSaleOrderId()));
        checkSaleOrderConfirmReqBO.setPurchaserId(purchaserUrgeDeliveryMsgIntfceReqBO.getPurchaserId());
        XbjCheckSaleOrderConfirmRspBO checkSaleOrderConfirmRspBO = this.xbjCheckSaleOrderConfirmService.checkSaleOrderConfirm(checkSaleOrderConfirmReqBO);
        if (checkSaleOrderConfirmRspBO != null && !"0000".equals(checkSaleOrderConfirmRspBO.getRespCode())) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u9879\u76ee\u5355\u4f4d\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u9a8c\u8bc1\u5f02\u5e38\uff1a" + checkSaleOrderConfirmRspBO.getRespDesc());
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", checkSaleOrderConfirmRspBO.getRespDesc());
        }
        if (checkSaleOrderConfirmRspBO == null || !checkSaleOrderConfirmRspBO.getConfirmFlag().booleanValue()) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u9879\u76ee\u5355\u4f4d\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u8fdb\u884c\u63d0\u9192\u64cd\u4f5c\uff01");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u8fdb\u884c\u63d0\u9192\u64cd\u4f5c\uff01");
        }
    }

    private String sendRemindMsg(XbjPurchaserUrgeDeliveryMsgIntfceReqBO purchaserRemindMsgIntfceReqBO, OrderSaleInfoXbjRspBO orderSaleInfo) {
        QrySmsTemplateAtomXbjReqBO qrySmsTemplateAtomReqBO = new QrySmsTemplateAtomXbjReqBO();
        qrySmsTemplateAtomReqBO.setOrderId(purchaserRemindMsgIntfceReqBO.getSaleOrderId());
        qrySmsTemplateAtomReqBO.setOrderType(Constant.ORDER_TYPE_SALE);
        qrySmsTemplateAtomReqBO.setBusiCode("B_20");
        qrySmsTemplateAtomReqBO.setPurchaserId(purchaserRemindMsgIntfceReqBO.getPurchaserId());
        List<RemindConfigureXbjPO> remindConfigureList = this.qrySmsTemplateXbjAtomService.querySmsTemplate(qrySmsTemplateAtomReqBO);
        if (remindConfigureList == null || remindConfigureList.size() == 0) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u9879\u76ee\u5355\u4f4d\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e");
        }
        int successCount = 0;
        int failurCount = 0;
        for (RemindConfigureXbjPO remindConfigure : remindConfigureList) {
            List contactInfoList;
            purchaserRemindMsgIntfceReqBO.setSaleOrderId(orderSaleInfo.getSaleOrderId());
            if ("Rx1".equals(remindConfigure.getRoleId())) {
                remindConfigure.setOrderType(Constant.ORDER_TYPE_SALE);
            } else if ("Rx2".equals(remindConfigure.getRoleId())) {
                remindConfigure.setOrderType(Constant.ORDER_TYPE_PURCHASE);
            }
            Boolean flg = this.checkMsgSendCountXbjAtomService.checkMsgSendCount(orderSaleInfo.getSaleOrderCode(), remindConfigure.getId(), new Date(), remindConfigure.getSendCount(), "day");
            if (!flg.booleanValue()) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.debug("\u9879\u76ee\u5355\u4f4d\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u3010" + remindConfigure.getId() + "\u3011\u8d85\u51fa\u53d1\u9001\u6b21\u6570\uff0c\u4e0d\u80fd\u518d\u53d1\u9001\u4fe1\u606f");
                }
                ++failurCount;
                continue;
            }
            XbjQryReceiveRecipientRspBO qryContactInfo = this.qryContactInfo(remindConfigure.getRoleId(), purchaserRemindMsgIntfceReqBO.getSaleOrderId(), Constant.ORDER_TYPE_SALE, purchaserRemindMsgIntfceReqBO.getPurchaserId());
            if (qryContactInfo == null) continue;
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a" + qryContactInfo);
            }
            if (null == (contactInfoList = qryContactInfo.getContactInfoList()) || contactInfoList.isEmpty()) continue;
            for (XbjContactInfoBO contactInfo : contactInfoList) {
                XbjTemplateMatchRspBO templateMatchRspBO;
                if ("Rx2".equals(remindConfigure.getRoleId())) {
                    remindConfigure.setOrderType(Constant.ORDER_TYPE_PURCHASE);
                    purchaserRemindMsgIntfceReqBO.setSaleOrderId(orderSaleInfo.getPurchaseOrderId());
                }
                if ((templateMatchRspBO = this.dealTemplateMatch(purchaserRemindMsgIntfceReqBO, remindConfigure, contactInfo)) != null && "0000".equals(templateMatchRspBO.getRespCode())) {
                    ++successCount;
                    continue;
                }
                ++failurCount;
            }
        }
        String respDesc = "\u53d1\u9001\u6210\u529f\u3010" + successCount + "\u3011\u6761\u4fe1\u606f\uff0c\u53d1\u9001\u5931\u8d25\u3010" + failurCount + "\u3011\u6761\u4fe1\u606f";
        return respDesc;
    }
}

