/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.atom.OrderPurchaseQueryXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseRspBO;
import com.cgd.order.atom.bo.PurchaseOrderItemXbjRspBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderPurchaseQueryXbjAtomServiceImpl
implements OrderPurchaseQueryXbjAtomService {
    private static final Log log = LogFactory.getLog(OrderPurchaseQueryXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseXbjMapper orderPurchaseMapper;
    private OrderPurchaseItemXbjMapper orderPurchaseItemMapper;

    public void setOrderPurchaseMapper(OrderPurchaseXbjMapper orderPurchaseMapper) {
        this.orderPurchaseMapper = orderPurchaseMapper;
    }

    public void setOrderPurchaseItemMapper(OrderPurchaseItemXbjMapper orderPurchaseItemMapper) {
        this.orderPurchaseItemMapper = orderPurchaseItemMapper;
    }

    @Override
    public List<OrderPurchaseRspBO> queryOrderPursechaseList(String purchaseOrderCode, String purchaseOrderStatus, List<Integer> statusList, String skuName, String protocolCode, String supplierName, String beginTime, String endTime, String deliveryId, List<Integer> saleOrderTypes, Page<OrderPurchaseXbjPO> page) {
        if (this.isDebugEnabled) {
            this.outputPurchaseData(purchaseOrderCode, purchaseOrderStatus, statusList, skuName, protocolCode, supplierName, beginTime, endTime, deliveryId, saleOrderTypes);
        }
        ArrayList<OrderPurchaseRspBO> orderPurchaseRspList = new ArrayList<OrderPurchaseRspBO>();
        try {
            List orderPurchaseIdList = null;
            if (null != orderPurchaseIdList && orderPurchaseIdList.size() > 0) {
                for (OrderPurchaseXbjPO orderPurchaseId : orderPurchaseIdList) {
                    OrderPurchaseXbjPO orderPurchase = null;
                    if (null == orderPurchase) continue;
                    OrderPurchaseRspBO orderPurchaseRsp = this.assemblePurchaseData(orderPurchase);
                    orderPurchaseRspList.add(orderPurchaseRsp);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e);
        }
        return orderPurchaseRspList;
    }

    private void outputPurchaseData(String purchaseOrderCode, String purchaseOrderStatus, List<Integer> statusList, String skuName, String protocolCode, String supplierName, String beginTime, String endTime, String deliveryId, List<Integer> saleOrderTypes) {
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a" + purchaseOrderCode));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u8ba2\u5355\u72b6\u6001\uff1a" + purchaseOrderStatus));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u8ba2\u5355\u72b6\u6001List\uff1a" + statusList));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u5546\u54c1\u540d\u79f0\uff1a" + skuName));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u534f\u8bae\u7f16\u53f7\uff1a" + protocolCode));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u5382\u5546\u540d\u79f0\uff1a" + supplierName));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4\uff1a" + beginTime));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u8ba2\u5355\u7ed3\u675f\u65f6\u95f4\uff1a" + endTime));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u914d\u9001\u4e13\u8d23\uff1a" + deliveryId));
        log.debug((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff0c\u8ba2\u5355\u6765\u6e90\uff1a" + saleOrderTypes));
    }

    private OrderPurchaseRspBO assemblePurchaseData(OrderPurchaseXbjPO orderPurchase) {
        OrderPurchaseRspBO orderPurchaseRsp = new OrderPurchaseRspBO();
        try {
            orderPurchaseRsp.setPurchaseOrderCode(orderPurchase.getPurchaseOrderCode());
            orderPurchaseRsp.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
            orderPurchaseRsp.setPurchaseOrderStatus(orderPurchase.getPurchaseOrderStatus());
            orderPurchaseRsp.setCreateTime(orderPurchase.getCreateTime());
            orderPurchaseRsp.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
            orderPurchaseRsp.setPurchaseOrderName(orderPurchase.getPurchaseOrderName());
            List<PurchaseOrderItemXbjRspBO> purchaseOrderItemRspBOList = this.assemblePurchaseDataItem(orderPurchase);
            orderPurchaseRsp.setPurchaseOrderItemList(purchaseOrderItemRspBOList);
            orderPurchaseRsp.setPurchaserId(orderPurchase.getPurchaserId());
            orderPurchaseRsp.setSaleOrderId(orderPurchase.getSaleOrderId());
        }
        catch (Exception e) {
            log.error((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u7ec4\u88c5\u8ba2\u5355\u6570\u636e\u51fa\u9519" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u7ec4\u88c5\u8ba2\u5355\u6570\u636e\u51fa\u9519" + e);
        }
        return orderPurchaseRsp;
    }

    private List<PurchaseOrderItemXbjRspBO> assemblePurchaseDataItem(OrderPurchaseXbjPO orderPurchase) {
        ArrayList<PurchaseOrderItemXbjRspBO> purchaseOrderItemRspBOList = new ArrayList<PurchaseOrderItemXbjRspBO>();
        try {
            List orderPurchaseItemList = null;
            if (null != orderPurchaseItemList && orderPurchaseItemList.size() > 0) {
                for (OrderPurchaseItemXbjPO orderPurchaseItem : orderPurchaseItemList) {
                    PurchaseOrderItemXbjRspBO purchaseOrderItemRsp = this.assemblePurchaseDataSKU(orderPurchaseItem.getSkuId());
                    purchaseOrderItemRsp.setPurchaseOrderItemId(orderPurchaseItem.getPurchaseOrderItemId());
                    purchaseOrderItemRsp.setPurchaseCount(orderPurchaseItem.getPurchaseCount());
                    purchaseOrderItemRsp.setUnitName(orderPurchaseItem.getUnitName());
                    purchaseOrderItemRsp.setSkuSalePrice(orderPurchaseItem.getPurchasingPrice());
                    purchaseOrderItemRspBOList.add(purchaseOrderItemRsp);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u7ec4\u88c5\u8ba2\u5355\u660e\u7ec6\u6570\u636e\u51fa\u9519" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u7ec4\u88c5\u8ba2\u5355\u660e\u7ec6\u6570\u636e\u51fa\u9519" + e);
        }
        return purchaseOrderItemRspBOList;
    }

    private PurchaseOrderItemXbjRspBO assemblePurchaseDataSKU(Long skuId) {
        PurchaseOrderItemXbjRspBO purchaseOrderItemRsp = new PurchaseOrderItemXbjRspBO();
        try {
            Object skuInfo = null;
        }
        catch (Exception e) {
            log.error((Object)("\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u67e5\u8be2SKU\u4fe1\u606f\u51fa\u9519" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u7535\u529b\u4e13\u533a\u4e13\u4e1a\u516c\u53f8\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u539f\u5b50\u670d\u52a1\u67e5\u8be2SKU\u4fe1\u606f\u51fa\u9519" + e);
        }
        return purchaseOrderItemRsp;
    }
}

