/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.util.internal.StringUtil;
import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.QryOrderListXbjAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderTabMappingOrderStatusXbjMapper;
import com.cgd.order.dao.XbjOrderTypeQryMapper;
import com.cgd.order.intfce.bo.XbjAccessoryBO;
import com.cgd.order.intfce.bo.XbjOrderConstrInfoBO;
import com.cgd.order.intfce.bo.XbjOrderConstrListRspBO;
import com.cgd.order.intfce.bo.XbjOrderListQryReqBO;
import com.cgd.order.intfce.bo.XbjOrderServInfoBO;
import com.cgd.order.intfce.bo.XbjOrderServListRspBO;
import com.cgd.order.intfce.bo.XbjOrderShipInfoBO;
import com.cgd.order.intfce.bo.XbjOrderShipListRspBO;
import com.cgd.order.intfce.bo.XbjOrderTypeBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderTabMappingOrderStatusXbjPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryOrderListXbjAtomServiceImpl
implements QryOrderListXbjAtomService {
    private static final Log log = LogFactory.getLog(QryOrderListXbjAtomService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private XbjOrderTypeQryMapper xbjOrderTypeQryMapper;
    @Autowired
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;

    public void setXbjOrderTypeQryMapper(XbjOrderTypeQryMapper xbjOrderTypeQryMapper) {
        this.xbjOrderTypeQryMapper = xbjOrderTypeQryMapper;
    }

    @Override
    public XbjOrderShipListRspBO qryOrderShipBySale(String saleOrderId, int pageNo, int pageSize) {
        XbjOrderShipListRspBO resultPage = new XbjOrderShipListRspBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qrySaleOrderType(saleOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("saleOrderId", saleOrderId);
            List<XbjOrderShipInfoBO> saleOrderShipList = this.xbjOrderTypeQryMapper.qryOrderShipList(condition, (Page<XbjOrderShipInfoBO>)page);
            if (saleOrderShipList == null) {
                saleOrderShipList = new ArrayList<XbjOrderShipInfoBO>();
            }
            try {
                if (saleOrderShipList.size() > 0) {
                    for (XbjOrderShipInfoBO bo : saleOrderShipList) {
                        ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                        List<AccessoryAtomXbjRspBO> accessoryPOList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(bo.getOrderShipId()), XbjOrderConstants.ACCESSORY_TYPE.SHIP);
                        if (!CollectionUtils.isNotEmpty(accessoryPOList)) continue;
                        for (AccessoryAtomXbjRspBO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        bo.setDownLoadFiles(accessoryBOList);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(saleOrderShipList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u53d1\u8d27\u5355");
        }
        return resultPage;
    }

    @Override
    public XbjOrderShipListRspBO qryOrderShipByPurchase(String purchaseOrderId, int pageNo, int pageSize) {
        XbjOrderShipListRspBO resultPage = new XbjOrderShipListRspBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qryPurchaseOrderType(purchaseOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("purchaseOrderId", purchaseOrderId);
            List<XbjOrderShipInfoBO> purchaseOrderShipList = this.xbjOrderTypeQryMapper.qryOrderShipList(condition, (Page<XbjOrderShipInfoBO>)page);
            if (purchaseOrderShipList == null) {
                purchaseOrderShipList = new ArrayList<XbjOrderShipInfoBO>();
            }
            try {
                if (purchaseOrderShipList.size() > 0) {
                    for (XbjOrderShipInfoBO bo : purchaseOrderShipList) {
                        ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                        AccessoryXbjPO accessoryPO = new AccessoryXbjPO();
                        accessoryPO.setObjectId(Long.valueOf(bo.getOrderShipId()));
                        accessoryPO.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.SHIP);
                        List<AccessoryAtomXbjRspBO> accessoryPOList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(bo.getOrderShipId()), XbjOrderConstants.ACCESSORY_TYPE.SHIP);
                        if (accessoryPOList == null) continue;
                        for (AccessoryAtomXbjRspBO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        bo.setDownLoadFiles(accessoryBOList);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(purchaseOrderShipList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u53d1\u8d27\u5355");
        }
        return resultPage;
    }

    @Override
    public XbjOrderConstrListRspBO qryOrderConstrBySale(String saleOrderId, int pageNo, int pageSize) {
        XbjOrderConstrListRspBO resultPage = new XbjOrderConstrListRspBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qrySaleOrderType(saleOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("saleOrderId", saleOrderId);
            List<XbjOrderConstrInfoBO> saleOrderConstrList = this.xbjOrderTypeQryMapper.qryOrderConstrList(condition, (Page<XbjOrderConstrInfoBO>)page);
            if (saleOrderConstrList == null) {
                saleOrderConstrList = new ArrayList<XbjOrderConstrInfoBO>();
            }
            try {
                if (saleOrderConstrList.size() > 0) {
                    for (XbjOrderConstrInfoBO bo : saleOrderConstrList) {
                        ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                        AccessoryXbjPO accessoryPO = new AccessoryXbjPO();
                        accessoryPO.setObjectId(Long.valueOf(bo.getOrderConstrId()));
                        accessoryPO.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.CONSTR_COMPLETE);
                        List<AccessoryAtomXbjRspBO> accessoryPOList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(bo.getOrderConstrId()), XbjOrderConstants.ACCESSORY_TYPE.CONSTR_COMPLETE);
                        if (accessoryPOList == null) continue;
                        for (AccessoryAtomXbjRspBO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        bo.setDownLoadFiles(accessoryBOList);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(saleOrderConstrList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u65bd\u5de5\u5355");
        }
        return resultPage;
    }

    @Override
    public XbjOrderConstrListRspBO qryOrderConstrByPurchase(String purchaseOrderId, int pageNo, int pageSize) {
        XbjOrderConstrListRspBO resultPage = new XbjOrderConstrListRspBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qryPurchaseOrderType(purchaseOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("purchaseOrderId", purchaseOrderId);
            List<XbjOrderConstrInfoBO> purchaseOrderConstrList = this.xbjOrderTypeQryMapper.qryOrderConstrList(condition, (Page<XbjOrderConstrInfoBO>)page);
            if (purchaseOrderConstrList == null) {
                purchaseOrderConstrList = new ArrayList<XbjOrderConstrInfoBO>();
            }
            try {
                if (purchaseOrderConstrList.size() > 0) {
                    for (XbjOrderConstrInfoBO bo : purchaseOrderConstrList) {
                        ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                        List<AccessoryAtomXbjRspBO> accessoryPOList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(bo.getOrderConstrId()), XbjOrderConstants.ACCESSORY_TYPE.CONSTR_COMPLETE);
                        if (accessoryPOList == null) continue;
                        for (AccessoryAtomXbjRspBO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        bo.setDownLoadFiles(accessoryBOList);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(purchaseOrderConstrList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u65bd\u5de5\u5355");
        }
        return resultPage;
    }

    @Override
    public XbjOrderServListRspBO qryOrderServBySale(String saleOrderId, int pageNo, int pageSize) {
        XbjOrderServListRspBO resultPage = new XbjOrderServListRspBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qrySaleOrderType(saleOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("saleOrderId", saleOrderId);
            List<XbjOrderServInfoBO> saleOrderServList = this.xbjOrderTypeQryMapper.qryOrderServList(condition, (Page<XbjOrderServInfoBO>)page);
            if (saleOrderServList == null) {
                saleOrderServList = new ArrayList<XbjOrderServInfoBO>();
            }
            try {
                if (saleOrderServList.size() > 0) {
                    for (XbjOrderServInfoBO bo : saleOrderServList) {
                        ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                        List<AccessoryAtomXbjRspBO> accessoryPOList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(bo.getOrderServId()), XbjOrderConstants.ACCESSORY_TYPE.SERV_COMPLETE);
                        if (accessoryPOList == null) continue;
                        for (AccessoryAtomXbjRspBO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        bo.setDownLoadFiles(accessoryBOList);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(saleOrderServList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u670d\u52a1\u5355");
        }
        return resultPage;
    }

    @Override
    public XbjOrderServListRspBO qryOrderServByPurchase(String purchaseOrderId, int pageNo, int pageSize) {
        XbjOrderServListRspBO resultPage = new XbjOrderServListRspBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qryPurchaseOrderType(purchaseOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("purchaseOrderId", purchaseOrderId);
            List<XbjOrderServInfoBO> purchaseOrderServList = this.xbjOrderTypeQryMapper.qryOrderServList(condition, (Page<XbjOrderServInfoBO>)page);
            if (purchaseOrderServList == null) {
                purchaseOrderServList = new ArrayList<XbjOrderServInfoBO>();
            }
            try {
                if (purchaseOrderServList.size() > 0) {
                    for (XbjOrderServInfoBO bo : purchaseOrderServList) {
                        ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                        List<AccessoryAtomXbjRspBO> accessoryPOList = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(bo.getOrderServId()), XbjOrderConstants.ACCESSORY_TYPE.SERV_COMPLETE);
                        if (accessoryPOList == null) continue;
                        for (AccessoryAtomXbjRspBO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        bo.setDownLoadFiles(accessoryBOList);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(purchaseOrderServList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u670d\u52a1\u5355");
        }
        return resultPage;
    }

    @Override
    public XbjOrderShipListRspBO qryOrderShipInspection(XbjOrderListQryReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        XbjOrderShipListRspBO resultPage = new XbjOrderShipListRspBO();
        Map<Object, Object> condition = new HashMap();
        condition = this.getCondition(reqBO);
        List<XbjOrderShipInfoBO> shipInspectionList = this.xbjOrderTypeQryMapper.qryOrderShipInspectionList(condition, (Page<XbjOrderShipInfoBO>)page);
        if (shipInspectionList == null) {
            shipInspectionList = new ArrayList<XbjOrderShipInfoBO>();
        }
        resultPage.setRecordsTotal(page.getTotalCount());
        resultPage.setTotal(page.getTotalPages());
        resultPage.setRespCode("0000");
        resultPage.setRespDesc("\u7269\u8d44\u9a8c\u6536\u67e5\u8be2\u53d1\u8d27\u5355\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
        resultPage.setRows(shipInspectionList);
        return resultPage;
    }

    @Override
    public XbjOrderConstrListRspBO qryOrderConstrInspection(XbjOrderListQryReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        XbjOrderConstrListRspBO resultPage = new XbjOrderConstrListRspBO();
        Map<Object, Object> condition = new HashMap();
        condition = this.getCondition(reqBO);
        List<XbjOrderConstrInfoBO> constrInspectionList = this.xbjOrderTypeQryMapper.qryOrderConstrInspectionList(condition, (Page<XbjOrderConstrInfoBO>)page);
        if (constrInspectionList == null) {
            constrInspectionList = new ArrayList<XbjOrderConstrInfoBO>();
        }
        resultPage.setRecordsTotal(page.getTotalCount());
        resultPage.setTotal(page.getTotalPages());
        resultPage.setRespCode("0000");
        resultPage.setRespDesc("\u7269\u8d44\u9a8c\u6536\u67e5\u8be2\u53d1\u8d27\u5355\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
        resultPage.setRows(constrInspectionList);
        return resultPage;
    }

    @Override
    public XbjOrderServListRspBO qryOrderServInspection(XbjOrderListQryReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        XbjOrderServListRspBO resultPage = new XbjOrderServListRspBO();
        Map<String, Object> condition = this.getCondition(reqBO);
        List<XbjOrderServInfoBO> servInspectionList = this.xbjOrderTypeQryMapper.qryOrderServInspectionList(condition, (Page<XbjOrderServInfoBO>)page);
        if (servInspectionList == null) {
            servInspectionList = new ArrayList<XbjOrderServInfoBO>();
        }
        resultPage.setRecordsTotal(page.getTotalCount());
        resultPage.setTotal(page.getTotalPages());
        resultPage.setRespCode("0000");
        resultPage.setRespDesc("\u7269\u8d44\u9a8c\u6536\u67e5\u8be2\u53d1\u8d27\u5355\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
        resultPage.setRows(servInspectionList);
        return resultPage;
    }

    private Map<String, Object> getCondition(XbjOrderListQryReqBO reqBO) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        if (reqBO.getTabId() != null) {
            ArrayList<Integer> statusList = new ArrayList<Integer>();
            List<OrderTabMappingOrderStatusXbjPO> orderTabMappingOrderStatusList = this.orderTabMappingOrderStatusXbjMapper.selectByTabId(reqBO.getTabId());
            if (!CollectionUtils.isEmpty(orderTabMappingOrderStatusList)) {
                for (OrderTabMappingOrderStatusXbjPO tabMappingOrderStatusXbjPO : orderTabMappingOrderStatusList) {
                    statusList.add(tabMappingOrderStatusXbjPO.getSaleOrderStatusCode());
                }
                condition.put("statuses", statusList);
            }
        }
        if (reqBO.getRoleType().equals("purchase")) {
            condition.put("purchaseId", reqBO.getCompanyId());
        } else if (reqBO.getRoleType().equals("supplier")) {
            condition.put("goodsSupplierId", reqBO.getSupId());
        }
        if (reqBO.getGoodsSupplierId() != null) {
            condition.put("goodsSupplierId", reqBO.getGoodsSupplierId());
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getSaleOrderCodes())) {
            String[] saleOrderCodestr = reqBO.getSaleOrderCodes().split(",");
            ArrayList<String> saleOrderCodes = new ArrayList<String>();
            for (String saleOrderCode : saleOrderCodestr) {
                saleOrderCodes.add(saleOrderCode);
            }
            condition.put("saleOrderCodes", saleOrderCodes);
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getSaleOrderNames())) {
            String[] saleOrderNamestr = reqBO.getSaleOrderNames().split(",");
            ArrayList<String> saleOrderNames = new ArrayList<String>();
            for (String saleOrderCode : saleOrderNamestr) {
                saleOrderNames.add(saleOrderCode);
            }
            condition.put("saleOrderNames", saleOrderNames);
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getPurchaseOrderCodes())) {
            String[] puchaseOrderCodestr = reqBO.getPurchaseOrderCodes().split(",");
            ArrayList<String> puchaseOrderCodes = new ArrayList<String>();
            for (String purchaseOrderCode : puchaseOrderCodestr) {
                puchaseOrderCodes.add(purchaseOrderCode);
            }
            condition.put("purchaseOrderCodes", puchaseOrderCodes);
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getPurchaseOrderNames())) {
            String[] purchaseOrderNamestr = reqBO.getPurchaseOrderNames().split(",");
            ArrayList<String> purchaseOrderNames = new ArrayList<String>();
            for (String purchaseOrderName : purchaseOrderNamestr) {
                purchaseOrderNames.add(purchaseOrderName);
            }
            condition.put("purchaseOrderNames", purchaseOrderNames);
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getShipIds())) {
            String[] shipIdstr = reqBO.getShipIds().split(",");
            ArrayList<String> shipIds = new ArrayList<String>();
            for (String saleOrderCode : shipIdstr) {
                shipIds.add(saleOrderCode);
            }
            condition.put("shipIds", shipIds);
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getOpenOrderNos())) {
            String[] openOrderNostr = reqBO.getOpenOrderNos().split(",");
            ArrayList<String> openOrderNos = new ArrayList<String>();
            for (String saleOrderCode : openOrderNostr) {
                openOrderNos.add(saleOrderCode);
            }
            condition.put("openOrderNos", openOrderNos);
        }
        if (reqBO.getQryDateEff() != null) {
            condition.put("qryDateEff", reqBO.getQryDateEff());
        }
        if (reqBO.getQryDateExp() != null) {
            condition.put("qryDateExp", reqBO.getQryDateExp());
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getShipStatus())) {
            condition.put("shipStatus", reqBO.getShipStatus());
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getServStatus())) {
            condition.put("servStatus", reqBO.getServStatus());
        }
        if (!StringUtil.isNullOrEmpty((String)reqBO.getConstrStatus())) {
            condition.put("constrStatus", reqBO.getConstrStatus());
        }
        return condition;
    }
}

