/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.busi.XbjAccessoryBusiService;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.busi.bo.XbjSaveAccessoryRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class XbjAccessoryBusiServiceImpl
implements XbjAccessoryBusiService {
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;
    private AccessoryXbjAtomService accessoryXbjAtomService;

    public void setOrderPurchaseXbjAtomService(OrderPurchaseXbjAtomService orderPurchaseXbjAtomService) {
        this.orderPurchaseXbjAtomService = orderPurchaseXbjAtomService;
    }

    public void setAccessoryXbjAtomService(AccessoryXbjAtomService accessoryXbjAtomService) {
        this.accessoryXbjAtomService = accessoryXbjAtomService;
    }

    public XbjSaveAccessoryRspBO saveAccessoryByPurchaseOrder(Long purchaseOrderId, Integer paramObjectType, List<XbjPurchaseAccessoryReqBO> list) {
        if (list == null || list.size() == 0) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9644\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        List<AccessoryXbjPO> acessoryList = this.assembleAccessoryData(purchaseOrderId, paramObjectType, list);
        int count = this.accessoryXbjAtomService.batchSave(acessoryList);
        XbjSaveAccessoryRspBO rsp = new XbjSaveAccessoryRspBO();
        if (count < 1) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5931\u8d25");
            return rsp;
        }
        rsp.setCount(Integer.valueOf(count));
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private List<AccessoryXbjPO> assembleAccessoryData(Long purchaseOrderId, Integer paramObjectType, List<XbjPurchaseAccessoryReqBO> list) {
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjAtomService.queryOrderPurchaseInfo(purchaseOrderId);
        if (orderPurchaseXbjPO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u67e5\u8be2\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u8bb0\u5f55");
        }
        try {
            if (Constant.REJECT_OBJECT_TYPE.equals(paramObjectType)) {
                this.accessoryXbjAtomService.deleteAccessoryInfo(orderPurchaseXbjPO.getSaleOrderId(), paramObjectType);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u62d2\u5355\u5f85\u5904\u7406\u670d\u52a1\u5220\u9664\u9644\u4ef6\u5185\u5bb9\u51fa\u9519");
        }
        ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
        for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : list) {
            AccessoryXbjPO accessory = new AccessoryXbjPO();
            accessory.setAccessoryId(String.valueOf(xbjPurchaseAccessoryReqBO.getAccessoryId()));
            accessory.setAccessoryName(xbjPurchaseAccessoryReqBO.getAccessoryName());
            accessory.setAccessoryUrl(xbjPurchaseAccessoryReqBO.getAccessoryUrl());
            accessory.setCreateDate(new Date());
            accessory.setGoodsSupplierId(String.valueOf(orderPurchaseXbjPO.getGoodsSupplierId()));
            accessory.setObjectId(orderPurchaseXbjPO.getSaleOrderId());
            accessory.setObjectType(paramObjectType);
            accessory.setProfessionalOrganizationId(String.valueOf(orderPurchaseXbjPO.getProfessionalOrganizationId()));
            accessory.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
            accessory.setPurchaserAccountName(orderPurchaseXbjPO.getPurchaserAccountName());
            accessory.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
            accessory.setRemark("\u62d2\u5355\u5f55\u5165");
            accessoryList.add(accessory);
        }
        return accessoryList;
    }
}

