/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjCheckSaleOrderConfirmService;
import com.cgd.order.busi.bo.XbjCheckSaleOrderConfirmReqBO;
import com.cgd.order.busi.bo.XbjCheckSaleOrderConfirmRspBO;
import com.cgd.order.busi.bo.XbjSaleOrderDetailRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjCheckSaleOrderConfirmServiceImpl
implements XbjCheckSaleOrderConfirmService {
    private static final Logger log = LoggerFactory.getLogger(XbjCheckSaleOrderConfirmServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XbjCheckSaleOrderConfirmRspBO checkSaleOrderConfirm(XbjCheckSaleOrderConfirmReqBO checkSaleOrderConfirm) {
        XbjCheckSaleOrderConfirmRspBO checkSaleOrderConfirmRspBO = new XbjCheckSaleOrderConfirmRspBO();
        Boolean confirmFlag = false;
        try {
            if (this.isDebugEnabled) {
                log.debug("\u6821\u9a8c\u9500\u552e\u8ba2\u5355\u80fd\u5426\u63d0\u9192\u786e\u8ba4\u5165\u53c2\uff1a" + checkSaleOrderConfirm);
            }
            if (StringUtils.isBlank((CharSequence)checkSaleOrderConfirm.getSaleOrderId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == checkSaleOrderConfirm.getPurchaserId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            XbjSaleOrderDetailRspBO selectByCondition = this.orderSaleXbjMapper.selectByCondition(Long.valueOf(checkSaleOrderConfirm.getSaleOrderId()), checkSaleOrderConfirm.getPurchaserId());
            if (null == selectByCondition) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4e3a\u7a7a");
            if (!Constant.SALSE_ORDER_STATE_TO_CONF.equals(selectByCondition.getSaleOrderStatus())) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u786e\u8ba4\u4e2d");
            OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.selectIdBySaleOrderAndPurchase(Long.valueOf(checkSaleOrderConfirm.getSaleOrderId()), checkSaleOrderConfirm.getPurchaserId());
            if (null != orderPurchase) {
                confirmFlag = Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING.equals(orderPurchase.getPurchaseOrderStatus()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            checkSaleOrderConfirmRspBO.setRespCode("0000");
            checkSaleOrderConfirmRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u6821\u9a8c\u9500\u552e\u8ba2\u5355\u80fd\u5426\u786e\u8ba4\u5f02\u5e38" + e);
            }
            confirmFlag = false;
            checkSaleOrderConfirmRspBO.setRespCode("8888");
            checkSaleOrderConfirmRspBO.setRespDesc("\u5931\u8d25");
        }
        checkSaleOrderConfirmRspBO.setConfirmFlag(confirmFlag);
        return checkSaleOrderConfirmRspBO;
    }
}

