/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GoodsReturnXbjAtomService;
import com.cgd.order.atom.OrderReciveItemXbjService;
import com.cgd.order.atom.bo.OrderReciveItemAtomXbjRspBO;
import com.cgd.order.busi.XbjReturnBusiService;
import com.cgd.order.busi.bo.XbjReturnBusiReqBO;
import com.cgd.order.busi.bo.XbjReturnBusiRspBO;
import com.cgd.order.busi.bo.XbjReturnItemReqBO;
import com.cgd.order.dao.OrderReceiveItemXbjMapper;
import com.cgd.order.intfce.XbjReturnIntfceService;
import com.cgd.order.intfce.bo.AddressInfoIntfceXbjReqBO;
import com.cgd.order.intfce.bo.XbjReturnReqBO;
import com.cgd.order.intfce.bo.XbjReturnRspBO;
import com.cgd.order.po.OrderReceiveItemXbjPO;
import com.cgd.pay.busi.BusiElecRefundApplyService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjReturnIntfceServiceImpl
implements XbjReturnIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjReturnIntfceServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private XbjReturnBusiService xbjReturnBusiService;
    private OrderReciveItemXbjService orderReciveItemXbjService;
    private BusiElecRefundApplyService busiElecRefundApplyService;
    private GoodsReturnXbjAtomService goodsReturnXbjAtomService;
    @Autowired
    private OrderReceiveItemXbjMapper orderReceiveItemXbjMapper;

    public void setXbjReturnBusiService(XbjReturnBusiService xbjReturnBusiService) {
        this.xbjReturnBusiService = xbjReturnBusiService;
    }

    public void setOrderReciveItemXbjService(OrderReciveItemXbjService orderReciveItemXbjService) {
        this.orderReciveItemXbjService = orderReciveItemXbjService;
    }

    public void setBusiElecRefundApplyService(BusiElecRefundApplyService busiElecRefundApplyService) {
        this.busiElecRefundApplyService = busiElecRefundApplyService;
    }

    public void setGoodsReturnXbjAtomService(GoodsReturnXbjAtomService goodsReturnXbjAtomService) {
        this.goodsReturnXbjAtomService = goodsReturnXbjAtomService;
    }

    public XbjReturnRspBO dealXbjReturn(XbjReturnReqBO xbjReturnReq) {
        if (isDebugEnabled) {
            log.debug("\u9000\u8d27\u5355\u751f\u6210\u7ec4\u5408\u670d\u52a1" + xbjReturnReq);
        }
        XbjReturnRspBO xbjReturnRspBO = new XbjReturnRspBO();
        try {
            this.validate(xbjReturnReq);
            this.valiBusidate(xbjReturnReq);
            XbjReturnBusiReqBO returnBusiReqBO = this.initReturnBusiReqBO(xbjReturnReq);
            XbjReturnBusiRspBO dealReturn = this.xbjReturnBusiService.dealReturn(returnBusiReqBO);
            if (!"0000".equals(dealReturn.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", dealReturn.getRespDesc());
            }
            xbjReturnRspBO.setReturnId(dealReturn.getGoodsReturnId() + "");
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u9000\u8d27\u7533\u8bf7\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        xbjReturnRspBO.setRespCode("0000");
        xbjReturnRspBO.setRespDesc("\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)\u9000\u8d27\u7533\u8bf7\u6210\u529f\uff01");
        return xbjReturnRspBO;
    }

    private void validate(XbjReturnReqBO returnReq) {
        if (null == returnReq) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5165\u53c3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getQuestionDesc())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u95ee\u9898\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getSaleOrderId())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getInspectionId())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getInspectionCode())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u5355code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getReceiverName())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8054\u7cfb\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getReceiverMobileNumber())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == returnReq.getAddress()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == returnReq.getAddress().getProvId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7701\u4efd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getAddress().getProvince())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == returnReq.getAddress().getCityId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u57ce\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getAddress().getCity())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u57ce\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == returnReq.getAddress().getCountyId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getAddress().getCounty())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getAddress().getName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getAddress().getTel())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)returnReq.getAddress().getAddrDesc())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != returnReq.getQuestionDesc() && returnReq.getQuestionDesc().length() > 200) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u95ee\u9898\u63cf\u8ff0\u5fc5\u987b\u5c0f\u4e8e200");
        }
        List returnItem = returnReq.getReturnItem();
        if (null != returnItem && !returnItem.isEmpty()) {
            for (XbjReturnItemReqBO returnItemReqBO : returnItem) {
                if (null == returnItemReqBO.getId()) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null != returnItemReqBO.getReturnCount() && returnItemReqBO.getReturnCount().compareTo(BigDecimal.ZERO) != 0) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a0\uff01");
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void valiBusidate(XbjReturnReqBO returnReq) {
        List returnItem = returnReq.getReturnItem();
        if (null != returnItem && !returnItem.isEmpty()) {
            for (XbjReturnItemReqBO returnItemReqBO : returnItem) {
                OrderReciveItemAtomXbjRspBO qryOrderReciveItem = this.orderReciveItemXbjService.qryOrderReciveItem(Long.valueOf(returnReq.getInspectionId()), returnItemReqBO.getId(), Long.valueOf(returnReq.getPurchaseId()));
                if (qryOrderReciveItem != null) {
                    if (qryOrderReciveItem.getPurchaseCount().compareTo(returnItemReqBO.getReturnCount()) >= 0) continue;
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u672c\u6b21\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u9a8c\u6536\u6570\u91cf\uff01");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u6536\u8d27\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
        } else {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u9000\u8d27\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
    }

    private XbjReturnBusiReqBO initReturnBusiReqBO(XbjReturnReqBO returnReq) {
        try {
            XbjReturnBusiReqBO returnBusiReqBO = new XbjReturnBusiReqBO();
            returnBusiReqBO.setQuestionDesc(returnReq.getQuestionDesc());
            returnBusiReqBO.setReturnMode(returnReq.getReturnMode());
            returnBusiReqBO.setPickupStartTime(returnReq.getPickupStartTime());
            returnBusiReqBO.setPickupEndTime(returnReq.getPickupEndTime());
            returnBusiReqBO.setSaleOrderId(returnReq.getSaleOrderId());
            returnBusiReqBO.setInspectionId(returnReq.getInspectionId());
            returnBusiReqBO.setReceiverName(returnReq.getReceiverName());
            returnBusiReqBO.setReceiverMobileNumber(returnReq.getReceiverMobileNumber());
            returnBusiReqBO.setInspectionCode(returnReq.getInspectionCode());
            returnBusiReqBO.setPurchaserId(Long.valueOf(returnReq.getPurchaseId()));
            returnBusiReqBO.setCompanyId(returnReq.getCompanyId());
            returnBusiReqBO.setCompanyName(returnReq.getCompanyName());
            returnBusiReqBO.setOrgId(returnReq.getOrgId());
            returnBusiReqBO.setOrgName(returnReq.getOrgName());
            returnBusiReqBO.setUserId(returnReq.getUserId());
            returnBusiReqBO.setUserName(returnReq.getUserName());
            returnBusiReqBO.setAccessoryList(returnReq.getAccessoryList());
            if (returnReq.getReturnItem() != null) {
                ArrayList<XbjReturnItemReqBO> xbjReturnItemReqBOList = new ArrayList<XbjReturnItemReqBO>();
                List returnItemReqList = returnReq.getReturnItem();
                for (XbjReturnItemReqBO returnItemReqBO : returnItemReqList) {
                    OrderReceiveItemXbjPO orderReceiveItemXbjPO = this.orderReceiveItemXbjMapper.getModelById(returnItemReqBO.getId());
                    if (orderReceiveItemXbjPO == null) continue;
                    XbjReturnItemReqBO xbjReturnItemReqBO = new XbjReturnItemReqBO();
                    xbjReturnItemReqBO.setId(returnItemReqBO.getId());
                    xbjReturnItemReqBO.setSaleOrderItemId(orderReceiveItemXbjPO.getSaleOrderItemId());
                    xbjReturnItemReqBO.setReturnCount(returnItemReqBO.getReturnCount());
                    xbjReturnItemReqBOList.add(xbjReturnItemReqBO);
                }
                returnBusiReqBO.setReturnItem(xbjReturnItemReqBOList);
            }
            AddressInfoIntfceXbjReqBO addressInfo = new AddressInfoIntfceXbjReqBO();
            addressInfo.setReceiverProvinceId(returnReq.getAddress().getProvId() + "");
            addressInfo.setReceiverProvinceName(returnReq.getAddress().getProvince());
            addressInfo.setReceiverCityId(returnReq.getAddress().getCityId() + "");
            addressInfo.setReceiverCityName(returnReq.getAddress().getCity());
            addressInfo.setReceiverCountyId(returnReq.getAddress().getCountyId() + "");
            addressInfo.setReceiverCountyName(returnReq.getAddress().getCounty());
            addressInfo.setReceiverTownId(returnReq.getAddress().getTownId() + "");
            addressInfo.setReceiverTown(returnReq.getAddress().getTown());
            addressInfo.setReceiverAddress(returnReq.getAddress().getAddrDesc());
            addressInfo.setReceiverName(returnReq.getAddress().getName());
            addressInfo.setReceiverMobileNumber(returnReq.getAddress().getTel());
            returnBusiReqBO.setPickupAddress(addressInfo);
            return returnBusiReqBO;
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u4e1a\u52a1\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9000\u8d27\u5355\u751f\u6210\u7ec4\u5408\u670d\u52a1\u521d\u59cb\u5316\u4e1a\u52a1\u4fe1\u606f\u5f02\u5e38\uff01");
        }
    }
}

