/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.base.util.DelFormatHelper;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.EaCreateSalesOrderCodeXbjAtomService;
import com.cgd.order.atom.SequenceXbjAtomService;
import com.cgd.order.atom.bo.EaGenerateSalesOrderCodeSeqXbjRspBO;
import com.cgd.order.dao.OrderProfessionalOrganizationXbjMapper;
import com.cgd.order.po.OrderProfessionalOrganizationXbjPO;
import com.cgd.order.util.GenerateSaleOrderCodeXbj;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaCreateSalesOrderCodeXbjAtomServiceImpl
implements EaCreateSalesOrderCodeXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(EaCreateSalesOrderCodeXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private SequenceXbjAtomService sequenceXbjAtomService;
    private OrderProfessionalOrganizationXbjMapper orderProfessionalOrganizationXbjMapper;

    public void setOrderProfessionalOrganizationXbjMapper(OrderProfessionalOrganizationXbjMapper orderProfessionalOrganizationXbjMapper) {
        this.orderProfessionalOrganizationXbjMapper = orderProfessionalOrganizationXbjMapper;
    }

    public void setSequenceXbjAtomService(SequenceXbjAtomService sequenceXbjAtomService) {
        this.sequenceXbjAtomService = sequenceXbjAtomService;
    }

    @Override
    public EaGenerateSalesOrderCodeSeqXbjRspBO createSalesOrderCode(Long professionalOrganizationId) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u548c\u91c7\u8d2d\u8ba2\u5355code\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + professionalOrganizationId);
        }
        EaGenerateSalesOrderCodeSeqXbjRspBO generateSalesOrderCodeSeq = new EaGenerateSalesOrderCodeSeqXbjRspBO();
        try {
            String eaPurchaserOrderCode;
            String eaSaleOrderCode;
            OrderProfessionalOrganizationXbjPO orderProfessionalOrganization = this.orderProfessionalOrganizationXbjMapper.qryOrderProfessional(professionalOrganizationId);
            if (null != orderProfessionalOrganization && StringUtils.isNotBlank((CharSequence)orderProfessionalOrganization.getPrefix())) {
                String sequence = orderProfessionalOrganization.getPrefix() + DelFormatHelper.getNowYearAndMonth();
                Long seqId = this.sequenceXbjAtomService.getSequenceId(sequence);
                String seqCode = GenerateSaleOrderCodeXbj.getEaSaleOrderCode(seqId);
                eaSaleOrderCode = orderProfessionalOrganization.getPrefix() + "-XSDD-" + seqCode;
                eaPurchaserOrderCode = orderProfessionalOrganization.getPrefix() + "-CGDD-" + seqCode;
                if (isDebugEnabled) {
                    log.debug("\u9500\u552e\u8ba2\u5355\u548c\u91c7\u8d2d\u8ba2\u5355code\u751f\u6210\u51fa\u53c2\uff1a" + eaSaleOrderCode + "   " + eaPurchaserOrderCode);
                }
            } else {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4e13\u4e1a\u673a\u6784\u5bf9\u5e94\u8f6c\u6362\u8868\u7a7a\uff01");
            }
            generateSalesOrderCodeSeq.setEaSaleOrderCode(eaSaleOrderCode);
            generateSalesOrderCodeSeq.setEaPurchaserOrderCode(eaPurchaserOrderCode);
            return generateSalesOrderCodeSeq;
        }
        catch (Exception e) {
            log.error("\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u53c2\u5f02\u5e38:" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u9500\u552e\u8ba2\u5355code\u751f\u6210\u51fa\u53c2\u5f02\u5e38");
        }
    }
}

