/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.notify.api.bo.SmsTemplate;
import com.cgd.notify.api.bo.email.EmailBO;
import com.cgd.notify.api.bo.email.EmailRequest;
import com.cgd.notify.api.bo.email.MailAddress;
import com.cgd.notify.api.bo.messageBO.SendMessageReqBO;
import com.cgd.notify.api.bo.response.Response;
import com.cgd.notify.api.bo.sms.SetSingleSmsReqBO;
import com.cgd.notify.api.constant.AlgorithmEnum;
import com.cgd.notify.api.freemarker.TemplateHandler;
import com.cgd.notify.api.service.EmailService;
import com.cgd.notify.api.service.SendMessageService;
import com.cgd.notify.api.service.SmsEmayService;
import com.cgd.order.atom.OrderSendMsgCreateLogXbjAtomService;
import com.cgd.order.atom.XbjOrderSendMsgAtomService;
import com.cgd.order.atom.bo.OrderSendMsgAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderSendMsgLogAtomXbjReqBO;
import com.cgd.order.busi.bo.OrderSendMsgBusiRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjOrderSendMsgAtomServiceImpl
implements XbjOrderSendMsgAtomService {
    private static final Log log = LogFactory.getLog(XbjOrderSendMsgAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SmsEmayService smsService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private OrderSendMsgCreateLogXbjAtomService orderSendMsgCreateLogAtomService;
    @Autowired
    private DicDictionaryService dicDictionaryService;

    @Override
    public RspInfoBO dealSendMsg(OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u8ba2\u5355\u53d1\u9001\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderSendMsgBusiReq)));
        }
        log.error((Object)("\u8ba2\u5355\u53d1\u9001\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderSendMsgBusiReq)));
        this.validateBOData(orderSendMsgBusiReq);
        RspInfoBO rspBusiBaseBO = new RspInfoBO();
        rspBusiBaseBO.setRespCode("8888");
        rspBusiBaseBO.setRespDesc("\u5931\u8d25");
        try {
            List<String> sendTypes = orderSendMsgBusiReq.getSendTypes();
            for (String sendType : sendTypes) {
                Long remindConfigureId = orderSendMsgBusiReq.getRemindConfigureId();
                if (remindConfigureId == null) {
                    rspBusiBaseBO.setRespCode("8888");
                    rspBusiBaseBO.setRespDesc("\u5931\u8d25");
                }
                OrderSendMsgBusiRspBO orderSendMsgBusiRspBO = new OrderSendMsgBusiRspBO();
                switch (sendType) {
                    case "1": {
                        orderSendMsgBusiRspBO = this.smsSend(orderSendMsgBusiReq);
                        orderSendMsgBusiRspBO.setTemplateId(orderSendMsgBusiReq.getSmsTemplateId());
                        orderSendMsgBusiRspBO.setContactInformation(orderSendMsgBusiReq.getMobile());
                        break;
                    }
                    case "2": {
                        orderSendMsgBusiRspBO = this.emailSend(orderSendMsgBusiReq);
                        orderSendMsgBusiRspBO.setTemplateId(orderSendMsgBusiReq.getEmailTemplateId());
                        orderSendMsgBusiRspBO.setContactInformation(orderSendMsgBusiReq.getEmail());
                        break;
                    }
                    case "3": {
                        orderSendMsgBusiRspBO = this.messageSend(orderSendMsgBusiReq);
                        orderSendMsgBusiRspBO.setTemplateId(orderSendMsgBusiReq.getSmsTemplateId());
                        if (!StringUtils.isBlank((CharSequence)orderSendMsgBusiReq.getMessageAccount())) {
                            orderSendMsgBusiRspBO.setContactInformation(orderSendMsgBusiReq.getMessageAccount());
                            break;
                        }
                        orderSendMsgBusiRspBO.setContactInformation(orderSendMsgBusiReq.getReceiveList().toString());
                    }
                }
                if (null != orderSendMsgBusiRspBO.getSendContext()) {
                    OrderSendMsgLogAtomXbjReqBO orderSendMsgLogAtomReqBO = new OrderSendMsgLogAtomXbjReqBO();
                    orderSendMsgLogAtomReqBO.setSendType(sendType);
                    orderSendMsgLogAtomReqBO.setTemplateId(orderSendMsgBusiRspBO.getTemplateId());
                    orderSendMsgLogAtomReqBO.setRemindConfigureId(remindConfigureId);
                    orderSendMsgLogAtomReqBO.setSendTime(new Date());
                    orderSendMsgLogAtomReqBO.setSendContext(orderSendMsgBusiRspBO.getSendContext());
                    orderSendMsgLogAtomReqBO.setContactInformation(orderSendMsgBusiRspBO.getContactInformation());
                    orderSendMsgLogAtomReqBO.setSendStatus(orderSendMsgBusiRspBO.getRespCode());
                    orderSendMsgLogAtomReqBO.setOrderCode(orderSendMsgBusiReq.getOrderCode());
                    this.orderSendMsgCreateLogAtomService.createRemindLog(orderSendMsgLogAtomReqBO);
                }
                rspBusiBaseBO.setRespCode(orderSendMsgBusiRspBO.getRespCode());
                rspBusiBaseBO.setRespDesc(orderSendMsgBusiRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error((Object)("\u8ba2\u5355\u53d1\u9001\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u5f02\u5e38" + e));
            rspBusiBaseBO.setRespCode("8888");
            rspBusiBaseBO.setRespDesc("\u5931\u8d25");
        }
        return rspBusiBaseBO;
    }

    private void validateBOData(OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq) {
        if (orderSendMsgBusiReq == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u53d1\u9001\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (orderSendMsgBusiReq.getSendTypes() == null || orderSendMsgBusiReq.getSendTypes().size() <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u53d1\u9001\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1  \u53d1\u9001\u7c7b\u578b\u3010sendTypes\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderSendMsgBusiRspBO smsSend(OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq) {
        log.error((Object)"\u53d1\u9001\u624b\u673a\u77ed\u4fe1=======start");
        OrderSendMsgBusiRspBO orderSendMsgBusiRspBO = new OrderSendMsgBusiRspBO();
        String mobile = orderSendMsgBusiReq.getMobile();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            log.error((Object)"\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return orderSendMsgBusiRspBO;
        }
        Long smsTemplateId = orderSendMsgBusiReq.getSmsTemplateId();
        if (smsTemplateId == null) {
            log.error((Object)"\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u77ed\u4fe1\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u77ed\u4fe1\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return orderSendMsgBusiRspBO;
        }
        String content = "";
        try {
            SmsTemplate smsTemplate = this.smsService.getSmsTemplate(smsTemplateId);
            content = TemplateHandler.createDoc((String)smsTemplate.getContent(), orderSendMsgBusiReq.getSmsParam());
            SetSingleSmsReqBO setSingleSmsReqBO = new SetSingleSmsReqBO();
            setSingleSmsReqBO.setAlgorithm(AlgorithmEnum.AES.getValue());
            setSingleSmsReqBO.setMobile(mobile);
            setSingleSmsReqBO.setContent(content);
            setSingleSmsReqBO.setEncode("UTF-8");
            log.error((Object)("\u77ed\u4fe1\u53d1\u9001\u5165\u53c2\uff1a" + JSON.toJSONString((Object)setSingleSmsReqBO)));
            Response response = this.smsService.setSingleSms(setSingleSmsReqBO);
            if (this.isDebugEnabled) {
                log.debug((Object)("content \uff1a" + content));
            }
            log.error((Object)("\u77ed\u4fe1\u53d1\u9001\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response)));
            if ("0000".equals(response.getRespCode())) {
                orderSendMsgBusiRspBO.setRespCode("0000");
                orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u77ed\u4fe1\u6210\u529f\uff01");
            } else {
                orderSendMsgBusiRspBO.setRespCode("8888");
                orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff01");
            }
            if (this.isDebugEnabled) {
                log.debug((Object)"\u53d1\u9001\u77ed\u4fe1=======end");
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.error((Object)"\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff01", (Throwable)e);
            }
            log.error((Object)"\u53d1\u9001\u77ed\u4fe1\u539f\u5b50\u670d\u52a1\u5931\u8d25", (Throwable)e);
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff01");
        }
        finally {
            orderSendMsgBusiRspBO.setSendContext(content);
        }
        return orderSendMsgBusiRspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderSendMsgBusiRspBO emailSend(OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq) {
        if (this.isDebugEnabled) {
            log.debug((Object)"\u53d1\u9001\u90ae\u4ef6=======start");
        }
        OrderSendMsgBusiRspBO orderSendMsgBusiRspBO = new OrderSendMsgBusiRspBO();
        String email = orderSendMsgBusiReq.getEmail();
        if (StringUtils.isBlank((CharSequence)email)) {
            if (this.isDebugEnabled) {
                log.debug((Object)"\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u7bb1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u7bb1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return orderSendMsgBusiRspBO;
        }
        Long emailTemplateId = orderSendMsgBusiReq.getEmailTemplateId();
        if (emailTemplateId == null) {
            if (this.isDebugEnabled) {
                log.debug((Object)"\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u4ef6\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u4ef6\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return orderSendMsgBusiRspBO;
        }
        try {
            EmailRequest emailRequest = new EmailRequest();
            EmailBO emailBO = new EmailBO();
            LinkedList<MailAddress> addrList = new LinkedList<MailAddress>();
            MailAddress mailAddress = new MailAddress();
            mailAddress.setAddress(email);
            addrList.add(mailAddress);
            emailBO.setSubject(orderSendMsgBusiReq.getSubject());
            emailBO.setHasAttach(false);
            emailBO.setAddress("karman3d@mail.gdwssc.com");
            emailBO.setTemplateId(emailTemplateId);
            emailBO.setParams(orderSendMsgBusiReq.getEmailParam());
            emailBO.setTo(addrList);
            emailRequest.setData((Object)emailBO);
            Response sendEmail = this.emailService.sendEmail(emailRequest);
            if (sendEmail.getRespCode().equals("0000")) {
                orderSendMsgBusiRspBO.setRespCode("0000");
                orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u6210\u529f\uff01");
            } else {
                orderSendMsgBusiRspBO.setRespCode("8888");
                orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff01");
            }
            if (this.isDebugEnabled) {
                log.debug((Object)"\u53d1\u9001\u90ae\u4ef6=======end");
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.error((Object)"\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            }
            log.error((Object)"\u53d1\u9001\u90ae\u4ef6\u539f\u5b50\u670d\u52a1\u5931\u8d25", (Throwable)e);
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff01");
        }
        finally {
            orderSendMsgBusiRspBO.setSendContext(JSONObject.toJSONString(orderSendMsgBusiReq.getEmailParam()));
        }
        return orderSendMsgBusiRspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderSendMsgBusiRspBO messageSend(OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq) {
        log.error((Object)("\u53d1\u9001\u7ad9\u5185\u4fe1=======start------\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderSendMsgBusiReq)));
        OrderSendMsgBusiRspBO orderSendMsgBusiRspBO = new OrderSendMsgBusiRspBO();
        String messageAccount = orderSendMsgBusiReq.getMessageAccount();
        if (StringUtils.isBlank((CharSequence)messageAccount) && CollectionUtils.isEmpty(orderSendMsgBusiReq.getReceiveList())) {
            log.error((Object)"\u53d1\u9001\u7ad9\u5185\u4fe1=======start");
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25-\u7ad9\u5185\u4fe1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return orderSendMsgBusiRspBO;
        }
        String content = "";
        try {
            ArrayList<Long> submitPersonList = new ArrayList<Long>();
            if (!StringUtils.isBlank((CharSequence)messageAccount)) {
                submitPersonList.add(Long.parseLong(orderSendMsgBusiReq.getMessageAccount()));
            }
            SmsTemplate smsTemplate = this.smsService.getSmsTemplate(orderSendMsgBusiReq.getSmsTemplateId());
            content = TemplateHandler.createDoc((String)smsTemplate.getContent(), orderSendMsgBusiReq.getSmsParam());
            String title = TemplateHandler.createDoc((String)smsTemplate.getName(), null);
            SendMessageReqBO sendMessageReqBO = new SendMessageReqBO();
            sendMessageReqBO.setType(XbjOrderConstants.SEND_TYPE);
            if (orderSendMsgBusiReq.getReceiveList() != null && orderSendMsgBusiReq.getReceiveList().size() > 0) {
                sendMessageReqBO.setReceiverIdList(orderSendMsgBusiReq.getReceiveList());
            } else {
                sendMessageReqBO.setReceiverIdList(submitPersonList);
            }
            sendMessageReqBO.setUserId(orderSendMsgBusiReq.getUserId());
            sendMessageReqBO.setOrderCode(orderSendMsgBusiReq.getOrderCode());
            sendMessageReqBO.setMenuType(XbjOrderConstants.SEND_MENU_TYPE);
            sendMessageReqBO.setTitle(title);
            sendMessageReqBO.setContent(content);
            sendMessageReqBO.setRemark1(orderSendMsgBusiReq.getRemark1());
            sendMessageReqBO.setRemark2(orderSendMsgBusiReq.getRemark2());
            sendMessageReqBO.setRemark3(orderSendMsgBusiReq.getRemark3());
            log.error((Object)("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)sendMessageReqBO)));
            RspBusiBaseBO rspBusiBO = this.sendMessageService.add(sendMessageReqBO);
            log.error((Object)("\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspBusiBO)));
            if ("0000".equals(rspBusiBO.getRespCode())) {
                orderSendMsgBusiRspBO.setRespCode("0000");
                orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u7ad9\u5185\u4fe1\u6210\u529f\uff01");
            } else {
                orderSendMsgBusiRspBO.setRespCode("8888");
                orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.error((Object)"\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01", (Throwable)e);
            }
            log.error((Object)"\u53d1\u9001\u7ad9\u5185\u4fe1\u539f\u5b50\u670d\u52a1\u5931\u8d25", (Throwable)e);
            orderSendMsgBusiRspBO.setRespCode("8888");
            orderSendMsgBusiRspBO.setRespDesc("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
        }
        finally {
            orderSendMsgBusiRspBO.setSendContext(content);
        }
        return orderSendMsgBusiRspBO;
    }
}

