/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.XbjQryDealServiceAtomService;
import com.cgd.order.atom.bo.XbjQryDealServiceAtomReqBO;
import com.cgd.order.atom.bo.XbjQryDealServiceAtomRspBO;
import com.cgd.order.bo.OrderDealServiceBO;
import com.cgd.order.busi.XbjQryDealServiceBusiService;
import com.cgd.order.busi.bo.XbjQryDealServiceBusiReqBO;
import com.cgd.order.busi.bo.XbjQryDealServiceBusiRspBO;
import com.cgd.order.util.DateUtil;
import com.cgd.order.util.ObjectConverToString;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjQryDealServiceBusiService")
public class XbjQryDealServiceBusiServiceImpl
implements XbjQryDealServiceBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryDealServiceBusiServiceImpl.class);
    @Autowired
    private XbjQryDealServiceAtomService xbjQryDealServiceAtomService;
    @Autowired
    private DicDictionaryService dicDictionaryService;

    public XbjQryDealServiceBusiRspBO qryDealService(XbjQryDealServiceBusiReqBO xbjQryDealServiceBusiReqBO) {
        this.verifyParam(xbjQryDealServiceBusiReqBO);
        XbjQryDealServiceBusiRspBO xbjQryDealServiceBusiRspBO = new XbjQryDealServiceBusiRspBO();
        XbjQryDealServiceAtomReqBO xbjQryDealServiceAtomReqBO = new XbjQryDealServiceAtomReqBO();
        xbjQryDealServiceAtomReqBO.setSaleOrderId(xbjQryDealServiceBusiReqBO.getSaleOrderId());
        xbjQryDealServiceAtomReqBO.setPurchaseOrderId(xbjQryDealServiceBusiReqBO.getPurchaseOrderId());
        BeanUtils.copyProperties((Object)xbjQryDealServiceBusiReqBO, (Object)((Object)xbjQryDealServiceAtomReqBO));
        XbjQryDealServiceAtomRspBO xbjQryDealServiceAtomRspBO = this.xbjQryDealServiceAtomService.qryDealService(xbjQryDealServiceAtomReqBO);
        if (!"0000".equals(xbjQryDealServiceAtomRspBO.getRespCode())) {
            xbjQryDealServiceBusiRspBO.setRespCode(xbjQryDealServiceAtomRspBO.getRespCode());
            xbjQryDealServiceBusiRspBO.setRespDesc(xbjQryDealServiceAtomRspBO.getRespDesc());
            return xbjQryDealServiceBusiRspBO;
        }
        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u539f\u5b50\u51fa\u53c2" + JSON.toJSONString((Object)xbjQryDealServiceAtomRspBO));
        OrderDealServiceBO orderDealServiceBO = xbjQryDealServiceAtomRspBO.getOrderDealServiceBO();
        BeanUtils.copyProperties((Object)orderDealServiceBO, (Object)xbjQryDealServiceBusiRspBO);
        xbjQryDealServiceBusiRspBO.setXbjAccessoryRspBOList(xbjQryDealServiceAtomRspBO.getAccessoryXbjBOList());
        this.convert(orderDealServiceBO, xbjQryDealServiceBusiRspBO);
        this.translate(orderDealServiceBO, xbjQryDealServiceBusiRspBO);
        xbjQryDealServiceBusiRspBO.setRespCode("0000");
        xbjQryDealServiceBusiRspBO.setRespDesc("\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        log.debug("\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u51fa\u53c2" + JSON.toJSONString((Object)xbjQryDealServiceBusiRspBO));
        return xbjQryDealServiceBusiRspBO;
    }

    public void convert(OrderDealServiceBO orderDealServiceBO, XbjQryDealServiceBusiRspBO xbjQryDealServiceBusiRspBO) {
        if (null == orderDealServiceBO) {
            return;
        }
        xbjQryDealServiceBusiRspBO.setProduceTime(DateUtil.dateToStrLong(orderDealServiceBO.getProduceTime()));
        xbjQryDealServiceBusiRspBO.setOrderCreateTime(DateUtil.dateToStrLong(orderDealServiceBO.getOrderCreateTime()));
        xbjQryDealServiceBusiRspBO.setOrderConfirmTime(DateUtil.dateToStrLong(orderDealServiceBO.getOrderConfirmTime()));
        xbjQryDealServiceBusiRspBO.setPayTime(DateUtil.dateToStrLong(orderDealServiceBO.getPayTime()));
        xbjQryDealServiceBusiRspBO.setApplicationTime(DateUtil.dateToStrLong(orderDealServiceBO.getApplicationTime()));
        xbjQryDealServiceBusiRspBO.setApprovalTime(DateUtil.dateToStrLong(orderDealServiceBO.getApprovalTime()));
        xbjQryDealServiceBusiRspBO.setSentTime(DateUtil.dateToStrLong(orderDealServiceBO.getSentTime()));
        try {
            xbjQryDealServiceBusiRspBO.setDealServiceFee(MoneyUtil.Long2BigDecimal((Long)orderDealServiceBO.getDealServiceFee()));
            xbjQryDealServiceBusiRspBO.setPurchaseOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderDealServiceBO.getPurchaseOrderMoney()));
            xbjQryDealServiceBusiRspBO.setSaleOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderDealServiceBO.getSaleOrderMoney()));
        }
        catch (Exception e) {
            log.debug("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u53d1\u751f\u5f02\u5e38" + e.getMessage());
        }
        xbjQryDealServiceBusiRspBO.setSaleOrderId(String.valueOf(orderDealServiceBO.getSaleOrderId()));
        xbjQryDealServiceBusiRspBO.setPurchaseOrderId(String.valueOf(orderDealServiceBO.getPurchaseOrderId()));
    }

    public void translate(OrderDealServiceBO orderDealServiceBO, XbjQryDealServiceBusiRspBO xbjQryDealServiceBusiRspBO) {
        if (null == orderDealServiceBO) {
            return;
        }
        Map orderPurchaseTypeMap = this.dicDictionaryService.getValueByCode("ORDER_PURCHASE_TYPE");
        Map saleOrderTypeMap = this.dicDictionaryService.getValueByCode("SALE_ORDER_TYPE");
        Map saleOrderBusiTypeMap = this.dicDictionaryService.getValueByCode("SALE_ORDER_BUSI_TYPE");
        Map dealServiceStatusMap = this.dicDictionaryService.getValueByCode("DEAL_SERVICE_STATUS");
        xbjQryDealServiceBusiRspBO.setSaleOrderTypeStr((String)saleOrderTypeMap.get(ObjectConverToString.objectConvert2String(orderDealServiceBO.getSaleOrderType())));
        xbjQryDealServiceBusiRspBO.setOrderPurchaseTypeStr((String)orderPurchaseTypeMap.get(ObjectConverToString.objectConvert2String(orderDealServiceBO.getOrderPurchaseType())));
        xbjQryDealServiceBusiRspBO.setSaleOrderBusiTypeStr((String)saleOrderBusiTypeMap.get(ObjectConverToString.objectConvert2String(orderDealServiceBO.getSaleOrderBusiType())));
        xbjQryDealServiceBusiRspBO.setDealServiceStatusStr((String)dealServiceStatusMap.get(ObjectConverToString.objectConvert2String(orderDealServiceBO.getDealServiceStatus())));
    }

    private void verifyParam(XbjQryDealServiceBusiReqBO xbjQryDealServiceBusiReqBO) {
        if (xbjQryDealServiceBusiReqBO == null) {
            throw new BusinessException("7777", "\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjQryDealServiceBusiReqBO.getSaleOrderId() == null) {
            throw new BusinessException("7777", "\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u9500\u552e\u8ba2\u5355\u7f16\u7801[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjQryDealServiceBusiReqBO.getPurchaseOrderId() == null) {
            throw new BusinessException("7777", "\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u91c7\u8d2d\u8ba2\u5355\u7f16\u7801[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjQryDealServiceBusiReqBO.getUseApproval() == null) {
            throw new BusinessException("7777", "\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u6267\u884c\u67e5\u8be2[useApproval]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjQryDealServiceBusiReqBO.getUseApproval().equals(1) && xbjQryDealServiceBusiReqBO.getInvalidApprovalId() == null) {
            throw new BusinessException("7777", "\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u6267\u884c\u67e5\u8be2\u4e3a1\u65f6[invalidApprovalId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

