/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GenerateCommodityInfoXbjAtomService;
import com.cgd.order.atom.bo.CommodityAttrAtomXbjReqBO;
import com.cgd.order.atom.bo.SkuInfoAtomXbjReqBO;
import com.cgd.order.dao.OrderSaleItemAttrXbjMapper;
import com.cgd.order.dao.SkuInfoXbjMapper;
import com.cgd.order.po.OrderSaleItemAttrXbjPO;
import com.cgd.order.po.SkuInfoXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GenerateCommodityInfoXbjAtomServiceImpl
implements GenerateCommodityInfoXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(GenerateCommodityInfoXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SkuInfoXbjMapper skuInfoMapper;
    @Autowired
    private OrderSaleItemAttrXbjMapper orderSaleItemAttrMapper;

    @Override
    public void generateCommodityInfo(List<SkuInfoAtomXbjReqBO> skuInfo) {
        if (isDebugEnabled) {
            log.debug("\u5546\u54c1\u4fe1\u606f\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + skuInfo);
        }
        if (null == skuInfo || skuInfo.isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4fe1\u606f\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        try {
            for (int i = 0; i < skuInfo.size(); ++i) {
                SkuInfoXbjPO record = new SkuInfoXbjPO();
                record.setSaleOrderItemId(skuInfo.get(i).getSaleOrderItemId());
                record.setSaleOrderId(skuInfo.get(i).getSaleOrderId());
                record.setPurchaserId(skuInfo.get(i).getPurchaserId());
                record.setPurchaserAccountId(skuInfo.get(i).getPurchaserAccountId());
                record.setPurchaserAccountName(skuInfo.get(i).getPurchaserAccountName());
                record.setProfessionalOrganizationId(skuInfo.get(i).getProfessionalOrganizationId());
                record.setGoodsSupplierId(skuInfo.get(i).getGoodsSupplierId());
                record.setSkuId(skuInfo.get(i).getSkuId());
                record.setSkuName(skuInfo.get(i).getSkuName());
                record.setSkuSupplierId(skuInfo.get(i).getSkuSupplierId());
                record.setSkuSupplierName(skuInfo.get(i).getSkuSupplierName());
                record.setSkuMaterialId(skuInfo.get(i).getSkuMaterialId());
                record.setSkuExtSkuId(skuInfo.get(i).getSkuExtSkuId());
                record.setSkuUpcCode(skuInfo.get(i).getSkuUpcCode());
                record.setSkuCommodityTypeId(skuInfo.get(i).getSkuCommodityTypeId());
                record.setSkuLocation(skuInfo.get(i).getSkuLocation());
                record.setSkuMainPicUrl(skuInfo.get(i).getSkuMainPicUrl());
                record.setSkuDetail(skuInfo.get(i).getSkuDetail());
                record.setSkuSaleArea(skuInfo.get(i).getSkuSaleArea());
                record.setSkuStatus(skuInfo.get(i).getSkuStatus());
                record.setSkuBrandId(skuInfo.get(i).getSkuBrandId());
                record.setSkuBrandName(skuInfo.get(i).getSkuBrandName());
                record.setSkuIsSupplierAgreement(skuInfo.get(i).getSkuIsSupplierAgreement());
                record.setSkuMarketPrice(skuInfo.get(i).getSkuMarketPrice());
                record.setSkuAgreementPrice(skuInfo.get(i).getSkuAgreementPrice());
                record.setSkuMemberPrice(skuInfo.get(i).getSkuMemberPrice());
                record.setSkuSalePrice(skuInfo.get(i).getSkuSalePrice());
                record.setSkuCurrencyType(skuInfo.get(i).getSkuCurrencyType());
                record.setCreateTime(new Date());
                List<CommodityAttrAtomXbjReqBO> commodityAttrList = skuInfo.get(i).getCommodityAttrList();
                if (null == commodityAttrList || commodityAttrList.isEmpty()) continue;
                ArrayList<OrderSaleItemAttrXbjPO> orderSaleItemAttrList = new ArrayList<OrderSaleItemAttrXbjPO>();
                for (int k = 0; k < commodityAttrList.size(); ++k) {
                    OrderSaleItemAttrXbjPO orderSaleItemAttr = new OrderSaleItemAttrXbjPO();
                    orderSaleItemAttr.setId(record.getId());
                    orderSaleItemAttr.setSaleOrderNo(skuInfo.get(i).getSaleOrderId());
                    orderSaleItemAttr.setPurchaserId(skuInfo.get(i).getPurchaserId());
                    orderSaleItemAttr.setPurchaserAccountId(skuInfo.get(i).getPurchaserAccountId());
                    orderSaleItemAttr.setPurchaserAccountName(skuInfo.get(i).getPurchaserAccountName());
                    orderSaleItemAttr.setProfessionalOrganizationId(skuInfo.get(i).getProfessionalOrganizationId());
                    orderSaleItemAttr.setGoodsSupplierId(skuInfo.get(i).getGoodsSupplierId());
                    orderSaleItemAttr.setSkuCommodityId(skuInfo.get(i).getSkuId());
                    orderSaleItemAttr.setSkuCommodityPropGrpId(commodityAttrList.get(k).getSkuCommodityPropGrpId());
                    orderSaleItemAttr.setSkuCommoditySpecId(commodityAttrList.get(k).getSkuCommoditySpecId());
                    orderSaleItemAttr.setSkuPropName(commodityAttrList.get(k).getSkuPropName());
                    orderSaleItemAttr.setSkuPropShowName(commodityAttrList.get(k).getSkuPropShowName());
                    orderSaleItemAttr.setSkuPropValue(commodityAttrList.get(k).getSkuPropValue());
                    orderSaleItemAttr.setSkuPropValueListId(commodityAttrList.get(k).getSkuPropValueListId());
                    orderSaleItemAttrList.add(orderSaleItemAttr);
                }
            }
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u5546\u54c1\u4fe1\u606f\u539f\u5b50\u670d\u52a1" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4fe1\u606f\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff01");
        }
    }
}

