/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.order.atom.InspectionCreateXbjService;
import com.cgd.order.atom.OrderReciveItemXbjService;
import com.cgd.order.atom.SequenceXbjAtomService;
import com.cgd.order.atom.bo.InspectionCreateXbjReqBO;
import com.cgd.order.atom.bo.InspectionCreateXbjRspBO;
import com.cgd.order.atom.bo.OrderReciveItemXbjReqBO;
import com.cgd.order.atom.bo.OrderReciveItemXbjRspBO;
import com.cgd.order.dao.InspectionXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.po.InspectionXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectionCreateXbjServiceImpl
implements InspectionCreateXbjService {
    private static final Logger log = LoggerFactory.getLogger(InspectionCreateXbjServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private SequenceXbjAtomService sequenceAtomService;
    private InspectionXbjMapper inspectionMapper;
    private OrderShipXbjMapper orderShipMapper;
    private OrderReciveItemXbjService orderReciveItemService;

    @Override
    public InspectionCreateXbjRspBO dealInspectionCreate(InspectionCreateXbjReqBO inspectionCreateReq) {
        InspectionCreateXbjRspBO inspectionCreateRspBO = new InspectionCreateXbjRspBO();
        try {
            OrderSaleXbjPO saleOrderInfo = inspectionCreateReq.getOrderSale();
            Long inspectionId = this.sequenceAtomService.getSequenceId("SEQ_D_INSPECTION_SN");
            InspectionXbjPO record = new InspectionXbjPO();
            record.setInspectionId(inspectionId);
            record.setPurchaseOrderId(saleOrderInfo.getPurchaseOrderId());
            record.setPurchaserId(saleOrderInfo.getPurchaserId());
            record.setPurchaseOrderCode(saleOrderInfo.getPurchaseOrderCode());
            record.setSaleOrderId(saleOrderInfo.getSaleOrderId());
            record.setSaleOrderCode(saleOrderInfo.getSaleOrderCode());
            record.setPurchaserAccountId(saleOrderInfo.getPurchaserAccountId());
            record.setPurchaserAccountName(saleOrderInfo.getPurchaserAccountName());
            record.setProfessionalOrganizationId(saleOrderInfo.getProfessionalOrganizationId());
            record.setSaleOrderType(saleOrderInfo.getSaleOrderType());
            record.setGoodsSupplierId(saleOrderInfo.getGoodsSupplierId());
            record.setCreateTime(new Date());
            record.setOperId(saleOrderInfo.getPurchaserAccountId());
            record.setDeptId(saleOrderInfo.getDeptId());
            record.setPurchaserAccountOrgId(saleOrderInfo.getPurchaserAccountOrgId());
            OrderShipXbjPO shipReq = new OrderShipXbjPO();
            shipReq.setSaleOrderId(saleOrderInfo.getSaleOrderId());
            shipReq.setShipStatus("5");
            List shipRsp = null;
            if (null != shipRsp && shipRsp.size() > 0) {
                for (OrderShipXbjPO orderShip : shipRsp) {
                    orderShip.setInspectionId(inspectionId);
                    orderShip.setModifyOperId(inspectionCreateReq.getUserId());
                    orderShip.setModifyTime(new Date());
                }
                OrderReciveItemXbjReqBO orderReciveItemReqBO = new OrderReciveItemXbjReqBO();
                orderReciveItemReqBO.setOrderShipList(shipRsp);
                orderReciveItemReqBO.setInspectionId(inspectionId);
                OrderReciveItemXbjRspBO orderReciveItemRspBO = this.orderReciveItemService.createOrderReciveItem(orderReciveItemReqBO);
                if (!orderReciveItemRspBO.getRespCode().equals("0000")) {
                    inspectionCreateRspBO.setRespCode("8888");
                    inspectionCreateRspBO.setRespDesc("\u5230\u8d27\u9a8c\u6536\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + orderReciveItemRspBO.getRespDesc());
                    return inspectionCreateRspBO;
                }
            }
            inspectionCreateRspBO.setRespCode("0000");
            inspectionCreateRspBO.setRespDesc("\u5230\u8d27\u9a8c\u6536\u5355\u751f\u6210\u539f\u5b50\u6b63\u5e38\u7ed3\u675f\uff01");
            inspectionCreateRspBO.setInspectionId(inspectionId);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u5230\u8d27\u9a8c\u6536\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e);
            }
            inspectionCreateRspBO.setRespCode("8888");
            inspectionCreateRspBO.setRespDesc("\u5230\u8d27\u9a8c\u6536\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e);
        }
        return inspectionCreateRspBO;
    }

    public void setSequenceAtomService(SequenceXbjAtomService sequenceAtomService) {
        this.sequenceAtomService = sequenceAtomService;
    }

    public void setOrderShipMapper(OrderShipXbjMapper orderShipMapper) {
        this.orderShipMapper = orderShipMapper;
    }

    public void setOrderReciveItemService(OrderReciveItemXbjService orderReciveItemService) {
        this.orderReciveItemService = orderReciveItemService;
    }

    public void setInspectionMapper(InspectionXbjMapper inspectionMapper) {
        this.inspectionMapper = inspectionMapper;
    }
}

