/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.busi.XbjQryOrderServDetailBusiService;
import com.cgd.order.busi.bo.CompleteItemRspBO;
import com.cgd.order.busi.bo.XbjQryOrderServDetailReqBO;
import com.cgd.order.busi.bo.XbjQryOrderServDetailRspBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderItemRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderServCompleteItemXbjMapper;
import com.cgd.order.dao.OrderServCompleteXbjMapper;
import com.cgd.order.dao.OrderServInspectionItemXbjMapper;
import com.cgd.order.intfce.bo.XbjAccessoryBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.OrderServCompleteItemXbjPO;
import com.cgd.order.po.OrderServCompleteXbjPO;
import com.cgd.order.po.OrderServInspectionItemXbjPO;
import com.cgd.order.util.DateUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQryOrderServDetailBusiServiceImpl
implements XbjQryOrderServDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderServDetailBusiService.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private OrderServCompleteXbjMapper orderServXbjMapper;
    private OrderServCompleteItemXbjMapper orderServItemXbjMapper;
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderServInspectionItemXbjMapper orderServInspectionItemXbjMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;

    public void setOrderServXbjMapper(OrderServCompleteXbjMapper orderServXbjMapper) {
        this.orderServXbjMapper = orderServXbjMapper;
    }

    public void setOrderServItemXbjMapper(OrderServCompleteItemXbjMapper orderServItemXbjMapper) {
        this.orderServItemXbjMapper = orderServItemXbjMapper;
    }

    public void setAccessoryXbjMapper(AccessoryXbjMapper accessoryXbjMapper) {
        this.accessoryXbjMapper = accessoryXbjMapper;
    }

    public XbjQryOrderServDetailRspBO selectServInspectionDetail(XbjQryOrderServDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2servCompleteOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        XbjQryOrderServDetailRspBO rspBo = new XbjQryOrderServDetailRspBO();
        try {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            ArrayList<CompleteItemRspBO> completeItemRspBOList = new ArrayList<CompleteItemRspBO>();
            OrderServCompleteItemXbjPO orderServItemPO = new OrderServCompleteItemXbjPO();
            if (!StringUtils.isEmpty((CharSequence)reqBO.getServCompleteOrderId())) {
                ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                OrderServCompleteXbjPO orderServ = this.orderServXbjMapper.getModelById(Long.valueOf(reqBO.getServCompleteOrderId()));
                if (orderServ != null) {
                    orderServItemPO.setServCompleteOrderId(orderServ.getServCompleteOrderId());
                    rspBo.setOpenDateStr(DateUtil.dateToStrLong(orderServ.getOpenDate()));
                    rspBo.setServCompleteOrderId(String.valueOf(orderServ.getServCompleteOrderId()));
                    rspBo.setServCompleteOrderCode(orderServ.getServCompleteOrderCode());
                    rspBo.setOpenOrderNo(orderServ.getOpenOrderNo());
                    rspBo.setServRelaName(orderServ.getConstrRelaName());
                    rspBo.setServRelaPhone(orderServ.getConstrRelaPhone());
                    rspBo.setServStatus(orderServ.getServStatus() + "");
                    Map servStatusMap = this.dicDictionaryService.getValueByCode("SERV_SHIP_STATUS");
                    if (servStatusMap != null) {
                        rspBo.setServStatusName((String)servStatusMap.get(orderServ.getServStatus() + ""));
                    }
                    AccessoryXbjPO accessoryPO = new AccessoryXbjPO();
                    accessoryPO.setObjectId((long)orderServ.getServCompleteOrderId());
                    accessoryPO.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.SERV_COMPLETE);
                    List<AccessoryAtomXbjRspBO> accessoryXbjPOlist = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(accessoryPO.getObjectId(), accessoryPO.getObjectType());
                    if (accessoryXbjPOlist != null) {
                        for (AccessoryAtomXbjRspBO accessory : accessoryXbjPOlist) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        rspBo.setDownLoadFiles(accessoryBOList);
                    }
                }
            } else if (reqBO.getPurchaseOrderId() != null || reqBO.getSaleOrderId() != null) {
                Serializable po;
                Integer orderType = null;
                if (reqBO.getSaleOrderId() != null) {
                    orderServItemPO.setSaleOrderId(reqBO.getSaleOrderId());
                    po = this.orderSaleXbjMapper.getModelById(reqBO.getSaleOrderId());
                    if (po == null) {
                        throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    orderServItemPO.setSaleOrderId(((OrderSaleXbjPO)po).getSaleOrderId());
                    orderServItemPO.setPurchaseOrderId(((OrderSaleXbjPO)po).getPurchaseOrderId());
                    orderType = ((OrderSaleXbjPO)po).getOrderType();
                }
                if (reqBO.getPurchaseOrderId() != null) {
                    po = this.orderPurchaseXbjMapper.getModelById(reqBO.getPurchaseOrderId());
                    if (po == null) {
                        throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    orderServItemPO.setPurchaseOrderId(((OrderPurchaseXbjPO)po).getPurchaseOrderId());
                    orderServItemPO.setSaleOrderId(((OrderPurchaseXbjPO)po).getSaleOrderId());
                    orderType = ((OrderPurchaseXbjPO)po).getOrderType();
                }
                OrderPurchaseItemXbjPO condition = new OrderPurchaseItemXbjPO();
                condition.setPurchaseOrderId((long)reqBO.getPurchaseOrderId());
                List<OrderPurchaseItemXbjPO> orderPurchaseItemList = this.orderPurchaseItemXbjMapper.getList(condition);
                ArrayList<XbjQuerySaleOrderItemRspBO> rspList = new ArrayList<XbjQuerySaleOrderItemRspBO>();
                for (OrderPurchaseItemXbjPO ItemPO : orderPurchaseItemList) {
                    OrderServInspectionItemXbjPO orderReciveItemCondition = new OrderServInspectionItemXbjPO();
                    orderReciveItemCondition.setPurchaseOrderItemId(ItemPO.getPurchaseOrderItemId());
                    List<OrderServInspectionItemXbjPO> OrderReceiveItemList = this.orderServInspectionItemXbjMapper.getList(orderReciveItemCondition);
                    BigDecimal acceptanceCount = BigDecimal.valueOf(0L);
                    for (OrderServInspectionItemXbjPO itemPO : OrderReceiveItemList) {
                        acceptanceCount = acceptanceCount.add(itemPO.getOnceAcceptanceCount());
                        if (!this.isDebugEnabled.booleanValue()) continue;
                        log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u5df2\u9a8c\u6536\u6570\u91cfacceptanceCount\u5faa\u73af:" + acceptanceCount);
                    }
                    if (this.isDebugEnabled.booleanValue()) {
                        log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u5df2\u9a8c\u6536\u6570\u91cfacceptanceCount\u5168\u90e8:" + acceptanceCount);
                    }
                    XbjQuerySaleOrderItemRspBO rspBO = new XbjQuerySaleOrderItemRspBO();
                    BeanUtils.copyProperties((Object)ItemPO, (Object)rspBo);
                    rspBO.setSaleOrderItemId(ItemPO.getSaleOrderItemId() + "");
                    rspBO.setPurchaseOrderItemId(ItemPO.getPurchaseOrderItemId());
                    rspBO.setAcceptanceCount(acceptanceCount);
                    rspBO.setPurchaseCount(ItemPO.getPurchaseCount());
                    if (orderType == XbjOrderConstants.SALE_ORDER_TYPE.SINGLE) {
                        BigDecimal maxAcceptanceCount = ItemPO.getPurchaseCount().multiply(BigDecimal.valueOf(1.2));
                        if (this.isDebugEnabled.booleanValue()) {
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfmaxAcceptanceCount\u5168\u90e8:" + maxAcceptanceCount);
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfItemPO.getPurchaseCount()\u5168\u90e8:" + ItemPO.getPurchaseCount());
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfmaxAcceptanceCount.subtract(acceptanceCount)\u5168\u90e8:" + maxAcceptanceCount.subtract(acceptanceCount));
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfacceptanceCount\u5168\u90e8:" + acceptanceCount);
                        }
                        rspBO.setResidualAcceptanceCount(maxAcceptanceCount.subtract(acceptanceCount));
                    } else {
                        rspBO.setResidualAcceptanceCount(ItemPO.getPurchaseCount().subtract(acceptanceCount));
                    }
                    rspList.add(rspBO);
                }
                rspBo.setSaleOrderItemRspBOS(rspList);
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2servCompleteOrderId saleOrderId purchaseId \u5fc5\u4f20\u5176\u4e00");
            }
            List<OrderServCompleteItemXbjPO> servItemList = this.orderServItemXbjMapper.getListPage(orderServItemPO, (Page<OrderServCompleteItemXbjPO>)page, "");
            if (servItemList != null) {
                for (OrderServCompleteItemXbjPO servItemXbjPO : servItemList) {
                    CompleteItemRspBO completeItemRspBO = new CompleteItemRspBO();
                    BeanUtils.copyProperties((Object)completeItemRspBO, (Object)servItemXbjPO);
                    completeItemRspBO.setOpenDate(DateUtil.dateToStrLong(servItemXbjPO.getOpenDate()));
                    completeItemRspBO.setFinishDate(DateUtil.dateToStrLong(servItemXbjPO.getFinishDate()));
                    completeItemRspBO.setOnceCompleteCount(servItemXbjPO.getOnceCompleteCount());
                    completeItemRspBO.setSellingPrice(MoneyUtil.Long2BigDecimal((Long)servItemXbjPO.getSellingPrice()));
                    completeItemRspBO.setOpenOrderNo(servItemXbjPO.getOpenOrderNo());
                    OrderPurchaseItemXbjPO itemXbjPO = this.orderPurchaseItemXbjMapper.getModelById(Long.parseLong(completeItemRspBO.getPurchaseOrderItemId()));
                    completeItemRspBO.setOrderCount(itemXbjPO.getPurchaseCount() + "");
                    completeItemRspBOList.add(completeItemRspBO);
                }
            }
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRows(completeItemRspBOList);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5386\u53f2\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u51fa\u53c2BO:" + rspBo.toString());
        }
        return rspBo;
    }
}

