/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.ChkSKUFromInterService;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.bo.BusiChkSKUReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiChkSKURspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiChkSKURspVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.BusinessException;
import com.ohaotian.plugin.base.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChkSKUFromInterServiceImpl
implements ChkSKUFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(ChkSKUFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiChkSKURspBO chkSKU(BusiChkSKUReqBO busiChkSKUReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiChkSKUReqBO.toString());
        }
        BusiChkSKURspBO busiChkSKURspBO = new BusiChkSKURspBO();
        if (busiChkSKUReqBO.getSkuIds().size() > 100) {
            busiChkSKURspBO.setRespCode("RSP_CODE_SKU_NUM_MORE");
            busiChkSKURspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u83b7\u53d6\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u4fe1\u606f\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
            return busiChkSKURspBO;
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String reqStr = this.initReqStr(busiChkSKUReqBO, existSkuIds);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiChkSKUReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_CHECK_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_CHECK_URL") + "]");
                busiChkSKURspBO.setRespCode(null);
                busiChkSKURspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u670d\u52a1\u5931\u8d25");
                return busiChkSKURspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                busiChkSKURspBO.setRespCode("RSP_CODE_THREE_DATA_NULL");
                busiChkSKURspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiChkSKURspBO;
            }
            busiChkSKURspBO = this.resolveRspMsg(returnString, existSkuIds);
            return busiChkSKURspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((CharSequence)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                busiChkSKURspBO.setRespCode(resultCode);
                busiChkSKURspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1:" + e.getMessage());
                return busiChkSKURspBO;
            }
            busiChkSKURspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            busiChkSKURspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return busiChkSKURspBO;
        }
    }

    private String initReqStr(BusiChkSKUReqBO busiChkSKUReqBO, List<Long> existSkuIds) {
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiChkSKUReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        for (Long inSkuId : busiChkSKUReqBO.getSkuIds()) {
            busiQryExtSkuIdReqSkuIds.add(inSkuId);
        }
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                extSkuIds.add('\"' + busiQryExtSkuIdRsp.getExtSkuId() + '\"');
            }
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                busiChkSKUReqBO.getSkuIds().remove(busiQryExtSkuIdRsp.getSkuId());
            }
            existSkuIds.addAll(busiChkSKUReqBO.getSkuIds());
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"skuIds\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private BusiChkSKURspBO resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        BusiChkSKURspBO busiChkSKURspBO = new BusiChkSKURspBO();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    BusiChkSKURspVO[] busiChkSKURspVOArr = JsonUtils.jsonStringToJavaBean(JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiChkSKURspVO[].class);
                    List<BusiChkSKURspVO> busiChkSKURspVOs = Arrays.asList(busiChkSKURspVOArr);
                    busiChkSKURspBO.setChkSKUs(busiChkSKURspVOs);
                    if (!existSkuIds.isEmpty()) {
                        String existSkuIdStr = "";
                        for (int i = 0; i < existSkuIds.size(); ++i) {
                            existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                        }
                        busiChkSKURspBO.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                    }
                    busiChkSKURspBO.setIsSuccess(Boolean.valueOf(true));
                    return busiChkSKURspBO;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + e);
                    busiChkSKURspBO.setRespCode(null);
                    busiChkSKURspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
                    return busiChkSKURspBO;
                }
            }
            logger.info("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
            busiChkSKURspBO.setRespCode(null);
            busiChkSKURspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
            return busiChkSKURspBO;
        }
        logger.info("\u67e5\u8be2\u5546\u54c1\u53ef\u552e\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u53ef\u552e\u9a8c\u8bc1\u670d\u52a1\uff1a" + jsonObject.get((Object)"resultMessage"));
        busiChkSKURspBO.setRespCode(null);
        busiChkSKURspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        return busiChkSKURspBO;
    }
}

