/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySKUFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKURspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceReqBO;
import com.cgd.electricitysupplier.busi.vo.ParamEntity;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.BusinessException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySKUFromInterServiceImpl
implements QrySKUFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiQrySKURspBO qrySKUInfo(BusiQrySKUReqBO busiQrySKUReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiQrySKUReqBO.toString());
        }
        BusiQrySKURspBO busiQrySKURspBO = new BusiQrySKURspBO();
        ArrayList imgInfoList = new ArrayList();
        if (null == busiQrySKUReqBO.getSupplierId()) {
            busiQrySKURspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
            busiQrySKURspBO.setRespDesc("\u67e5\u8be2SKU\u8be6\u60c5\u4fe1\u606f\u4e1a\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            return busiQrySKURspBO;
        }
        if (null != busiQrySKUReqBO.getIsExtSkuId()) {
            if (busiQrySKUReqBO.getIsExtSkuId().booleanValue()) {
                if (null == busiQrySKUReqBO.getExtSkuId()) {
                    busiQrySKURspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
                    busiQrySKURspBO.setRespDesc("\u67e5\u8be2SKU\u8be6\u60c5\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5546\u54c1extSkuId[extSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
                    return busiQrySKURspBO;
                }
            } else if (null == busiQrySKUReqBO.getSkuId()) {
                busiQrySKURspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
                busiQrySKURspBO.setRespDesc("\u67e5\u8be2SKU\u8be6\u60c5\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5546\u54c1skuId[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
                return busiQrySKURspBO;
            }
        } else if (null == busiQrySKUReqBO.getSkuId()) {
            busiQrySKURspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
            busiQrySKURspBO.setRespDesc("\u67e5\u8be2SKU\u8be6\u60c5\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5546\u54c1skuId[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            return busiQrySKURspBO;
        }
        busiQrySKUReqBO.setIsShow(Boolean.valueOf(false));
        String reqStr = this.initReqStr(busiQrySKUReqBO);
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySKUReqBO.getSupplierId());
        if (1L == busiQrySKUReqBO.getSupplierId()) {
            this.getJdSKUDetailsByESB(busiQrySKURspBO, reqStr, hsn);
            this.getJdSKUPriceByESB(busiQrySKURspBO, busiQrySKUReqBO, hsn);
        } else {
            this.getOthSupSKUDetailsByESB(busiQrySKURspBO, reqStr, hsn);
            this.getOthSupSKUPriceByESB(busiQrySKURspBO, busiQrySKUReqBO, hsn);
        }
        return busiQrySKURspBO;
    }

    private void getJdSKUPriceByESB(BusiQrySKURspBO busiQrySKURspBO, BusiQrySKUReqBO busiQrySKUReqBO, String hsn) {
        JSONObject jsonObject = this.getSKUPriceObjectByESB(busiQrySKURspBO, busiQrySKUReqBO, hsn);
        String priceRspCode = String.valueOf(jsonObject.get((Object)"resultCode"));
        if (jsonObject.containsKey((Object)"resultMessage")) {
            String string = String.valueOf(jsonObject.get((Object)"resultMessage"));
        }
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            JSONArray result;
            BigDecimal negoPriceD = null;
            BigDecimal jdPriceD = null;
            if (jsonObject.get((Object)"result") != null && !"[]".equals(jsonObject.get((Object)"result")) && !"".equals(jsonObject.get((Object)"result")) && (result = (JSONArray)jsonObject.get((Object)"result")) != null && result.size() > 0) {
                JSONObject js = (JSONObject)result.get(0);
                if (js.get((Object)"price") != null) {
                    Object price = js.get((Object)"price");
                    negoPriceD = new BigDecimal(price.toString());
                    negoPriceD = negoPriceD.setScale(2, 4);
                    busiQrySKURspBO.setNegoPrice(negoPriceD);
                }
                if (js.get((Object)"ecPrice") != null) {
                    Object jdPrice = js.get((Object)"ecPrice");
                    jdPriceD = new BigDecimal(jdPrice.toString());
                    jdPriceD = jdPriceD.setScale(2, 4);
                    busiQrySKURspBO.setMarketPrice(jdPriceD);
                }
                if (negoPriceD != null) {
                    busiQrySKURspBO.setMemberPrice(BigDecimal.valueOf(negoPriceD.doubleValue() * Double.parseDouble(this.prop.getProperty("JD_PRICE_PROFIT_RATE"))));
                    busiQrySKURspBO.setSellPrice(BigDecimal.valueOf(negoPriceD.doubleValue() * Double.parseDouble(this.prop.getProperty("JD_PRICE_PROFIT_RATE"))));
                    busiQrySKURspBO.setMemberPrice(busiQrySKURspBO.getMemberPrice().setScale(2, 4));
                    busiQrySKURspBO.setSellPrice(busiQrySKURspBO.getSellPrice().setScale(2, 4));
                }
            }
        }
    }

    private void getOthSupSKUPriceByESB(BusiQrySKURspBO busiQrySKURspBO, BusiQrySKUReqBO busiQrySKUReqBO, String hsn) {
        JSONObject jsonObject = this.getSKUPriceObjectByESB(busiQrySKURspBO, busiQrySKUReqBO, hsn);
        String priceRspCode = String.valueOf(jsonObject.get((Object)"resultCode"));
        if (jsonObject.containsKey((Object)"resultMessage")) {
            String string = String.valueOf(jsonObject.get((Object)"resultMessage"));
        }
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            JSONArray result;
            BigDecimal negoPriceD = null;
            BigDecimal ecPriceD = null;
            if (jsonObject.get((Object)"result") != null && !"[]".equals(jsonObject.get((Object)"result")) && !"".equals(jsonObject.get((Object)"result")) && (result = (JSONArray)jsonObject.get((Object)"result")) != null && result.size() > 0) {
                JSONObject js = (JSONObject)result.get(0);
                if (js.get((Object)"price") != null) {
                    Object price = js.get((Object)"price");
                    negoPriceD = new BigDecimal(price.toString());
                    negoPriceD = negoPriceD.setScale(2, 4);
                    busiQrySKURspBO.setNegoPrice(negoPriceD);
                }
                if (js.get((Object)"ecPrice") != null) {
                    Object ecPrice = js.get((Object)"ecPrice");
                    ecPriceD = new BigDecimal(ecPrice.toString());
                    ecPriceD = ecPriceD.setScale(2, 4);
                    busiQrySKURspBO.setMarketPrice(ecPriceD);
                }
                if (negoPriceD != null) {
                    busiQrySKURspBO.setMemberPrice(BigDecimal.valueOf(negoPriceD.doubleValue() * Double.parseDouble(this.prop.getProperty("EC_PRICE_PROFIT_RATE"))));
                    busiQrySKURspBO.setSellPrice(BigDecimal.valueOf(negoPriceD.doubleValue() * Double.parseDouble(this.prop.getProperty("EC_PRICE_PROFIT_RATE"))));
                    busiQrySKURspBO.setMemberPrice(busiQrySKURspBO.getMemberPrice().setScale(2, 4));
                    busiQrySKURspBO.setSellPrice(busiQrySKURspBO.getSellPrice().setScale(2, 4));
                }
            }
        }
    }

    private JSONObject getSKUPriceObjectByESB(BusiQrySKURspBO busiQrySKURspBO, BusiQrySKUReqBO busiQrySKUReqBO, String hsn) {
        try {
            String returnString;
            ArrayList<Long> skuIds;
            BusiQrySkuPriceReqBO busiQrySkuPriceReqBO = new BusiQrySkuPriceReqBO();
            if (null != busiQrySKUReqBO.getIsExtSkuId()) {
                if (busiQrySKUReqBO.getIsExtSkuId().booleanValue()) {
                    ArrayList<String> extSkuIds = new ArrayList<String>();
                    extSkuIds.add(busiQrySKUReqBO.getExtSkuId());
                    busiQrySkuPriceReqBO.setExtSkuIds(extSkuIds);
                    busiQrySkuPriceReqBO.setSupplierId(busiQrySKUReqBO.getSupplierId());
                    busiQrySkuPriceReqBO.setIsExtSku(Boolean.valueOf(true));
                } else {
                    skuIds = new ArrayList();
                    skuIds.add(busiQrySKUReqBO.getSkuId());
                    busiQrySkuPriceReqBO.setSkuIds(skuIds);
                    busiQrySkuPriceReqBO.setSupplierId(busiQrySKUReqBO.getSupplierId());
                    busiQrySkuPriceReqBO.setIsExtSku(Boolean.valueOf(false));
                }
            } else {
                skuIds = new ArrayList<Long>();
                skuIds.add(busiQrySKUReqBO.getSkuId());
                busiQrySkuPriceReqBO.setSkuIds(skuIds);
                busiQrySkuPriceReqBO.setSupplierId(busiQrySKUReqBO.getSupplierId());
                busiQrySkuPriceReqBO.setIsExtSku(Boolean.valueOf(false));
            }
            String reqPriceStr = this.initPriceReqStr(busiQrySkuPriceReqBO);
            String reqPriceEsbStr = ESBParamUtil.getEsbReqStr(reqPriceStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_PRICE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqPriceEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528ESB\u5546\u54c1\u4ef7\u683c\u67e5\u8be2\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_SKU_PRICE_URL") + "]");
                throw new BusinessException(null, "\u8c03\u7528ESB\u5546\u54c1\u4ef7\u683c\u67e5\u8be2\u63a5\u53e3\u5931\u8d25");
            }
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            }
            if (StringUtils.isEmpty((Object)(returnString = httpRetBean.getStr()))) {
                throw new RuntimeException("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            return jsonObject;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2SKU\u4ef7\u683c\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2SKU\u4ef7\u683c\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
    }

    private void getJdSKUDetailsByESB(BusiQrySKURspBO busiQrySKURspBO, String reqStr, String hsn) {
        try {
            JSONObject jsonObject = this.getSKUDetailsObjectByESB(busiQrySKURspBO, reqStr, hsn);
            String infoRspCode = (String)jsonObject.get((Object)"resultCode");
            if (jsonObject.containsKey((Object)"resultMessage")) {
                String string = (String)jsonObject.get((Object)"resultMessage");
            }
            if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
                JSONObject singleResult = (JSONObject)jsonObject.get((Object)"result");
                if (singleResult.get((Object)"sku") != null) {
                    busiQrySKURspBO.setSku(String.valueOf(singleResult.get((Object)"sku")));
                }
                if (singleResult.get((Object)"weight") != null) {
                    busiQrySKURspBO.setWeight(String.valueOf(singleResult.get((Object)"weight")));
                }
                if (singleResult.get((Object)"imagePath") != null) {
                    busiQrySKURspBO.setImagePath(String.valueOf(singleResult.get((Object)"imagePath")));
                }
                if (singleResult.get((Object)"state") != null) {
                    busiQrySKURspBO.setState(Integer.valueOf(String.valueOf(singleResult.get((Object)"state"))));
                }
                if (singleResult.get((Object)"brandName") != null) {
                    busiQrySKURspBO.setBrandName(String.valueOf(singleResult.get((Object)"brandName")));
                }
                if (singleResult.get((Object)"brandPic") != null) {
                    busiQrySKURspBO.setBrandPic(String.valueOf(singleResult.get((Object)"brandPic")));
                }
                if (singleResult.get((Object)"name") != null) {
                    busiQrySKURspBO.setName(String.valueOf(singleResult.get((Object)"name")));
                }
                if (singleResult.get((Object)"productArea") != null) {
                    busiQrySKURspBO.setProductArea(String.valueOf(singleResult.get((Object)"productArea")));
                }
                if (singleResult.get((Object)"upc") != null) {
                    busiQrySKURspBO.setUpc(String.valueOf(singleResult.get((Object)"upc")));
                }
                if (singleResult.get((Object)"saleUnit") != null) {
                    busiQrySKURspBO.setSaleUnit(String.valueOf(singleResult.get((Object)"saleUnit")));
                }
                if (singleResult.get((Object)"category") != null) {
                    JSONArray jsonArray = (JSONArray)singleResult.get((Object)"category");
                    List categorys = jsonArray.toJavaList(String.class);
                    busiQrySKURspBO.setCategories(categorys);
                }
                if (singleResult.get((Object)"moq") != null) {
                    busiQrySKURspBO.setMoq(Integer.valueOf(String.valueOf(singleResult.get((Object)"moq"))));
                }
                if (singleResult.get((Object)"mfgSku") != null) {
                    busiQrySKURspBO.setMfgSku(String.valueOf(singleResult.get((Object)"mfgSku")));
                }
                if (singleResult.get((Object)"deliveryTime") != null) {
                    busiQrySKURspBO.setDeliveryTime(String.valueOf(singleResult.get((Object)"deliveryTime")));
                }
                if (singleResult.get((Object)"introduction") != null) {
                    busiQrySKURspBO.setIntroduction(String.valueOf(singleResult.get((Object)"introduction")));
                }
                if (singleResult.get((Object)"wareQD") != null) {
                    busiQrySKURspBO.setWareQD(String.valueOf(singleResult.get((Object)"wareQD")));
                }
                HashMap paramMap = new HashMap();
                if (singleResult.containsKey((Object)"jdParam") && singleResult.get((Object)"jdParam") != null) {
                    String html = String.valueOf(singleResult.get((Object)"jdParam"));
                    Document doc = Jsoup.parseBodyFragment((String)html);
                    Elements trs = doc.select("table").select("tr");
                    HashMap<String, String> subParamMap = new HashMap<String, String>();
                    String subParamHead = null;
                    for (int i = 0; i < trs.size(); ++i) {
                        Elements tds;
                        if (((Element)trs.get(i)).select("th") != null && subParamHead == null) {
                            subParamHead = ((Element)((Element)trs.get(i)).select("th").get(0)).text();
                        }
                        if (((Element)trs.get(i)).select("th") != null && subParamHead != null || i == trs.size()) {
                            paramMap.put(subParamHead, subParamMap);
                            if (((Element)trs.get(i)).select("th").size() != 0) {
                                subParamHead = ((Element)((Element)trs.get(i)).select("th").get(0)).text();
                                subParamMap = new HashMap();
                            }
                        }
                        if ((tds = ((Element)trs.get(i)).select("td")).size() != 2) continue;
                        subParamMap.put(((Element)tds.get(0)).text(), ((Element)tds.get(1)).text());
                    }
                }
                paramMap.putAll(singleResult);
                busiQrySKURspBO.setAttribute(paramMap);
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
    }

    private void getOthSupSKUDetailsByESB(BusiQrySKURspBO busiQrySKURspBO, String reqStr, String hsn) {
        try {
            JSONObject jsonObject = this.getSKUDetailsObjectByESB(busiQrySKURspBO, reqStr, hsn);
            String infoRspCode = (String)jsonObject.get((Object)"resultCode");
            if (jsonObject.containsKey((Object)"resultMessage")) {
                String string = (String)jsonObject.get((Object)"resultMessage");
            }
            if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
                JSONObject singleResult = (JSONObject)jsonObject.get((Object)"result");
                if (singleResult.get((Object)"sku") != null) {
                    busiQrySKURspBO.setSku(String.valueOf(singleResult.get((Object)"sku")));
                }
                if (singleResult.get((Object)"weight") != null) {
                    busiQrySKURspBO.setWeight(String.valueOf(singleResult.get((Object)"weight")));
                }
                if (singleResult.get((Object)"imagePath") != null) {
                    busiQrySKURspBO.setImagePath(String.valueOf(singleResult.get((Object)"imagePath")));
                }
                if (singleResult.get((Object)"state") != null) {
                    busiQrySKURspBO.setState(Integer.valueOf(String.valueOf(singleResult.get((Object)"state"))));
                }
                if (singleResult.get((Object)"brandName") != null) {
                    busiQrySKURspBO.setBrandName(String.valueOf(singleResult.get((Object)"brandName")));
                }
                if (singleResult.get((Object)"brandPic") != null) {
                    busiQrySKURspBO.setBrandPic(String.valueOf(singleResult.get((Object)"brandPic")));
                }
                if (singleResult.get((Object)"name") != null) {
                    busiQrySKURspBO.setName(String.valueOf(singleResult.get((Object)"name")));
                }
                if (singleResult.get((Object)"productArea") != null) {
                    busiQrySKURspBO.setProductArea(String.valueOf(singleResult.get((Object)"productArea")));
                }
                if (singleResult.get((Object)"upc") != null) {
                    busiQrySKURspBO.setUpc(String.valueOf(singleResult.get((Object)"upc")));
                }
                if (singleResult.get((Object)"saleUnit") != null) {
                    busiQrySKURspBO.setSaleUnit(String.valueOf(singleResult.get((Object)"saleUnit")));
                }
                if (singleResult.get((Object)"category") != null) {
                    JSONArray jsonArray = (JSONArray)singleResult.get((Object)"category");
                    List categorys = jsonArray.toJavaList(String.class);
                    busiQrySKURspBO.setCategories(categorys);
                }
                if (singleResult.get((Object)"moq") != null) {
                    busiQrySKURspBO.setMoq(Integer.valueOf(String.valueOf(singleResult.get((Object)"moq"))));
                }
                if (singleResult.get((Object)"mfgSku") != null) {
                    busiQrySKURspBO.setMfgSku(String.valueOf(singleResult.get((Object)"mfgSku")));
                }
                if (singleResult.get((Object)"deliveryTime") != null) {
                    busiQrySKURspBO.setDeliveryTime(String.valueOf(singleResult.get((Object)"deliveryTime")));
                }
                if (singleResult.get((Object)"introduction") != null) {
                    busiQrySKURspBO.setIntroduction(String.valueOf(singleResult.get((Object)"introduction")));
                }
                if (singleResult.get((Object)"wareQD") != null) {
                    busiQrySKURspBO.setWareQD(String.valueOf(singleResult.get((Object)"wareQD")));
                }
                if (singleResult.get((Object)"param") != null) {
                    JSONArray jarr = (JSONArray)singleResult.get((Object)"param");
                    ParamEntity[] param = new ParamEntity[jarr.size()];
                    int index = 0;
                    for (Object obj : jarr) {
                        JSONObject o = (JSONObject)obj;
                        ParamEntity supParam = new ParamEntity();
                        if (o.getString("attrCode") != null) {
                            supParam.setAttrCode(o.getString("attrCode"));
                        }
                        if (o.getString("attrGroupCode") != null) {
                            supParam.setAttrGroupCode(o.getString("attrGroupCode"));
                        }
                        if (o.getString("attrGroupName") != null) {
                            supParam.setAttrGroupName(o.getString("attrGroupName"));
                        }
                        if (o.getString("attrGroupSeq") != null) {
                            supParam.setAttrGroupSeq(o.getString("attrGroupSeq"));
                        }
                        if (o.getString("attrName") != null) {
                            supParam.setAttrName(o.getString("attrName"));
                        }
                        if (o.getString("attrSeq") != null) {
                            supParam.setAttrSeq(o.getString("attrSeq"));
                        }
                        if (o.getString("attrValue") != null) {
                            supParam.setAttrValue(o.getString("attrValue"));
                        }
                        param[index] = supParam;
                        ++index;
                    }
                    busiQrySKURspBO.setParam(param);
                }
                HashMap paramMap = new HashMap();
                paramMap.putAll(singleResult);
                busiQrySKURspBO.setAttribute(paramMap);
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
    }

    private JSONObject getSKUDetailsObjectByESB(BusiQrySKURspBO busiQrySKURspBO, String reqStr, String hsn) {
        try {
            String returnString;
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_DETAIL_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u83b7\u53d6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_SKU_DETAIL_URL") + "]");
                throw new BusinessException(null, "\u83b7\u53d6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
            }
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            }
            if (StringUtils.isEmpty((Object)(returnString = httpRetBean.getStr()))) {
                throw new RuntimeException("\u67e5\u8be2\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            return jsonObject;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
    }

    private String initReqStr(BusiQrySKUReqBO busiQrySKUReqBO) {
        if (null != busiQrySKUReqBO.getIsExtSkuId() && busiQrySKUReqBO.getIsExtSkuId().booleanValue()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append("\"" + busiQrySKUReqBO.getExtSkuId() + "\"").append(",").append("\"priceFloatRate\":").append(busiQrySKUReqBO.getPriceFloatRate()).append(",").append("\"isShow\":").append(busiQrySKUReqBO.getIsShow()).append("}");
            return sb.toString();
        }
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySKUReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        busiQryExtSkuIdReqSkuIds.add(busiQrySKUReqBO.getSkuId());
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append("\"" + ((BusiQryExtSkuIdRsp)busiQryExtSkuIdRspBO.getResult().get(0)).getExtSkuId().toString() + "\"").append(",").append("\"priceFloatRate\":").append(busiQrySKUReqBO.getPriceFloatRate()).append(",").append("\"isShow\":").append(busiQrySKUReqBO.getIsShow()).append("}");
            return sb.toString();
        }
        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2SKU\u4ef7\u683c\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1" + busiQryExtSkuIdRspBO.getRespDesc());
    }

    private String initPriceReqStr(BusiQrySkuPriceReqBO busiQrySkuPriceReqBO) {
        if (null != busiQrySkuPriceReqBO.getIsExtSku() && busiQrySkuPriceReqBO.getIsExtSku().booleanValue()) {
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (String extSkuId : busiQrySkuPriceReqBO.getExtSkuIds()) {
                extSkuIds.add("\"" + extSkuId + "\"");
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySkuPriceReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        for (Long inSkuId : busiQrySkuPriceReqBO.getSkuIds()) {
            busiQryExtSkuIdReqSkuIds.add(inSkuId);
        }
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                extSkuIds.add("\"" + busiQryExtSkuIdRsp.getExtSkuId() + "\"");
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2SKU\u4ef7\u683c\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1" + busiQryExtSkuIdRspBO.getRespDesc());
    }
}

