/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySKUImageFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUImageReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUImageRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySKUImageRspVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.BusinessException;
import com.ohaotian.plugin.base.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySKUImageFromInterServiceImpl
implements QrySKUImageFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUImageFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiQrySKUImageRspBO qrySKUImage(BusiQrySKUImageReqBO busiQrySKUImageReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySKUImageReqBO.toString());
        }
        BusiQrySKUImageRspBO busiQrySKUImageRspBO = new BusiQrySKUImageRspBO();
        if (null == busiQrySKUImageReqBO.getSupplierId()) {
            busiQrySKUImageRspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
            busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            return busiQrySKUImageRspBO;
        }
        if (null != busiQrySKUImageReqBO.getIsExtSkuId()) {
            if (busiQrySKUImageReqBO.getIsExtSkuId().booleanValue()) {
                if (busiQrySKUImageReqBO.getExtSkuIds().isEmpty()) {
                    busiQrySKUImageRspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
                    busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u5916\u90e8skuId\u96c6\u5408[extSkuIds]\u4e0d\u80fd\u4e3a\u7a7a");
                    return busiQrySKUImageRspBO;
                }
                if (busiQrySKUImageReqBO.getExtSkuIds().size() > 100) {
                    busiQrySKUImageRspBO.setRespCode("RSP_CODE_SKU_NUM_MORE");
                    busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
                    return busiQrySKUImageRspBO;
                }
            } else {
                if (busiQrySKUImageReqBO.getSkuIds().isEmpty()) {
                    busiQrySKUImageRspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
                    busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u5185\u90e8skuId\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
                    return busiQrySKUImageRspBO;
                }
                if (busiQrySKUImageReqBO.getSkuIds().size() > 100) {
                    busiQrySKUImageRspBO.setRespCode("RSP_CODE_SKU_NUM_MORE");
                    busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
                    return busiQrySKUImageRspBO;
                }
            }
        } else {
            if (busiQrySKUImageReqBO.getSkuIds().isEmpty()) {
                busiQrySKUImageRspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
                busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u5185\u90e8skuId\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
                return busiQrySKUImageRspBO;
            }
            if (busiQrySKUImageReqBO.getSkuIds().size() > 100) {
                busiQrySKUImageRspBO.setRespCode("RSP_CODE_SKU_NUM_MORE");
                busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
                return busiQrySKUImageRspBO;
            }
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String reqStr = this.initReqStr(busiQrySKUImageReqBO, existSkuIds);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySKUImageReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_IMG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u4e0b\u53d1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_SKU_IMG_URL") + "]");
                busiQrySKUImageRspBO.setRespCode(null);
                busiQrySKUImageRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u5931\u8d25");
                return busiQrySKUImageRspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUImageRspBO.setRespCode("RSP_CODE_THREE_DATA_NULL");
                busiQrySKUImageRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUImageRspBO;
            }
            busiQrySKUImageRspBO = this.resolveRspMsg(returnString, existSkuIds);
            return busiQrySKUImageRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                busiQrySKUImageRspBO.setRespCode(resultCode);
                busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1:" + e.getMessage());
                return busiQrySKUImageRspBO;
            }
            busiQrySKUImageRspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            busiQrySKUImageRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u5931\u8d25");
            return busiQrySKUImageRspBO;
        }
    }

    private String initReqStr(BusiQrySKUImageReqBO busiQrySKUImageReqBO, List<Long> existSkuIds) {
        if (null != busiQrySKUImageReqBO.getIsExtSkuId() && busiQrySKUImageReqBO.getIsExtSkuId().booleanValue()) {
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (String extSkuId : busiQrySKUImageReqBO.getExtSkuIds()) {
                extSkuIds.add('\"' + extSkuId + '\"');
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySKUImageReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        for (Long inSkuId : busiQrySKUImageReqBO.getSkuIds()) {
            busiQryExtSkuIdReqSkuIds.add(inSkuId);
        }
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                extSkuIds.add('\"' + busiQryExtSkuIdRsp.getExtSkuId() + '\"');
            }
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                busiQrySKUImageReqBO.getSkuIds().remove(busiQryExtSkuIdRsp.getSkuId());
            }
            existSkuIds.addAll(busiQrySKUImageReqBO.getSkuIds());
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private BusiQrySKUImageRspBO resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        BusiQrySKUImageRspBO busiQrySKUImageRspBO = new BusiQrySKUImageRspBO();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    BusiQrySKUImageRspVO[] busiQrySKUImageRspVOArr = JsonUtils.jsonStringToJavaBean(JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySKUImageRspVO[].class);
                    List<BusiQrySKUImageRspVO> busiQrySKUImageRspVOs = Arrays.asList(busiQrySKUImageRspVOArr);
                    busiQrySKUImageRspBO.setSkuImages(busiQrySKUImageRspVOs);
                    if (!StringUtils.isEmpty((Object)JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")))) {
                        logger.info("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587" + JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                        busiQrySKUImageRspBO.setResultMessage(JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                    }
                    if (!existSkuIds.isEmpty()) {
                        String existSkuIdStr = "";
                        for (int i = 0; i < existSkuIds.size(); ++i) {
                            existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                        }
                        busiQrySKUImageRspBO.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                    }
                    busiQrySKUImageRspBO.setIsSuccess(Boolean.valueOf(true));
                    return busiQrySKUImageRspBO;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + e);
                    busiQrySKUImageRspBO.setRespCode(null);
                    busiQrySKUImageRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
                    return busiQrySKUImageRspBO;
                }
            }
            logger.info("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            busiQrySKUImageRspBO.setRespCode(null);
            busiQrySKUImageRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            return busiQrySKUImageRspBO;
        }
        logger.info("\u67e5\u8be2\u5546\u54c1\u8f6e\u64ad\u56fe\u7247\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6240\u6709\u56fe\u7247\u4fe1\u606f\u5931\u8d25\uff1a" + jsonObject.get((Object)"resultMessage"));
        busiQrySKUImageRspBO.setRespCode(null);
        busiQrySKUImageRspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        return busiQrySKUImageRspBO;
    }
}

