/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.DelMsgFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiDelMsgReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiDelMsgRspBO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import java.net.URI;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DelMsgFromInterServiceImpl
implements DelMsgFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(DelMsgFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public BusiDelMsgRspBO delMsgPush(BusiDelMsgReqBO busiDelMsgReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiDelMsgReqBO.toString());
        }
        HttpRetBean httpRetBean = null;
        BusiDelMsgRspBO busiDelMsgRspBO = new BusiDelMsgRspBO();
        try {
            String reqStr = this.initReqStr(busiDelMsgReqBO);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiDelMsgReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_DELETE_MSG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u5931\u8d25" + e);
            busiDelMsgRspBO.setRespCode("RSP_CODE_CALL_THIRD_SERVICE");
            busiDelMsgRspBO.setRespDesc("\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u5931\u8d25");
            return busiDelMsgRspBO;
        }
        if (httpRetBean.getStatus() != 200) {
            logger.error("RSP_CODE_CALL_THIRD_SERVICE", (Object)("\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_DELETE_MSG_URL") + "]"));
            busiDelMsgRspBO.setRespCode(null);
            busiDelMsgRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u51fa\u9519");
            return busiDelMsgRspBO;
        }
        String returnString = httpRetBean.getStr();
        if (this.isDebugEnabled) {
            logger.debug("\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1-\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
        }
        if (StringUtils.isEmpty((Object)returnString)) {
            busiDelMsgRspBO.setRespCode("RSP_CODE_THREE_DATA_NULL");
            busiDelMsgRspBO.setRespDesc("\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return busiDelMsgRspBO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            busiDelMsgRspBO.setSuccess(((Boolean)jsonObject.get((Object)"success")).booleanValue());
            return busiDelMsgRspBO;
        }
        logger.error("\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u5931\u8d25\uff1a" + jsonObject.get((Object)"resultMessage"));
        busiDelMsgRspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
        busiDelMsgRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u5931\u8d25");
        return busiDelMsgRspBO;
    }

    private String initReqStr(BusiDelMsgReqBO busiDelMsgReqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"id\":").append("\"" + busiDelMsgReqBO.getId() + "\"").append("}");
        return sb.toString();
    }
}

