/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.dao.ESkuMapper;
import com.cgd.electricitysupplier.po.ESku;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryExtSkuIdServiceImpl
implements QryExtSkuIdService {
    private static final Logger logger = LoggerFactory.getLogger(QryExtSkuIdServiceImpl.class);
    private final Boolean isDebugEnabled = logger.isDebugEnabled();
    private ESkuMapper eSkuMapper;

    public void setESkuMapper(ESkuMapper eSkuMapper) {
        this.eSkuMapper = eSkuMapper;
    }

    public BusiQryExtSkuIdRspBO qryExtSkuId(BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO) {
        if (this.isDebugEnabled.booleanValue()) {
            logger.debug("\u83b7\u53d6\u5916\u90e8\u7535\u5546sku id\u4e1a\u52a1\u670d\u52a1\uff1a" + busiQryExtSkuIdReqBO.toString());
        }
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = new BusiQryExtSkuIdRspBO();
        try {
            List<ESku> skus = this.eSkuMapper.selectBySupIdAndSkuId(busiQryExtSkuIdReqBO.getSupplierId(), busiQryExtSkuIdReqBO.getSkuIds());
            if (null == skus || skus.size() < 0) {
                busiQryExtSkuIdRspBO.setRespCode("RSP_CODE_SKU_NOT_EXIST");
                busiQryExtSkuIdRspBO.setRespDesc("\u83b7\u53d6\u5916\u90e8\u7535\u5546sku id\u4e0d\u5b58\u5728");
                return busiQryExtSkuIdRspBO;
            }
            ArrayList<BusiQryExtSkuIdRsp> rsps = new ArrayList<BusiQryExtSkuIdRsp>();
            for (ESku sku : skus) {
                BusiQryExtSkuIdRsp rsp = new BusiQryExtSkuIdRsp();
                rsp.setSkuId(sku.getSkuId());
                rsp.setExtSkuId(sku.getExtSkuId());
                rsps.add(rsp);
            }
            busiQryExtSkuIdRspBO.setResult(rsps);
        }
        catch (Exception e) {
            busiQryExtSkuIdRspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            busiQryExtSkuIdRspBO.setRespDesc("\u83b7\u53d6\u5916\u90e8\u7535\u5546sku id\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return busiQryExtSkuIdRspBO;
        }
        return busiQryExtSkuIdRspBO;
    }
}

