/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySKUFromInterService;
import com.cgd.electricitysupplier.busi.QrySKUGiftFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUGiftReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUGiftRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKURspBO;
import com.cgd.electricitysupplier.busi.vo.GiftRspVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.BusinessException;
import com.ohaotian.plugin.base.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class QrySKUGiftFromInterServiceImpl
implements QrySKUGiftFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUGiftFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    public static final String ESB_GIFT_RESULT_CODE = "0010";
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;
    @Autowired
    private QrySKUFromInterService qrySKUFromInterService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public QrySKUFromInterService getQrySKUFromInterService() {
        return this.qrySKUFromInterService;
    }

    public void setQrySKUFromInterService(QrySKUFromInterService qrySKUFromInterService) {
        this.qrySKUFromInterService = qrySKUFromInterService;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiQrySKUGiftRspBO qrySKUGift(BusiQrySKUGiftReqBO busiQrySKUGiftReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySKUGiftReqBO.toString());
        }
        BusiQrySKUGiftRspBO busiQrySKUGiftRspBO = new BusiQrySKUGiftRspBO();
        try {
            String reqStr = this.initReqStr(busiQrySKUGiftReqBO);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySKUGiftReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_GIFT_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_SKU_GIFT_URL") + "]");
                busiQrySKUGiftRspBO.setRespCode(null);
                busiQrySKUGiftRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25");
                return busiQrySKUGiftRspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUGiftRspBO.setRespCode("RSP_CODE_THREE_DATA_NULL");
                busiQrySKUGiftRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUGiftRspBO;
            }
            busiQrySKUGiftRspBO = this.resolveRspMsg(busiQrySKUGiftReqBO, returnString);
            List giftList = busiQrySKUGiftRspBO.getGifts();
            if (giftList != null && giftList.size() > 0) {
                for (GiftRspVO giftRspVO : giftList) {
                    BusiQrySKURspBO busiQrySKURspBO = this.qrySKUInfo(busiQrySKUGiftReqBO, giftRspVO);
                    if (busiQrySKURspBO == null) continue;
                    giftRspVO.setSkuName(busiQrySKURspBO.getName());
                }
            }
            return busiQrySKUGiftRspBO;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                if (resultCode.equals("0000")) {
                    busiQrySKUGiftRspBO.setRespCode("0000");
                    busiQrySKUGiftRspBO.setRespDesc(e.getMessage());
                    return busiQrySKUGiftRspBO;
                }
                busiQrySKUGiftRspBO.setRespCode(resultCode);
                busiQrySKUGiftRspBO.setRespDesc("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1:" + e.getMessage());
                return busiQrySKUGiftRspBO;
            }
            busiQrySKUGiftRspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            busiQrySKUGiftRspBO.setRespDesc("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return busiQrySKUGiftRspBO;
        }
    }

    private BusiQrySKURspBO qrySKUInfo(BusiQrySKUGiftReqBO busiQrySKUGiftReqBO, GiftRspVO giftRspVO) {
        BusiQrySKUReqBO busiQrySKUReqBO = new BusiQrySKUReqBO();
        BusiQrySKURspBO busiQrySKURspBO = new BusiQrySKURspBO();
        busiQrySKUReqBO.setSkuId(giftRspVO.getSkuId());
        busiQrySKUReqBO.setIsExtSkuId(Boolean.valueOf(true));
        busiQrySKUReqBO.setSupplierId(busiQrySKUGiftReqBO.getSupplierId());
        busiQrySKUReqBO.setIsShow(Boolean.valueOf(false));
        String reqStr = this.initReqStr(busiQrySKUReqBO);
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySKUReqBO.getSupplierId());
        if (1L == busiQrySKUReqBO.getSupplierId()) {
            try {
                String returnString;
                String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_DETAIL_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
                if (httpRetBean.getStatus() != 200) {
                    logger.error("\u83b7\u53d6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_SKU_DETAIL_URL") + "]");
                    throw new BusinessException(null, "\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
                }
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
                }
                if (StringUtils.isEmpty((Object)(returnString = httpRetBean.getStr()))) {
                    throw new RuntimeException("\u67e5\u8be2\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                JSONObject jsonObject = JSONObject.parseObject((String)returnString);
                String infoRspCode = (String)jsonObject.get((Object)"resultCode");
                if (jsonObject.containsKey((Object)"resultMessage")) {
                    String string = (String)jsonObject.get((Object)"resultMessage");
                }
                if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
                    JSONObject singleResult = (JSONObject)jsonObject.get((Object)"result");
                    if (singleResult.get((Object)"sku") != null) {
                        busiQrySKURspBO.setSku(String.valueOf(singleResult.get((Object)"sku")));
                    }
                    if (singleResult.get((Object)"weight") != null) {
                        busiQrySKURspBO.setWeight(String.valueOf(singleResult.get((Object)"weight")));
                    }
                    if (singleResult.get((Object)"imagePath") != null) {
                        busiQrySKURspBO.setImagePath(String.valueOf(singleResult.get((Object)"imagePath")));
                    }
                    if (singleResult.get((Object)"state") != null) {
                        busiQrySKURspBO.setState(Integer.valueOf(String.valueOf(singleResult.get((Object)"state"))));
                    }
                    if (singleResult.get((Object)"brandName") != null) {
                        busiQrySKURspBO.setBrandName(String.valueOf(singleResult.get((Object)"brandName")));
                    }
                    if (singleResult.get((Object)"brandPic") != null) {
                        busiQrySKURspBO.setBrandPic(String.valueOf(singleResult.get((Object)"brandPic")));
                    }
                    if (singleResult.get((Object)"name") != null) {
                        busiQrySKURspBO.setName(String.valueOf(singleResult.get((Object)"name")));
                    }
                    if (singleResult.get((Object)"productArea") != null) {
                        busiQrySKURspBO.setProductArea(String.valueOf(singleResult.get((Object)"productArea")));
                    }
                    if (singleResult.get((Object)"upc") != null) {
                        busiQrySKURspBO.setUpc(String.valueOf(singleResult.get((Object)"upc")));
                    }
                    if (singleResult.get((Object)"saleUnit") != null) {
                        busiQrySKURspBO.setSaleUnit(String.valueOf(singleResult.get((Object)"saleUnit")));
                    }
                    if (singleResult.get((Object)"category") != null) {
                        String[] categoryArr = singleResult.get((Object)"category").toString().split(",");
                        List<String> categories = Arrays.asList(categoryArr);
                        busiQrySKURspBO.setCategories(categories);
                    }
                    if (singleResult.get((Object)"moq") != null) {
                        busiQrySKURspBO.setMoq(Integer.valueOf(String.valueOf(singleResult.get((Object)"moq"))));
                    }
                    if (singleResult.get((Object)"mfgSku") != null) {
                        busiQrySKURspBO.setMfgSku(String.valueOf(singleResult.get((Object)"mfgSku")));
                    }
                    if (singleResult.get((Object)"deliveryTime") != null) {
                        busiQrySKURspBO.setDeliveryTime(String.valueOf(singleResult.get((Object)"deliveryTime")));
                    }
                    if (singleResult.get((Object)"introduction") != null) {
                        busiQrySKURspBO.setIntroduction(String.valueOf(singleResult.get((Object)"introduction")));
                    }
                    if (singleResult.get((Object)"wareQD") != null) {
                        busiQrySKURspBO.setWareQD(String.valueOf(singleResult.get((Object)"wareQD")));
                    }
                }
            }
            catch (Exception e) {
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
        }
        return busiQrySKURspBO;
    }

    private String initReqStr(BusiQrySKUReqBO busiQrySKUReqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"sku\":").append("\"" + busiQrySKUReqBO.getSkuId() + "\"").append(",").append("\"priceFloatRate\":").append(busiQrySKUReqBO.getPriceFloatRate()).append(",").append("\"isShow\":").append(busiQrySKUReqBO.getIsShow()).append("}");
        return sb.toString();
    }

    private String initReqStr(BusiQrySKUGiftReqBO busiQrySKUGiftReqBO) {
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySKUGiftReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        busiQryExtSkuIdReqSkuIds.add(busiQrySKUGiftReqBO.getSkuId());
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"skuId\":").append('\"' + ((BusiQryExtSkuIdRsp)busiQryExtSkuIdRspBO.getResult().get(0)).getExtSkuId() + '\"').append(",").append("\"province\":").append(busiQrySKUGiftReqBO.getProvince()).append(",").append("\"city\":").append(busiQrySKUGiftReqBO.getCity()).append(",").append("\"county\":").append(busiQrySKUGiftReqBO.getCounty()).append(",").append("\"town\":").append(busiQrySKUGiftReqBO.getTown()).append("}");
            return sb.toString();
        }
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private BusiQrySKUGiftRspBO resolveRspMsg(BusiQrySKUGiftReqBO busiQrySKUGiftReqBO, String rspStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        BusiQrySKUGiftRspBO busiQrySKUGiftRspBO = new BusiQrySKUGiftRspBO();
        if (ESB_GIFT_RESULT_CODE.equals(jsonObject.get((Object)"resultCode"))) {
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
            return busiQrySKUGiftRspBO;
        }
        String resultStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            if (!StringUtils.isEmpty((Object)resultStr) && !"null".equals(resultStr)) {
                try {
                    busiQrySKUGiftRspBO = JsonUtils.jsonStringToJavaBean(JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySKUGiftRspBO.class);
                    return busiQrySKUGiftRspBO;
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
                    busiQrySKUGiftRspBO.setRespCode(null);
                    busiQrySKUGiftRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25");
                    return busiQrySKUGiftRspBO;
                }
            }
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
            return busiQrySKUGiftRspBO;
        }
        logger.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25:" + jsonObject.get((Object)"resultMessage"));
        busiQrySKUGiftRspBO.setRespCode("0000");
        busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
        return busiQrySKUGiftRspBO;
    }
}

