/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySKUYanbaoFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUYanbaoReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUYanbaoRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySKUYanbaoRspVO;
import com.cgd.electricitysupplier.busi.vo.SKUYanbaoRspVO;
import com.cgd.electricitysupplier.busi.vo.YanBaoDeatilRspVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.cgd.electricitysupplier.util.JsonUtils;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.BusinessException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySKUYanbaoFromInterServiceImpl
implements QrySKUYanbaoFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUYanbaoFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiQrySKUYanbaoRspBO qrySKUYanbao(BusiQrySKUYanbaoReqBO busiQrySKUYanbaoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySKUYanbaoReqBO.toString());
        }
        BusiQrySKUYanbaoRspBO busiQrySKUYanbaoRspBO = new BusiQrySKUYanbaoRspBO();
        if (busiQrySKUYanbaoReqBO.getSkuIds().size() > 50) {
            throw new BusinessException("RSP_CODE_SKU_NUM_MORE", "\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6700\u591a\u652f\u630150\u79cd\u5546\u54c1");
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            ArrayList<String> extSkuIds = new ArrayList<String>();
            List<BusiQryExtSkuIdRsp> busiQryExtSkuIdRsps = this.getExtSkuIds(busiQrySKUYanbaoReqBO);
            String reqStr = this.initReqStr(busiQrySKUYanbaoReqBO, busiQryExtSkuIdRsps, existSkuIds, extSkuIds);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySKUYanbaoReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_YANBAO_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_SKU_YANBAO_URL") + "]");
                busiQrySKUYanbaoRspBO.setRespCode(null);
                busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u7cfb\u7edf\u5931\u8d25");
                return busiQrySKUYanbaoRspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUYanbaoRspBO.setRespCode("RSP_CODE_THREE_DATA_NULL");
                busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUYanbaoRspBO;
            }
            busiQrySKUYanbaoRspBO = this.resolveRspMsg(returnString, existSkuIds, extSkuIds, busiQryExtSkuIdRsps, busiQrySKUYanbaoReqBO.getSupplierId());
            return busiQrySKUYanbaoRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                busiQrySKUYanbaoRspBO.setRespCode(resultCode);
                busiQrySKUYanbaoRspBO.setRespDesc("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1:" + e.getMessage());
                return busiQrySKUYanbaoRspBO;
            }
            busiQrySKUYanbaoRspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            busiQrySKUYanbaoRspBO.setRespDesc("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
            return busiQrySKUYanbaoRspBO;
        }
    }

    private List<BusiQryExtSkuIdRsp> getExtSkuIds(BusiQrySKUYanbaoReqBO busiQrySKUYanbaoReqBO) {
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySKUYanbaoReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        for (Long inSkuId : busiQrySKUYanbaoReqBO.getSkuIds()) {
            busiQryExtSkuIdReqSkuIds.add(inSkuId);
        }
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            return busiQryExtSkuIdRspBO.getResult();
        }
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private String initReqStr(BusiQrySKUYanbaoReqBO busiQrySKUYanbaoReqBO, List<BusiQryExtSkuIdRsp> busiQryExtSkuIdRsps, List<Long> existSkuIds, List<String> extSkuIds) {
        ArrayList<String> reqSkuIds = new ArrayList<String>();
        for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRsps) {
            extSkuIds.add(busiQryExtSkuIdRsp.getExtSkuId());
            reqSkuIds.add('\"' + busiQryExtSkuIdRsp.getExtSkuId() + '\"');
        }
        for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRsps) {
            busiQrySKUYanbaoReqBO.getSkuIds().remove(busiQryExtSkuIdRsp.getSkuId());
        }
        existSkuIds.addAll(busiQrySKUYanbaoReqBO.getSkuIds());
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"skuIds\":").append(reqSkuIds).append(",").append("\"province\":").append(busiQrySKUYanbaoReqBO.getProvince()).append(",").append("\"city\":").append(busiQrySKUYanbaoReqBO.getCity()).append(",").append("\"county\":").append(busiQrySKUYanbaoReqBO.getCounty()).append(",").append("\"town\":").append(busiQrySKUYanbaoReqBO.getTown()).append("}");
        return sb.toString();
    }

    private BusiQrySKUYanbaoRspBO resolveRspMsg(String rspStr, List<Long> existSkuIds, List<String> extSkuIds, List<BusiQryExtSkuIdRsp> busiQryExtSkuIdRsps, Long supplierId) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        ArrayList resultBusiQrySKUYanbaoRspVOs = new ArrayList();
        BusiQrySKUYanbaoRspBO busiQrySKUYanbaoRspBO = new BusiQrySKUYanbaoRspBO();
        if (!existSkuIds.isEmpty()) {
            String existSkuIdStr = "";
            for (int i = 0; i < existSkuIds.size(); ++i) {
                existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
            }
            busiQrySKUYanbaoRspBO.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
        }
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    BusiQrySKUYanbaoRspVO[] busiQrySKUYanbaoRspVOArr = JsonUtils.jsonStringToJavaBean(JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySKUYanbaoRspVO[].class);
                    List<BusiQrySKUYanbaoRspVO> busiQrySKUYanbaoRspVOs = Arrays.asList(busiQrySKUYanbaoRspVOArr);
                    ArrayList<BusiQrySKUYanbaoRspVO> busiQrySKUYanbaoRsps = new ArrayList<BusiQrySKUYanbaoRspVO>();
                    for (BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO : busiQrySKUYanbaoRspVOs) {
                        BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRsp = new BusiQrySKUYanbaoRspVO();
                        if (null != busiQrySKUYanbaoRspVO.getYanBao()) {
                            this.calcYanbaoPrice(busiQrySKUYanbaoRspVO.getYanBao(), supplierId);
                        }
                        busiQrySKUYanbaoRsp.setSkuId(busiQrySKUYanbaoRspVO.getSkuId());
                        busiQrySKUYanbaoRsp.setYanBao(busiQrySKUYanbaoRspVO.getYanBao());
                        for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRsps) {
                            if (!busiQryExtSkuIdRsp.getExtSkuId().equals(busiQrySKUYanbaoRspVO.getSkuId())) continue;
                            busiQrySKUYanbaoRsp.setInnerSkuId(busiQryExtSkuIdRsp.getSkuId());
                        }
                        busiQrySKUYanbaoRsps.add(busiQrySKUYanbaoRsp);
                    }
                    resultBusiQrySKUYanbaoRspVOs.addAll(busiQrySKUYanbaoRsps);
                    for (BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO : busiQrySKUYanbaoRspVOs) {
                        extSkuIds.remove(busiQrySKUYanbaoRspVO.getSkuId());
                    }
                    for (String skuId : extSkuIds) {
                        BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO = new BusiQrySKUYanbaoRspVO();
                        busiQrySKUYanbaoRspVO.setSkuId(skuId);
                        busiQrySKUYanbaoRspVO.setYanBao(null);
                        for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRsps) {
                            if (!busiQryExtSkuIdRsp.getExtSkuId().equals(skuId)) continue;
                            busiQrySKUYanbaoRspVO.setInnerSkuId(busiQryExtSkuIdRsp.getSkuId());
                        }
                        resultBusiQrySKUYanbaoRspVOs.add(busiQrySKUYanbaoRspVO);
                    }
                    busiQrySKUYanbaoRspBO.setSkuYanbaos(resultBusiQrySKUYanbaoRspVOs);
                    return busiQrySKUYanbaoRspBO;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
                    busiQrySKUYanbaoRspBO.setRespCode(null);
                    busiQrySKUYanbaoRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25");
                    return busiQrySKUYanbaoRspBO;
                }
            }
            logger.info("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            busiQrySKUYanbaoRspBO.setRespCode(null);
            busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            return busiQrySKUYanbaoRspBO;
        }
        for (String skuId : extSkuIds) {
            BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO = new BusiQrySKUYanbaoRspVO();
            busiQrySKUYanbaoRspVO.setSkuId(skuId);
            busiQrySKUYanbaoRspVO.setYanBao(null);
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRsps) {
                if (!busiQryExtSkuIdRsp.getExtSkuId().equals(skuId)) continue;
                busiQrySKUYanbaoRspVO.setInnerSkuId(busiQryExtSkuIdRsp.getSkuId());
            }
            resultBusiQrySKUYanbaoRspVOs.add(busiQrySKUYanbaoRspVO);
        }
        busiQrySKUYanbaoRspBO.setSkuYanbaos(resultBusiQrySKUYanbaoRspVOs);
        return busiQrySKUYanbaoRspBO;
    }

    private void calcYanbaoPrice(List<SKUYanbaoRspVO> yanBao, Long supplierId) {
        for (SKUYanbaoRspVO sKUYanbaoRspVO : yanBao) {
            List yanBaoDeatilList = sKUYanbaoRspVO.getFuwuSkuDetailList();
            for (YanBaoDeatilRspVO yanBaoDeatilRspVO : yanBaoDeatilList) {
                yanBaoDeatilRspVO.setSalePrice(yanBaoDeatilRspVO.getPrice());
                if (1L == supplierId) {
                    yanBaoDeatilRspVO.setPrice(yanBaoDeatilRspVO.getPrice().multiply(new BigDecimal(1.04)).setScale(2, 1));
                    continue;
                }
                yanBaoDeatilRspVO.setPrice(yanBaoDeatilRspVO.getPrice().multiply(new BigDecimal(1.04)).setScale(2, 1));
            }
        }
    }
}

