/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySkuStateService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.SkuStateReqBO;
import com.cgd.electricitysupplier.busi.bo.SkuStateRsp;
import com.cgd.electricitysupplier.busi.bo.SkuStateRspBo;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.BusinessException;
import com.ohaotian.plugin.base.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySkuStateServiceImpl
implements QrySkuStateService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuStateServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public SkuStateRsp qrySkuStatus(SkuStateReqBO skuStateReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuStateReqBO.toString());
        }
        SkuStateRsp skuStateRsp = new SkuStateRsp();
        if (null == skuStateReqBO.getSupplierId()) {
            skuStateRsp.setRespCode("RSP_CODE_PARA_NOT_NULL");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546supplierId[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            return skuStateRsp;
        }
        if (skuStateReqBO.getIsExtSkuId().booleanValue()) {
            if (skuStateReqBO.getExtSkuIds().isEmpty()) {
                skuStateRsp.setRespCode("RSP_CODE_PARA_NOT_NULL");
                skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5546\u54c1ID\u96c6\u5408[extSkuIds]\u4e0d\u80fd\u4e3a\u7a7a");
                return skuStateRsp;
            }
        } else if (skuStateReqBO.getSkuIds().isEmpty()) {
            skuStateRsp.setRespCode("RSP_CODE_PARA_NOT_NULL");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5546\u54c1ID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
            return skuStateRsp;
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String reqStr = this.initReqStr(skuStateReqBO, existSkuIds);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + skuStateReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_STATE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_AREA_LIMIT_URL") + "]");
                skuStateRsp.setRespCode(null);
                skuStateRsp.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u5931\u8d25");
                return skuStateRsp;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                skuStateRsp.setRespCode("RSP_CODE_THREE_DATA_NULL");
                skuStateRsp.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return skuStateRsp;
            }
            skuStateRsp = this.resolveRspMsg(returnString, existSkuIds);
            return skuStateRsp;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                skuStateRsp.setRespCode(resultCode);
                skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e.getMessage());
                return skuStateRsp;
            }
            skuStateRsp.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return skuStateRsp;
        }
    }

    public Properties getProp() {
        return this.prop;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    private String initReqStr(SkuStateReqBO skuStateReqBO, List<Long> existSkuIds) {
        if (null != skuStateReqBO.getIsExtSkuId() && skuStateReqBO.getIsExtSkuId().booleanValue()) {
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (String extSkuId : skuStateReqBO.getExtSkuIds()) {
                extSkuIds.add('\"' + extSkuId + '\"');
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(skuStateReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        for (Long inSkuId : skuStateReqBO.getSkuIds()) {
            busiQryExtSkuIdReqSkuIds.add(inSkuId);
        }
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                extSkuIds.add('\"' + busiQryExtSkuIdRsp.getExtSkuId() + '\"');
            }
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                skuStateReqBO.getSkuIds().remove(busiQryExtSkuIdRsp.getSkuId());
            }
            existSkuIds.addAll(skuStateReqBO.getSkuIds());
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private SkuStateRsp resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        SkuStateRsp skuStateRsp = new SkuStateRsp();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    SkuStateRspBo[] skuStateRspBoArr = JsonUtils.jsonStringToJavaBean(JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), SkuStateRspBo[].class);
                    List<SkuStateRspBo> skuStateRspBos = Arrays.asList(skuStateRspBoArr);
                    skuStateRsp.setSkuStates(skuStateRspBos);
                    if (!StringUtils.isEmpty((Object)JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")))) {
                        skuStateRsp.setResultMessage(JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                    }
                    if (!existSkuIds.isEmpty()) {
                        String existSkuIdStr = "";
                        for (int i = 0; i < existSkuIds.size(); ++i) {
                            existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                        }
                        skuStateRsp.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                    }
                    return skuStateRsp;
                }
                catch (Exception e) {
                    logger.error("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + e);
                    skuStateRsp.setRespCode(null);
                    skuStateRsp.setRespDesc("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
                    return skuStateRsp;
                }
            }
            logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            skuStateRsp.setRespCode(null);
            skuStateRsp.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return skuStateRsp;
        }
        logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\uff1a" + jsonObject.get((Object)"resultMessage"));
        skuStateRsp.setRespCode(null);
        skuStateRsp.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        return skuStateRsp;
    }
}

