/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesUtil {
    private static Properties props;

    private static synchronized void loadProps() {
        props = new Properties();
        InputStream in = null;
        try {
            in = PropertiesUtil.class.getClassLoader().getResourceAsStream("env.properties");
            props.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getProperty(String key) {
        if (null == props) {
            PropertiesUtil.loadProps();
        }
        return props.getProperty(key);
    }

    public static int getIntProperty(String key) {
        if (null == props) {
            PropertiesUtil.loadProps();
        }
        return Integer.parseInt(props.getProperty(key));
    }

    public static boolean getBooleanProperty(String key) {
        if (null == props) {
            PropertiesUtil.loadProps();
        }
        return Boolean.getBoolean(props.getProperty(key));
    }

    public static String getProperty(String key, String defaultValue) {
        if (null == props) {
            PropertiesUtil.loadProps();
        }
        return props.getProperty(key, defaultValue);
    }

    static {
        PropertiesUtil.loadProps();
    }
}

