/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.com.alibaba.fastjson.JSON;
import com.cgd.electricitysupplier.busi.QryMsgFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryMsgReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryMsgRspBO;
import com.cgd.electricitysupplier.busi.bo.ResultVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class QryMsgFromInterServiceImpl
implements QryMsgFromInterService {
    private static final Log log = LogFactory.getLog(QryMsgFromInterServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private Properties prop;

    public BusiQryMsgRspBO qryMsg(BusiQryMsgReqBO busiQryMsgReqBO) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiQryMsgReqBO.toString()));
        }
        BusiQryMsgRspBO busiQryMsgRspBO = new BusiQryMsgRspBO();
        try {
            String returnString;
            String reqStr = this.initReqStr(busiQryMsgReqBO);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQryMsgReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_MSG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("JD_SUBMIT_ORDER_URL") + "]"));
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            if (this.isDebugEnabled) {
                log.debug((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            }
            if (StringUtils.isEmpty((Object)(returnString = httpRetBean.getStr()))) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiQryMsgRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                log.debug((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            resolveRsp.setRespCode("0000");
            resolveRsp.setRespDesc("\u6210\u529f");
            return resolveRsp;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + e));
            }
            busiQryMsgRspBO.setRespCode("8888");
            busiQryMsgRspBO.setRespDesc("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return busiQryMsgRspBO;
        }
    }

    private String initReqStr(BusiQryMsgReqBO busiQryMsgReqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"type\":" + busiQryMsgReqBO.getType()).append("}");
        return sb.toString();
    }

    private BusiQryMsgRspBO resolveRsp(String returnString) {
        BusiQryMsgRspBO busiQryMsgRspBO = new BusiQryMsgRspBO();
        ArrayList<ResultVO> list = new ArrayList<ResultVO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            busiQryMsgRspBO.setResultCode(Integer.valueOf((String)rspJsonObject.get((Object)"resultCode")).intValue());
            busiQryMsgRspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    ResultVO jsonStringToJavaBean = (ResultVO)JSON.parseObject((String)jsonStr, ResultVO.class);
                    list.add(jsonStringToJavaBean);
                }
                busiQryMsgRspBO.setResult(list);
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e));
            }
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return busiQryMsgRspBO;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }
}

