/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySKUAreaLimitFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUAreaLimitReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUAreaLimitRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySKUAreaLimitRspVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySKUAreaLimitFromInterServiceImpl
implements QrySKUAreaLimitFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUAreaLimitFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiQrySKUAreaLimitRspBO qrySKUAreaLimit(BusiQrySKUAreaLimitReqBO busiQrySKUAreaLimitReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySKUAreaLimitReqBO.toString());
        }
        BusiQrySKUAreaLimitRspBO busiQrySKUAreaLimitRspBO = new BusiQrySKUAreaLimitRspBO();
        if (busiQrySKUAreaLimitReqBO.getSkuIds().size() > 100) {
            busiQrySKUAreaLimitRspBO.setRespCode("RSP_CODE_SKU_NUM_MORE");
            busiQrySKUAreaLimitRspBO.setRespDesc("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u83b7\u53d6\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
            return busiQrySKUAreaLimitRspBO;
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String reqStr = this.initReqStr(busiQrySKUAreaLimitReqBO, existSkuIds);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySKUAreaLimitReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_AREA_LIMIT_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_AREA_LIMIT_URL") + "]");
                busiQrySKUAreaLimitRspBO.setRespCode("8888");
                busiQrySKUAreaLimitRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u5931\u8d25");
                return busiQrySKUAreaLimitRspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUAreaLimitRspBO.setRespCode("8888");
                busiQrySKUAreaLimitRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUAreaLimitRspBO;
            }
            busiQrySKUAreaLimitRspBO = this.resolveRspMsg(returnString, existSkuIds);
            return busiQrySKUAreaLimitRspBO;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                busiQrySKUAreaLimitRspBO.setRespCode(resultCode);
                busiQrySKUAreaLimitRspBO.setRespDesc("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1:" + e.getMessage());
                return busiQrySKUAreaLimitRspBO;
            }
            busiQrySKUAreaLimitRspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            busiQrySKUAreaLimitRspBO.setRespDesc("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return busiQrySKUAreaLimitRspBO;
        }
    }

    private String initReqStr(BusiQrySKUAreaLimitReqBO busiQrySKUAreaLimitReqBO, List<Long> existSkuIds) {
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySKUAreaLimitReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        for (Long inSkuId : busiQrySKUAreaLimitReqBO.getSkuIds()) {
            busiQryExtSkuIdReqSkuIds.add(inSkuId);
        }
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                extSkuIds.add('\"' + busiQryExtSkuIdRsp.getExtSkuId() + '\"');
            }
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                busiQrySKUAreaLimitReqBO.getSkuIds().remove(busiQryExtSkuIdRsp.getSkuId());
            }
            existSkuIds.addAll(busiQrySKUAreaLimitReqBO.getSkuIds());
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"skuIds\":").append(extSkuIds).append(",").append("\"province\":").append(busiQrySKUAreaLimitReqBO.getProvince()).append(",").append("\"city\":").append(busiQrySKUAreaLimitReqBO.getCity()).append(",").append("\"county\":").append(busiQrySKUAreaLimitReqBO.getCounty()).append(",").append("\"town\":").append(busiQrySKUAreaLimitReqBO.getTown()).append("}");
            return sb.toString();
        }
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private BusiQrySKUAreaLimitRspBO resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        BusiQrySKUAreaLimitRspBO busiQrySKUAreaLimitRspBO = new BusiQrySKUAreaLimitRspBO();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    BusiQrySKUAreaLimitRspVO[] busiQrySKUAreaLimitRspVOArr = (BusiQrySKUAreaLimitRspVO[])JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySKUAreaLimitRspVO[].class);
                    List<BusiQrySKUAreaLimitRspVO> busiQrySKUAreaLimitRspVOs = Arrays.asList(busiQrySKUAreaLimitRspVOArr);
                    busiQrySKUAreaLimitRspBO.setSkuAreaLimits(busiQrySKUAreaLimitRspVOs);
                    if (!StringUtils.isEmpty((Object)JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")))) {
                        logger.info("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587" + JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                        busiQrySKUAreaLimitRspBO.setResultMessage(JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                    }
                    if (!existSkuIds.isEmpty()) {
                        String existSkuIdStr = "";
                        for (int i = 0; i < existSkuIds.size(); ++i) {
                            existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                        }
                        busiQrySKUAreaLimitRspBO.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                    }
                    busiQrySKUAreaLimitRspBO.setIsSuccess(Boolean.valueOf(true));
                    busiQrySKUAreaLimitRspBO.setRespCode("0000");
                    busiQrySKUAreaLimitRspBO.setRespDesc("\u6210\u529f");
                    return busiQrySKUAreaLimitRspBO;
                }
                catch (Exception e) {
                    logger.error("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + e);
                    busiQrySKUAreaLimitRspBO.setRespCode(null);
                    busiQrySKUAreaLimitRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
                    return busiQrySKUAreaLimitRspBO;
                }
            }
            logger.info("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            busiQrySKUAreaLimitRspBO.setRespCode(null);
            busiQrySKUAreaLimitRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return busiQrySKUAreaLimitRspBO;
        }
        logger.info("\u6279\u91cf\u67e5\u8be2\u533a\u57df\u8d2d\u4e70\u9650\u5236\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\uff1a" + jsonObject.get((Object)"resultMessage"));
        busiQrySKUAreaLimitRspBO.setIsSuccess((Boolean)jsonObject.get((Object)"success"));
        busiQrySKUAreaLimitRspBO.setResultMessage(jsonObject.get((Object)"resultMessage").toString());
        busiQrySKUAreaLimitRspBO.setRespCode("8888");
        busiQrySKUAreaLimitRspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        return busiQrySKUAreaLimitRspBO;
    }
}

