/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySKUStockFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUStockReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUStockRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySKUStockRspVO;
import com.cgd.electricitysupplier.busi.vo.QrySKUStockSkuNumReqVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySKUStockFromInterServiceImpl
implements QrySKUStockFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUStockFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiQrySKUStockRspBO qrySKUStock(BusiQrySKUStockReqBO busiQrySKUStockReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySKUStockReqBO.toString());
        }
        BusiQrySKUStockRspBO busiQrySKUStockRspBO = new BusiQrySKUStockRspBO();
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String reqStr = this.initReqStr(busiQrySKUStockReqBO, existSkuIds);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySKUStockReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_STOCK_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6279\u91cf\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("JD_NEW_STOCK_URL") + "]");
                busiQrySKUStockRspBO.setRespCode(null);
                busiQrySKUStockRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6279\u91cf\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3\u5931\u8d25");
                return busiQrySKUStockRspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6279\u91cf\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUStockRspBO.setRespCode("8888");
                busiQrySKUStockRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6279\u91cf\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUStockRspBO;
            }
            busiQrySKUStockRspBO = this.resolveRspMsg(returnString, existSkuIds);
            return busiQrySKUStockRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                busiQrySKUStockRspBO.setRespCode("8888");
                busiQrySKUStockRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1:" + e.getMessage());
                return busiQrySKUStockRspBO;
            }
            busiQrySKUStockRspBO.setRespCode("8888");
            busiQrySKUStockRspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u5931\u8d25");
            return busiQrySKUStockRspBO;
        }
    }

    private String initReqStr(BusiQrySKUStockReqBO busiQrySKUStockReqBO, List<Long> existSkuIds) {
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySKUStockReqBO.getSupplierId());
        List skuNums = busiQrySKUStockReqBO.getSkuNums();
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"area\":").append("\"").append(busiQrySKUStockReqBO.getArea()).append("\",").append("\"skuNums\":").append("[");
        for (int i = 0; i < skuNums.size(); ++i) {
            ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
            busiQryExtSkuIdReqSkuIds.add(((QrySKUStockSkuNumReqVO)skuNums.get(i)).getSkuId());
            busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
            BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
            if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
                if (!busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                    String extSkuId = ((BusiQryExtSkuIdRsp)busiQryExtSkuIdRspBO.getResult().get(0)).getExtSkuId();
                    if (i == skuNums.size() - 1) {
                        sb.append("{\"skuId\":'").append('\"' + extSkuId + '\"').append("',\"num\":").append(((QrySKUStockSkuNumReqVO)skuNums.get(i)).getNum()).append("}");
                    } else {
                        sb.append("{\"skuId\":'").append('\"' + extSkuId + '\"').append("',\"num\":").append(((QrySKUStockSkuNumReqVO)skuNums.get(i)).getNum()).append("},");
                    }
                } else {
                    existSkuIds.add(((QrySKUStockSkuNumReqVO)skuNums.get(i)).getSkuId());
                }
            }
            if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) continue;
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
            }
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        sb.append("]}");
        JSONObject json = JSONObject.parseObject((String)sb.toString());
        if ("[]".equals(JSONObject.toJSONString((Object)json.get((Object)"skuNums")))) {
            throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
        }
        return sb.toString();
    }

    private BusiQrySKUStockRspBO resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        BusiQrySKUStockRspBO busiQrySKUStockRspBO = new BusiQrySKUStockRspBO();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    BusiQrySKUStockRspVO[] busiQrySKUStockRspVOArr = (BusiQrySKUStockRspVO[])JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySKUStockRspVO[].class);
                    List<BusiQrySKUStockRspVO> busiQrySKUStockRspVOs = Arrays.asList(busiQrySKUStockRspVOArr);
                    busiQrySKUStockRspBO.setSkuStocks(busiQrySKUStockRspVOs);
                    if (!StringUtils.isEmpty((Object)JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")))) {
                        logger.info("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587" + JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                        busiQrySKUStockRspBO.setResultMessage(JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                    }
                    if (!existSkuIds.isEmpty()) {
                        String existSkuIdStr = "";
                        for (int i = 0; i < existSkuIds.size(); ++i) {
                            existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                        }
                        busiQrySKUStockRspBO.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                    }
                    busiQrySKUStockRspBO.setIsSuccess(Boolean.valueOf(true));
                    busiQrySKUStockRspBO.setRespCode("0000");
                    busiQrySKUStockRspBO.setRespDesc("\u6210\u529f");
                    return busiQrySKUStockRspBO;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + e);
                    busiQrySKUStockRspBO.setRespCode(null);
                    busiQrySKUStockRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
                    return busiQrySKUStockRspBO;
                }
            }
            logger.error("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6279\u91cf\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
            busiQrySKUStockRspBO.setRespCode(null);
            busiQrySKUStockRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6279\u91cf\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
            return busiQrySKUStockRspBO;
        }
        logger.error("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6279\u91cf\u83b7\u53d6\u5e93\u5b58\u63a5\u53e3\uff1a" + jsonObject.get((Object)"resultMessage"));
        busiQrySKUStockRspBO.setRespCode(null);
        busiQrySKUStockRspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        return busiQrySKUStockRspBO;
    }
}

