/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySkuPriceService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRsp;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySkuPriceRspVO;
import com.cgd.electricitysupplier.util.ESBParamUtil;
import com.ohaotian.base.util.http.HSHttpHelper;
import com.ohaotian.base.util.http.HSNHttpHeader;
import com.ohaotian.base.util.http.HttpRetBean;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySkuPriceServiceImpl
implements QrySkuPriceService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuPriceServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QryExtSkuIdService qryExtSkuIdService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }

    public BusiQrySkuPriceRspBO qrySkuPrice(BusiQrySkuPriceReqBO busiQrySkuPriceReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySkuPriceReqBO.toString());
        }
        BusiQrySkuPriceRspBO busiQrySkuPriceRspBO = new BusiQrySkuPriceRspBO();
        if (null == busiQrySkuPriceReqBO.getSupplierId()) {
            busiQrySkuPriceRspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
            busiQrySkuPriceRspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            return busiQrySkuPriceRspBO;
        }
        if (null != busiQrySkuPriceReqBO.getIsExtSku()) {
            if (busiQrySkuPriceReqBO.getExtSkuIds().isEmpty()) {
                busiQrySkuPriceRspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
                busiQrySkuPriceRspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5916\u90e8\u5546\u54c1ID\u96c6\u5408[extSkuIds]\u4e0d\u80fd\u4e3a\u7a7a");
                return busiQrySkuPriceRspBO;
            }
            if (busiQrySkuPriceReqBO.getExtSkuIds().size() > 100) {
                busiQrySkuPriceRspBO.setRespCode("RSP_CODE_SKU_NUM_MORE");
                busiQrySkuPriceRspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
                return busiQrySkuPriceRspBO;
            }
        } else {
            if (busiQrySkuPriceReqBO.getSkuIds().isEmpty()) {
                busiQrySkuPriceRspBO.setRespCode("RSP_CODE_PARA_NOT_NULL");
                busiQrySkuPriceRspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5546\u54c1ID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
                return busiQrySkuPriceRspBO;
            }
            if (busiQrySkuPriceReqBO.getSkuIds().size() > 100) {
                busiQrySkuPriceRspBO.setRespCode("RSP_CODE_SKU_NUM_MORE");
                busiQrySkuPriceRspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
                return busiQrySkuPriceRspBO;
            }
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String reqStr = this.initReqStr(busiQrySkuPriceReqBO, existSkuIds);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiQrySkuPriceReqBO.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QRY_SKU_PRICE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_QRY_SKU_PRICE_URL") + "]");
                busiQrySkuPriceRspBO.setRespCode("8888");
                busiQrySkuPriceRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u7cfb\u7edf\u5931\u8d25");
                return busiQrySkuPriceRspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySkuPriceRspBO.setRespCode("8888");
                busiQrySkuPriceRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySkuPriceRspBO;
            }
            busiQrySkuPriceRspBO = this.resolveRspMsg(returnString, existSkuIds);
            return busiQrySkuPriceRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                busiQrySkuPriceRspBO.setRespCode(resultCode);
                busiQrySkuPriceRspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d:" + e.getMessage());
                return busiQrySkuPriceRspBO;
            }
            busiQrySkuPriceRspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            busiQrySkuPriceRspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u5931\u8d25");
            return busiQrySkuPriceRspBO;
        }
    }

    private String initReqStr(BusiQrySkuPriceReqBO busiQrySkuPriceReqBO, List<Long> existSkuIds) {
        if (null != busiQrySkuPriceReqBO.getIsExtSku() && busiQrySkuPriceReqBO.getIsExtSku().booleanValue()) {
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (String skuId : busiQrySkuPriceReqBO.getExtSkuIds()) {
                extSkuIds.add('\"' + skuId + '\"');
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"city\":").append(busiQrySkuPriceReqBO.getCity()).append(",").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        busiQryExtSkuIdReqBO.setSupplierId(busiQrySkuPriceReqBO.getSupplierId());
        ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
        for (Long inSkuId : busiQrySkuPriceReqBO.getSkuIds()) {
            busiQryExtSkuIdReqSkuIds.add(inSkuId);
        }
        busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
        BusiQrySkuPriceRspBO busiQrySkuPriceRspBO = new BusiQrySkuPriceRspBO();
        BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
        if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) {
            if (busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            }
            ArrayList<String> extSkuIds = new ArrayList<String>();
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                extSkuIds.add('\"' + busiQryExtSkuIdRsp.getExtSkuId() + '\"');
            }
            for (BusiQryExtSkuIdRsp busiQryExtSkuIdRsp : busiQryExtSkuIdRspBO.getResult()) {
                busiQrySkuPriceReqBO.getSkuIds().remove(busiQryExtSkuIdRsp.getSkuId());
            }
            existSkuIds.addAll(busiQrySkuPriceReqBO.getSkuIds());
            StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"city\":").append(busiQrySkuPriceReqBO.getCity()).append(",").append("\"sku\":").append(extSkuIds).append("}");
            return sb.toString();
        }
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private BusiQrySkuPriceRspBO resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        BusiQrySkuPriceRspBO busiQrySkuPriceRspBO = new BusiQrySkuPriceRspBO();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    BusiQrySkuPriceRspVO[] busiQrySkuPriceRspVOArr = (BusiQrySkuPriceRspVO[])JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySkuPriceRspVO[].class);
                    List<BusiQrySkuPriceRspVO> busiQrySkuPriceRspVOs = Arrays.asList(busiQrySkuPriceRspVOArr);
                    busiQrySkuPriceRspBO.setSkuPrices(busiQrySkuPriceRspVOs);
                    if (!StringUtils.isEmpty((Object)JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")))) {
                        logger.info("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u89e3\u6790\u54cd\u5e94\u62a5\u6587" + JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                        busiQrySkuPriceRspBO.setResultMessage(JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                    }
                    if (!existSkuIds.isEmpty()) {
                        String existSkuIdStr = "";
                        for (int i = 0; i < existSkuIds.size(); ++i) {
                            existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                        }
                        busiQrySkuPriceRspBO.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                    }
                    busiQrySkuPriceRspBO.setRespCode("0000");
                    busiQrySkuPriceRspBO.setRespDesc("\u6210\u529f");
                    return busiQrySkuPriceRspBO;
                }
                catch (Exception e) {
                    logger.error("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + e);
                    busiQrySkuPriceRspBO.setRespCode("8888");
                    busiQrySkuPriceRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
                    return busiQrySkuPriceRspBO;
                }
            }
            logger.info("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
            busiQrySkuPriceRspBO.setRespCode("8888");
            busiQrySkuPriceRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
            return busiQrySkuPriceRspBO;
        }
        logger.info("\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff1a" + jsonObject.get((Object)"resultMessage"));
        busiQrySkuPriceRspBO.setRespCode("8888");
        busiQrySkuPriceRspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        return busiQrySkuPriceRspBO;
    }
}

