/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.electricitysupplier.util;

import com.alibaba.fastjson.JSONObject;
import com.cgd.electricitysupplier.esb.ESBCommParam;
import com.cgd.electricitysupplier.util.ESBSignUtil;
import com.cgd.electricitysupplier.util.PropertiesUtil;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.ohaotian.plugin.common.util.JsonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESBParamUtil {
    private static final Logger logger = LoggerFactory.getLogger(ESBParamUtil.class);
    private static final String SUPPLIER_ID = "supplierId";
    private static final String ENCODING = "UTF-8";
    private static String appkey = null;
    private static String key = null;

    public static <T> String getEsbReqParam(T t, String hsn, String center) {
        try {
            JSONObject resultJson = new JSONObject();
            JSONObject busiParamJson = (JSONObject)JSONObject.toJSON(t);
            JSONObject esbCommParamJson = ESBParamUtil.getEsbCommParam(hsn, center);
            busiParamJson.remove((Object)SUPPLIER_ID);
            resultJson.putAll((Map)esbCommParamJson);
            resultJson.putAll((Map)busiParamJson);
            return JSONObject.toJSONString((Object)resultJson);
        }
        catch (Exception e) {
            logger.error("ESB\u80fd\u529b\u5e73\u53f0\u62a5\u6587\u5c01\u88c5\u5de5\u5177\u83b7\u53d6ESB\u8bf7\u6c42\u62a5\u6587\u5931" + e);
            throw new RuntimeException("\u83b7\u53d6ESB\u8bf7\u6c42\u62a5\u6587\u5931\u8d25");
        }
    }

    public static <T> String getEsbReqStr(String reqJsonStr, String hsn, String center) {
        try {
            JSONObject resultJson = new JSONObject();
            JSONObject reqJsonObject = JSONObject.parseObject((String)reqJsonStr);
            JSONObject esbCommParamJson = ESBParamUtil.getEsbCommParam(hsn, center);
            resultJson.putAll((Map)esbCommParamJson);
            resultJson.putAll((Map)reqJsonObject);
            return JSONObject.toJSONString((Object)resultJson);
        }
        catch (Exception e) {
            logger.error("ESB\u80fd\u529b\u5e73\u53f0\u62a5\u6587\u5c01\u88c5\u5de5\u5177\u83b7\u53d6ESB\u8bf7\u6c42\u62a5\u6587\u5931" + e);
            throw new RuntimeException("\u83b7\u53d6ESB\u8bf7\u6c42\u62a5\u6587\u5931\u8d25");
        }
    }

    public static <T, B> T parsedEsbRspToObject(Class<T> clazzT, Class<B> clazzB, String rspStr) {
        try {
            Object t = clazzT.newInstance();
            B b = clazzB.newInstance();
            List<Field> fieldArr = ESBParamUtil.getDeclaredField(t.getClass(), Object.class);
            Boolean isHasList = ESBParamUtil.isHasList(fieldArr);
            for (Field field : fieldArr) {
                String name = field.getName();
                if ("RespCode".equals(name = name.substring(0, 1).toUpperCase() + name.substring(1)) || "RespDesc".equals(name)) continue;
                Class<?> fieldClass = field.getType();
                if (isHasList.booleanValue()) {
                    Object[] bResultArr = (Object[])JsonUtils.jsonStringToJavaBean((String)rspStr, Object[].class);
                    List<Object> bResult = Arrays.asList(bResultArr);
                    ESBParamUtil.setValue(fieldClass, name, bResult, t, clazzB);
                    continue;
                }
                t = JsonUtils.jsonStringToJavaBean((String)rspStr, t.getClass());
            }
            return t;
        }
        catch (Exception e) {
            logger.error("ESB\u80fd\u529b\u5e73\u53f0\u62a5\u6587\u5c01\u88c5\u5de5\u5177\u89e3\u6790ESB\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
            throw new RuntimeException("\u89e3\u6790ESB\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
    }

    private static JSONObject getEsbCommParam(String hsn, String center) {
        try {
            ESBCommParam eSBCommParam = new ESBCommParam();
            eSBCommParam.setAppkey(appkey);
            eSBCommParam.setHsn(hsn);
            String timeStamp = ESBParamUtil.getTimeStamp();
            eSBCommParam.setTimeStamp(timeStamp);
            String serialnumber = ESBParamUtil.getSerialNumber(timeStamp, center);
            eSBCommParam.setSerialNumber(serialnumber);
            String token = ESBSignUtil.getESBToken(ENCODING, key, appkey, serialnumber, timeStamp);
            eSBCommParam.setToken(token);
            return (JSONObject)JSONObject.toJSON((Object)eSBCommParam);
        }
        catch (Exception e) {
            logger.error("ESB\u80fd\u529b\u5e73\u53f0\u62a5\u6587\u5c01\u88c5\u5de5\u5177\u83b7\u53d6ESB\u516c\u5171\u53c2\u6570\u5931\u8d25" + e);
            throw new RuntimeException("\u83b7\u53d6ESB\u516c\u5171\u53c2\u6570\u5931\u8d25" + e);
        }
    }

    private static String getTimeStamp() {
        return DelFormatHelper.getNowTimeForString();
    }

    private static String getSerialNumber(String timeStamp, String center) throws ParseException {
        return PropertiesUtil.getProperty(center) + DelFormatHelper.getNowTimeForString((String)timeStamp) + ESBParamUtil.get4Random();
    }

    private static String get4Random() {
        int min = 1000;
        int max = 9999;
        Random random = new Random();
        int resultInt = random.nextInt(max) % (max - min + 1) + min;
        return String.valueOf(resultInt);
    }

    private static <T, B> void setValue(Class<?> fieldClass, String name, Object newValue, T model, Class<B> clazzB) {
        try {
            Method m;
            Object value;
            if (fieldClass.isAssignableFrom(String.class) && (value = (String)(m = model.getClass().getMethod("get" + name, new Class[0])).invoke(model, new Object[0])) == null) {
                m = model.getClass().getMethod("set" + name, String.class);
                m.invoke(model, newValue);
            }
            if (fieldClass.isAssignableFrom(Integer.class) && (value = (Integer)(m = model.getClass().getMethod("get" + name, new Class[0])).invoke(model, new Object[0])) == null) {
                m = model.getClass().getMethod("set" + name, Integer.class);
                m.invoke(model, newValue);
            }
            if (fieldClass.isAssignableFrom(Boolean.class) && (value = (Boolean)(m = model.getClass().getMethod("get" + name, new Class[0])).invoke(model, new Object[0])) == null) {
                m = model.getClass().getMethod("set" + name, Boolean.class);
                m.invoke(model, newValue);
            }
            if (fieldClass.isAssignableFrom(Date.class) && (value = (Date)(m = model.getClass().getMethod("get" + name, new Class[0])).invoke(model, new Object[0])) == null) {
                m = model.getClass().getMethod("set" + name, Date.class);
                m.invoke(model, newValue);
            }
            if (fieldClass.isAssignableFrom(List.class) && (value = (List)(m = model.getClass().getMethod("get" + name, new Class[0])).invoke(model, new Object[0])) == null) {
                m = model.getClass().getMethod("set" + name, List.class);
                m.invoke(model, newValue);
            }
            if (fieldClass.isAssignableFrom(clazzB) && (value = (m = model.getClass().getMethod("get" + name, new Class[0])).invoke(model, new Object[0])) == null) {
                m = model.getClass().getMethod("set" + name, clazzB);
                m.invoke(model, newValue);
            }
        }
        catch (Exception e) {
            logger.error("ESB\u80fd\u529b\u5e73\u53f0\u62a5\u6587\u5c01\u88c5\u5de5\u5177\u89e3\u6790ESB\u54cd\u5e94\u6570\u636e\u7ed9\u5b9e\u4f53\u5c5e\u6027\u8d4b\u503c\u5931\u8d25" + e);
            throw new RuntimeException("\u89e3\u6790ESB\u54cd\u5e94\u6570\u636e\u7ed9\u5b9e\u4f53\u5c5e\u6027\u8d4b\u503c\u5931\u8d25");
        }
    }

    private static List<Field> getDeclaredField(Class<?> c, Class<?> stopClass) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (c != stopClass) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                list.add(field);
            }
            c = c.getSuperclass();
        }
        return list;
    }

    public static Boolean isHasList(List<Field> fieldArr) {
        for (Field field : fieldArr) {
            Class<List> fieldClazz;
            if ("respCode".equals(field.getName()) || "respDesc".equals(field.getName()) || (fieldClazz = field.getType()).isAssignableFrom(List.class)) continue;
            return false;
        }
        return true;
    }

    static {
        appkey = PropertiesUtil.getProperty("ESB_CGD_APPKEY");
        key = PropertiesUtil.getProperty("ESB_CGD_KEY");
    }
}

