/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.cache;

import com.cgd.base.cache.CacheManager;
import com.cgd.base.util.SerializeUtils;
import com.cgd.common.cache.service.CacheExecuterService;
import com.cgd.common.cache.service.CacheService;
import com.ohaotian.plugin.common.util.SerializationUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheServiceImpl
implements CacheService {
    private static final Logger LOG = LoggerFactory.getLogger(CacheServiceImpl.class);
    private static final boolean LOG_DEBUG_ENABLED = LOG.isDebugEnabled();
    private CacheManager cacheManager;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void put(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize(value));
    }

    @Override
    public void put(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize(value), expire);
    }

    @Override
    public Object get(String key) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return SerializeUtils.deserialize(value);
    }

    @Override
    public <T> T get(String key, Class<T> requiredType) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return (T)SerializeUtils.deserialize(value);
    }

    @Override
    public void delete(String key) {
        this.cacheManager.del(key.getBytes());
    }

    @Override
    public <T> T getFinal(CacheExecuterService<T> executer, String ... key) {
        String finalKey = this.getFinalKey(key);
        LOG.debug("[\u57fa\u7840\u7ec4\u4ef6-\u7f13\u5b58\u67e5\u8be2]-finalKey={}", (Object)finalKey);
        byte[] value = this.cacheManager.get(finalKey.getBytes());
        if (value == null || value.length == 0) {
            LOG.debug("\u83b7\u53d6Final\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            T obj = executer.getParamFromDb(key);
            if (obj != null && !"".equals(obj)) {
                LOG.debug("value={}", (Object)obj.toString());
                this.put(finalKey, obj);
                return obj;
            }
            LOG.debug("\u83b7\u53d6Final\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        Object finalValue = SerializeUtils.deserialize(value);
        LOG.debug("value={}", finalValue);
        return (T)finalValue;
    }

    private String getFinalKey(String ... key) {
        StringBuffer fkey = new StringBuffer();
        for (String s : key) {
            fkey.append(s);
            fkey.append("_");
        }
        fkey.setLength(fkey.length() - 1);
        return fkey.toString();
    }

    @Override
    public Set<String> getkeys(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        Set<byte[]> keybs = this.cacheManager.keys(pattern);
        for (byte[] bs : keybs) {
            keys.add(new String(bs));
        }
        return keys;
    }

    @Override
    public Long getExpireTimeByKey(String key) {
        return this.cacheManager.getExpireTimeByKey(key.getBytes());
    }

    @Override
    public Map<String, String> getOuterCodeByKey(CacheExecuterService<Map<String, String>> executer, String ... key) {
        byte[] value;
        String finalKey = this.getRedisKey(executer, this.getFinalKey(key));
        if (LOG_DEBUG_ENABLED) {
            LOG.debug("getOuterCodeByKey finalKey={}", (Object)finalKey);
        }
        if ((value = this.cacheManager.get(finalKey.getBytes())) == null || value.length == 0) {
            LOG.debug("OuterCodeKey\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            Map<String, String> obj = executer.getParamFromDb(key);
            if (obj.size() > 0) {
                if (LOG_DEBUG_ENABLED) {
                    LOG.debug("outerCode={},outerCodeDesc={}", (Object)obj.get("outerCode"), (Object)obj.get("outerCodeDesc"));
                }
                this.put(finalKey, obj);
            } else if (LOG_DEBUG_ENABLED) {
                LOG.debug("\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            }
            return obj;
        }
        return (Map)SerializeUtils.deserialize(value);
    }

    @Override
    public Map<String, String> getInnerCodeByKey(CacheExecuterService<Map<String, String>> executer, String ... key) {
        byte[] value;
        String finalKey = this.getRedisKey(executer, this.getFinalKey(key));
        if (LOG_DEBUG_ENABLED) {
            LOG.debug("getInnerCodeByKey finalKey={}", (Object)finalKey);
        }
        if ((value = this.cacheManager.get(finalKey.getBytes())) == null || value.length == 0) {
            if (LOG_DEBUG_ENABLED) {
                LOG.debug("InnerCode\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            }
            Map<String, String> obj = executer.getInnerParamFromDb(key);
            if (LOG_DEBUG_ENABLED) {
                LOG.debug("innerCode\u548cinnerCodeDesc\u6240\u5728Map", obj);
            }
            if (obj.size() > 0) {
                this.put(finalKey, obj);
            }
            return obj;
        }
        return (Map)SerializeUtils.deserialize(value);
    }

    @Override
    public Object getByFST(String key) {
        byte[] value = this.cacheManager.get(key.getBytes());
        return value == null ? null : SerializationUtils.deserializeSlightly((byte[])value);
    }

    @Override
    public void setValueExpireTimeAt(String key, Long expire) {
        this.cacheManager.setValueExpireTimeAt(key.getBytes(), expire);
    }

    @Override
    public boolean setNx(String key, String value, Long seconds) {
        return this.cacheManager.setNx(key, value, seconds);
    }

    private String getRedisKey(CacheExecuterService<Map<String, String>> executer, String finalKey) {
        if (executer.getClass().toString().contains("user")) {
            finalKey = finalKey + "_" + "user";
        }
        if (executer.getClass().toString().contains("order")) {
            finalKey = finalKey + "_" + "order";
        }
        if (executer.getClass().toString().contains("commodity")) {
            finalKey = finalKey + "_" + "commodity";
        }
        if (executer.getClass().toString().contains("pay")) {
            finalKey = finalKey + "_" + "pay";
        }
        if (executer.getClass().toString().contains("workflow")) {
            finalKey = finalKey + "_" + "workflow";
        }
        return finalKey;
    }
}

